/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.signals.shared;

import com.vaadin.flow.signals.shared.SharedListSignal;
import com.vaadin.flow.signals.shared.SharedMapSignal;
import com.vaadin.flow.signals.shared.SharedNodeSignal;
import com.vaadin.flow.signals.shared.SharedNumberSignal;
import com.vaadin.flow.signals.shared.SharedValueSignal;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class SharedSignalSerializationTest {
    SharedSignalSerializationTest() {
    }

    private <T> T assertSerializeAndDeserialize(T obj) {
        try {
            return this.serializeAndDeserialize(obj);
        }
        catch (Throwable e) {
            Assertions.fail((String)("Not Serializable: " + e.getClass().getName() + ": " + e.getMessage()));
            return null;
        }
    }

    <T> T serializeAndDeserialize(T instance) throws Throwable {
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(bs);
        out.writeObject(instance);
        byte[] data = bs.toByteArray();
        ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(data));
        Object readObject = in.readObject();
        return (T)readObject;
    }

    @Test
    void sharedValueSignal_serializable() {
        SharedValueSignal signal = new SharedValueSignal((Object)"");
        this.assertSerializeAndDeserialize(signal);
        signal.set((Object)"Test");
        this.assertSerializeAndDeserialize(signal);
    }

    @Test
    void sharedListSignal_serializable() {
        SharedListSignal signal = new SharedListSignal(String.class);
        this.assertSerializeAndDeserialize(signal);
        signal.insertFirst((Object)"Test");
        this.assertSerializeAndDeserialize(signal);
    }

    @Test
    void sharedMapSignal_serializable() {
        SharedMapSignal signal = new SharedMapSignal(String.class);
        this.assertSerializeAndDeserialize(signal);
        signal.put("key", (Object)"Test");
        this.assertSerializeAndDeserialize(signal);
    }

    @Test
    void sharedNodeSignal_serializable() {
        SharedNodeSignal signal = new SharedNodeSignal();
        this.assertSerializeAndDeserialize(signal);
        signal.putChildWithValue("key", (Object)"Test");
        signal = this.assertSerializeAndDeserialize(signal);
        SharedNodeSignal child = (SharedNodeSignal)((SharedNodeSignal.SharedNodeSignalState)signal.peek()).mapChildren().get("key");
        Assertions.assertNotNull((Object)child);
        Assertions.assertEquals((Object)"Test", (Object)((SharedNodeSignal.SharedNodeSignalState)child.peek()).value(String.class));
    }

    @Test
    void sharedNumberSignal_serializable() {
        SharedNumberSignal signal = new SharedNumberSignal(0.0);
        this.assertSerializeAndDeserialize(signal);
        signal.set((Object)123.45);
        this.assertSerializeAndDeserialize(signal);
    }
}

