/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.signals.impl;

import com.vaadin.flow.signals.MissingSignalUsageException;
import com.vaadin.flow.signals.Signal;
import com.vaadin.flow.signals.SignalTestBase;
import com.vaadin.flow.signals.function.EffectAction;
import com.vaadin.flow.signals.function.SignalComputation;
import com.vaadin.flow.signals.function.SignalMapper;
import com.vaadin.flow.signals.function.TransactionTask;
import com.vaadin.flow.signals.impl.Transaction;
import com.vaadin.flow.signals.local.ValueSignal;
import com.vaadin.flow.signals.shared.AbstractSignal;
import com.vaadin.flow.signals.shared.SharedValueSignal;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;
import org.jspecify.annotations.Nullable;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ComputedSignalTest
extends SignalTestBase {
    @Test
    void value_constantCallback_throws() {
        Signal signal = Signal.computed((SignalComputation & Serializable)() -> "const");
        Assertions.assertThrows(MissingSignalUsageException.class, () -> ((Signal)signal).peek());
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    void value_constantCallback_runOnceAndConstantSignalValue() {
        ValueSignal<Integer> dependency = ComputedSignalTest.createDependency();
        AtomicInteger count = new AtomicInteger();
        @Nullable Signal signal = Signal.computed((SignalComputation & Serializable)() -> {
            dependency.get();
            count.incrementAndGet();
            return null;
        });
        Assertions.assertNull((Object)signal.peek());
        Assertions.assertEquals((int)1, (int)count.intValue());
        signal.peek();
        Assertions.assertEquals((int)1, (int)count.intValue());
    }

    @Test
    void value_readSignal_runLazily() {
        SharedValueSignal source = new SharedValueSignal((Object)"value");
        ArrayList invocations = new ArrayList();
        Signal signal = Signal.computed((SignalComputation & Serializable)() -> {
            String value = (String)source.get();
            invocations.add(value);
            return value;
        });
        Assertions.assertEquals(List.of(), invocations);
        Assertions.assertEquals((Object)"value", (Object)signal.peek());
        Assertions.assertEquals(List.of("value"), invocations);
        source.set((Object)"update");
        Assertions.assertEquals(List.of("value"), invocations);
        Assertions.assertEquals((Object)"update", (Object)signal.peek());
        Assertions.assertEquals(List.of("value", "update"), invocations);
    }

    @Test
    void value_noOpChange_notRunAgain() {
        SharedValueSignal source = new SharedValueSignal((Object)"value");
        AtomicInteger count = new AtomicInteger();
        Signal signal = Signal.computed((SignalComputation & Serializable)() -> {
            count.incrementAndGet();
            return (String)source.get();
        });
        signal.peek();
        Assertions.assertEquals((int)1, (int)count.intValue());
        source.set((Object)((String)source.peek()));
        signal.peek();
        Assertions.assertEquals((int)1, (int)count.intValue());
    }

    @Test
    void map_mapComputedSignal_valueIsMapped() {
        SharedValueSignal source = new SharedValueSignal((Object)"value");
        Signal computed = Signal.computed((SignalComputation & Serializable)() -> ((String)source.get()).length());
        Signal doubled = computed.map((SignalMapper & Serializable)l -> l * 2);
        Assertions.assertEquals((int)10, (Integer)((Integer)doubled.peek()));
    }

    @Test
    void map_mapMappedSignal_valueIsMapped() {
        SharedValueSignal source = new SharedValueSignal((Object)"value");
        Signal computed = source.map(String::length);
        Signal doubled = computed.map((SignalMapper & Serializable)l -> l * 2);
        Assertions.assertEquals((int)10, (Integer)((Integer)doubled.peek()));
    }

    @Test
    void map_countCallbackInvocations_invocationsAreNotCached() {
        SharedValueSignal source = new SharedValueSignal((Object)"value");
        AtomicInteger count = new AtomicInteger();
        Signal computed = source.map((SignalMapper & Serializable)value -> {
            count.incrementAndGet();
            return value.length();
        });
        Assertions.assertEquals((int)0, (int)count.get());
        computed.peek();
        Assertions.assertEquals((int)1, (int)count.get());
        computed.peek();
        Assertions.assertEquals((int)2, (int)count.get());
    }

    @Test
    void not_booleanInputs_negatedOutputs() {
        SharedValueSignal signal = new SharedValueSignal((Object)Boolean.TRUE);
        Signal negated = Signal.not((Signal)signal);
        Assertions.assertFalse((boolean)((Boolean)negated.peek()));
        signal.set((Object)false);
        Assertions.assertTrue((boolean)((Boolean)negated.peek()));
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    void callback_updateOtherSignal_signalUpdated() {
        ValueSignal<Integer> dependency = ComputedSignalTest.createDependency();
        SharedValueSignal other = new SharedValueSignal((Object)"value");
        @Nullable Signal signal = Signal.computed((SignalComputation & Serializable)() -> {
            dependency.get();
            other.set((Object)"update");
            return null;
        });
        signal.peek();
        Assertions.assertEquals((Object)"update", (Object)other.peek());
    }

    @Test
    void effect_changeComputedDependency_effectRunAgain() {
        SharedValueSignal source = new SharedValueSignal((Object)"value");
        AtomicInteger count = new AtomicInteger();
        Signal signal = Signal.computed((SignalComputation & Serializable)() -> {
            count.incrementAndGet();
            return (String)source.get();
        });
        ArrayList invocations = new ArrayList();
        Signal.unboundEffect((EffectAction & Serializable)() -> invocations.add((String)signal.get()));
        Assertions.assertEquals((int)1, (int)count.get());
        Assertions.assertEquals(List.of("value"), invocations);
        source.set((Object)"update");
        Assertions.assertEquals((int)2, (int)count.get());
        Assertions.assertEquals(List.of("value", "update"), invocations);
    }

    @Test
    void effect_noOpChangeInComputedDependency_effectNotRunAgainButRemainsActive() {
        SharedValueSignal source = new SharedValueSignal((Object)"value1");
        AtomicInteger count = new AtomicInteger();
        Signal signal = Signal.computed((SignalComputation & Serializable)() -> {
            count.incrementAndGet();
            return ((String)source.get()).length();
        });
        ArrayList invocations = new ArrayList();
        Signal.unboundEffect((EffectAction & Serializable)() -> invocations.add((Integer)signal.get()));
        Assertions.assertEquals((int)1, (int)count.get());
        Assertions.assertEquals(List.of(Integer.valueOf(6)), invocations);
        source.set((Object)"value2");
        Assertions.assertEquals((int)2, (int)count.get());
        Assertions.assertEquals(List.of(Integer.valueOf(6)), invocations);
        source.set((Object)"value");
        Assertions.assertEquals((int)3, (int)count.get());
        Assertions.assertEquals(List.of(Integer.valueOf(6), Integer.valueOf(5)), invocations);
    }

    @Test
    void effect_signalUpdatedInTransaction_effectIsUpdated() {
        SharedValueSignal source = new SharedValueSignal((Object)"value");
        AtomicInteger computeCount = new AtomicInteger();
        Signal signal = Signal.computed((SignalComputation & Serializable)() -> {
            computeCount.incrementAndGet();
            return (String)source.get();
        });
        ArrayList invocations = new ArrayList();
        Signal.unboundEffect((EffectAction & Serializable)() -> invocations.add((String)signal.get()));
        Signal.runInTransaction((TransactionTask & Serializable)() -> source.set((Object)"update"));
        Assertions.assertEquals((int)2, (int)computeCount.intValue());
        Assertions.assertEquals(List.of("value", "update"), invocations);
    }

    @Test
    void effect_closedEffect_computedGarbageCollected() {
        SharedValueSignal source = new SharedValueSignal((Object)"value");
        Signal signal = Signal.computed((SignalComputation & Serializable)() -> (String)source.get());
        final ArrayList invocations = new ArrayList();
        class CapturingRunnable
        implements EffectAction {
            private final Signal<String> signal;

            CapturingRunnable(Signal<String> signal) {
                this.signal = signal;
            }

            public void execute() {
                invocations.add((String)this.signal.get());
            }
        }
        Signal.unboundEffect((EffectAction)new CapturingRunnable(signal)).remove();
        Assertions.assertEquals(List.of("value"), invocations);
        WeakReference<Signal> ref = new WeakReference<Signal>(signal);
        signal = null;
        Assertions.assertTrue((boolean)ComputedSignalTest.waitForGarbageCollection(ref));
    }

    @Test
    void transaction_readInCommittedTransaction_notCoumptedAgainAfterTransaction() {
        SharedValueSignal source = new SharedValueSignal((Object)"value");
        AtomicInteger count = new AtomicInteger();
        Signal signal = Signal.computed((SignalComputation & Serializable)() -> {
            count.incrementAndGet();
            return (String)source.get();
        });
        signal.peek();
        Assertions.assertEquals((int)1, (int)count.get());
        Transaction.runInTransaction((TransactionTask & Serializable)() -> {
            source.set((Object)"update");
            signal.get();
            Assertions.assertEquals((int)2, (int)count.get());
        });
        signal.peek();
        Assertions.assertEquals((int)2, (int)count.get());
    }

    @Test
    void transaction_readInAbortedTransaction_valueRestoredAfterRejection() {
        SharedValueSignal source = new SharedValueSignal((Object)"value");
        AtomicInteger count = new AtomicInteger();
        Signal signal = Signal.computed((SignalComputation & Serializable)() -> {
            count.incrementAndGet();
            return (String)source.get();
        });
        Assertions.assertEquals((Object)"value", (Object)signal.peek());
        Assertions.assertEquals((int)1, (int)count.get());
        Transaction.runInTransaction((TransactionTask & Serializable)() -> {
            source.set((Object)"update");
            Assertions.assertEquals((Object)"update", (Object)signal.get());
            Assertions.assertEquals((int)2, (int)count.get());
            source.verifyValue((Object)"other");
        });
        Assertions.assertEquals((Object)"value", (Object)signal.peek());
        Assertions.assertEquals((int)3, (int)count.get());
    }

    @Test
    void unsuppotedOperations_runOperations_throws() {
        AbstractSignal signal = (AbstractSignal)Signal.computed((SignalComputation & Serializable)() -> null);
        Assertions.assertThrows(UnsupportedOperationException.class, () -> signal.peekConfirmed());
    }

    @Test
    void lambda_computesValue_computedNotCached() {
        SharedValueSignal signal = new SharedValueSignal((Object)1);
        AtomicInteger count = new AtomicInteger();
        Signal & Serializable doubled = (Signal & Serializable)() -> {
            count.incrementAndGet();
            return (Integer)signal.get() * 2;
        };
        Assertions.assertEquals((int)2, (Integer)((Integer)doubled.peek()));
        Assertions.assertEquals((int)1, (int)count.intValue());
        Assertions.assertEquals((int)2, (Integer)((Integer)doubled.peek()));
        Assertions.assertEquals((int)2, (int)count.intValue());
        signal.set((Object)3);
        Assertions.assertEquals((int)2, (int)count.intValue());
        Assertions.assertEquals((int)6, (Integer)((Integer)doubled.peek()));
        Assertions.assertEquals((int)3, (int)count.intValue());
    }

    @Test
    void exceptionHandling_callbackThrows_rethrowWhenReading() {
        SharedValueSignal shouldThrow = new SharedValueSignal((Object)false);
        AtomicInteger count = new AtomicInteger();
        Signal computed = Signal.computed((SignalComputation & Serializable)() -> {
            count.incrementAndGet();
            if (((Boolean)shouldThrow.get()).booleanValue()) {
                throw new RuntimeException("Expected exception");
            }
            return (Boolean)shouldThrow.get();
        });
        Assertions.assertFalse((boolean)((Boolean)computed.peek()));
        Assertions.assertEquals((int)1, (int)count.get());
        shouldThrow.set((Object)true);
        Assertions.assertThrows(RuntimeException.class, () -> computed.peek());
        Assertions.assertEquals((int)2, (int)count.get());
        Assertions.assertThrows(RuntimeException.class, () -> computed.peek());
        Assertions.assertEquals((int)2, (int)count.get(), (String)"Exception should be cached");
        shouldThrow.set((Object)false);
        Assertions.assertFalse((boolean)((Boolean)computed.peek()));
        Assertions.assertEquals((int)3, (int)count.get());
    }

    private static boolean waitForGarbageCollection(WeakReference<?> ref) {
        long deadline = System.nanoTime() + Duration.ofMillis(100L).toNanos();
        while (System.nanoTime() < deadline) {
            System.gc();
            if (ref.get() == null) {
                return true;
            }
            LockSupport.parkNanos(Duration.ofMillis(10L).toNanos());
        }
        return false;
    }
}

