/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.signals;

import com.vaadin.flow.signals.SignalEnvironment;
import com.vaadin.flow.signals.SignalTestBase;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SignalEnvironmentTest
extends SignalTestBase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void registerAndUnregister_environmentIsUsedUntilUnregistered() {
        final Thread testThread = Thread.currentThread();
        final AtomicInteger count = new AtomicInteger();
        SignalEnvironment environment = new SignalEnvironment(this){

            public boolean isActive() {
                return Thread.currentThread() == testThread;
            }

            public Executor getResultNotifier() {
                count.incrementAndGet();
                return Runnable::run;
            }

            public Executor getEffectDispatcher() {
                return Runnable::run;
            }
        };
        SignalEnvironment.getCurrentResultNotifier();
        Assertions.assertEquals((int)0, (int)count.get());
        Runnable unregister = SignalEnvironment.register((SignalEnvironment)environment);
        try {
            SignalEnvironment.getCurrentResultNotifier();
            Assertions.assertEquals((int)1, (int)count.get());
        }
        finally {
            unregister.run();
        }
        SignalEnvironment.getCurrentResultNotifier();
        Assertions.assertEquals((int)1, (int)count.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void isActive_environmentUsedOnlyWhenActive() {
        final ThreadLocal<Boolean> active = new ThreadLocal<Boolean>();
        final AtomicInteger count = new AtomicInteger();
        SignalEnvironment environment = new SignalEnvironment(this){

            public boolean isActive() {
                return active.get() == Boolean.TRUE;
            }

            public Executor getResultNotifier() {
                count.incrementAndGet();
                return Runnable::run;
            }

            public Executor getEffectDispatcher() {
                return Runnable::run;
            }
        };
        Runnable unregister = SignalEnvironment.register((SignalEnvironment)environment);
        try {
            SignalEnvironment.getCurrentResultNotifier();
            Assertions.assertEquals((int)0, (int)count.get());
            active.set(Boolean.TRUE);
            SignalEnvironment.getCurrentResultNotifier();
            Assertions.assertEquals((int)1, (int)count.get());
        }
        finally {
            unregister.run();
        }
    }

    @Test
    void resultNotifier_noNotifier_runsImmediately() {
        AtomicInteger count = new AtomicInteger();
        SignalEnvironment.getCurrentResultNotifier().execute(() -> count.incrementAndGet());
        Assertions.assertEquals((int)1, (int)count.get());
    }

    @Test
    void resultNotifier_notifierDefined_runsThroughDefinedNotifier() {
        AtomicInteger count = new AtomicInteger();
        SignalTestBase.TestExecutor notifier = this.useTestResultNotifier();
        SignalEnvironment.getCurrentResultNotifier().execute(() -> count.incrementAndGet());
        Assertions.assertEquals((int)0, (int)count.get());
        notifier.runPendingTasks();
        Assertions.assertEquals((int)1, (int)count.get());
    }

    @Test
    void effectDispatcher_noDispathcer_runsImmediately() {
        AtomicInteger count = new AtomicInteger();
        SignalEnvironment.getDefaultEffectDispatcher().execute(() -> count.incrementAndGet());
        Assertions.assertEquals((int)1, (int)count.get());
    }

    @Test
    void effectDispatcher_setWhenDispatching_runThroughDispatcher() {
        AtomicInteger count = new AtomicInteger();
        SignalTestBase.TestExecutor testDispatcher = this.useTestEffectDispatcher();
        SignalEnvironment.getDefaultEffectDispatcher().execute(() -> count.incrementAndGet());
        Assertions.assertEquals((int)0, (int)count.get());
        testDispatcher.runPendingTasks();
        Assertions.assertEquals((int)1, (int)count.get());
    }
}

