/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.startup;

import com.vaadin.flow.di.Lookup;
import com.vaadin.flow.server.startup.ClassLoaderAwareServletContainerInitializer;
import com.vaadin.flow.server.startup.DeferredServletContextInitializers;
import com.vaadin.flow.testutil.ClassFinder;
import jakarta.servlet.ServletContainerInitializer;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class ServletContainerInitializerTest
extends ClassFinder {
    ServletContainerInitializerTest() {
    }

    @Test
    public void servletContextHasNoLookup_deferredServletContextInitializersAttributeIsSet_processIsNotExecuted() throws ServletException {
        final AtomicBoolean processIsExecuted = new AtomicBoolean();
        ClassLoaderAwareServletContainerInitializer initializer = new ClassLoaderAwareServletContainerInitializer(){

            public void process(Set<Class<?>> set, ServletContext ctx) throws ServletException {
                processIsExecuted.set(true);
            }
        };
        ServletContext context = (ServletContext)Mockito.mock(ServletContext.class);
        initializer.onStartup(Collections.emptySet(), context);
        ((ServletContext)Mockito.verify((Object)context)).setAttribute((String)Mockito.eq((Object)DeferredServletContextInitializers.class.getName()), Mockito.any());
        Assertions.assertFalse((boolean)processIsExecuted.get());
    }

    @Test
    public void servletContextHasLookup_deferredServletContextInitializersAttributeIsNotSet_processIsExecuted() throws ServletException {
        final AtomicBoolean processIsExecuted = new AtomicBoolean();
        ClassLoaderAwareServletContainerInitializer initializer = new ClassLoaderAwareServletContainerInitializer(){

            public void process(Set<Class<?>> set, ServletContext ctx) throws ServletException {
                processIsExecuted.set(true);
            }
        };
        ServletContext context = (ServletContext)Mockito.mock(ServletContext.class);
        Mockito.when((Object)context.getAttribute(Lookup.class.getName())).thenReturn(Mockito.mock(Lookup.class));
        Mockito.when((Object)context.getClassLoader()).thenReturn((Object)initializer.getClass().getClassLoader());
        initializer.onStartup(Collections.emptySet(), context);
        ((ServletContext)Mockito.verify((Object)context, (VerificationMode)Mockito.times((int)0))).setAttribute((String)Mockito.eq((Object)DeferredServletContextInitializers.class.getName()), Mockito.any());
        Assertions.assertTrue((boolean)processIsExecuted.get());
    }

    @Test
    public void anyServletContainerInitializerSubclassImplementsFixedServletContainerInitializer() throws IOException {
        List rawClasspathEntries = ServletContainerInitializerTest.getRawClasspathEntries();
        List excludes = this.getExcludedPatterns().map(Pattern::compile).collect(Collectors.toList());
        ArrayList classes = new ArrayList();
        for (String location : rawClasspathEntries) {
            if (this.isTestClassPath(location)) continue;
            classes.addAll(this.findServerClasses(location, excludes));
        }
        ArrayList<String> brokenInitializers = new ArrayList<String>();
        for (String className : classes) {
            if (className.equals(ClassLoaderAwareServletContainerInitializer.class.getName())) continue;
            try {
                Class<?> clazz = Class.forName(className);
                if (clazz.isAnnotation() || clazz.isSynthetic() || !ServletContainerInitializer.class.isAssignableFrom(clazz) || !this.isBadSubType(clazz)) continue;
                brokenInitializers.add(className);
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        Assertions.assertTrue((boolean)brokenInitializers.isEmpty(), (String)(String.valueOf(brokenInitializers) + " classes are subtypes of " + String.valueOf(ServletContainerInitializer.class) + " but either are not subtypes of " + String.valueOf(ClassLoaderAwareServletContainerInitializer.class) + " or override " + ClassLoaderAwareServletContainerInitializer.class.getName() + ".onStartup method"));
    }

    private Stream<String> getExcludedPatterns() {
        return Stream.of("com\\.vaadin\\.flow\\..*osgi\\..*", "com\\.vaadin\\.flow\\.server\\.startup\\.LookupInitializer\\$OsgiLookupImpl", "com\\.vaadin\\.frontendtools\\.internal\\..*");
    }

    private boolean isBadSubType(Class<?> clazz) {
        if (!ClassLoaderAwareServletContainerInitializer.class.isAssignableFrom(clazz)) {
            return true;
        }
        Method onStartUpMethod = Stream.of(ServletContainerInitializer.class.getDeclaredMethods()).filter(method -> !method.isSynthetic()).findFirst().get();
        return Stream.of(clazz.getDeclaredMethods()).anyMatch(method -> this.sameSignature((Method)method, onStartUpMethod));
    }

    private boolean sameSignature(Method method1, Method method2) {
        return method1.getName().equals(method2.getName()) && method1.getReturnType().equals(method2.getReturnType()) && Arrays.asList(method1.getParameterTypes()).equals(Arrays.asList(method2.getParameterTypes()));
    }
}

