/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.communication;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.server.SystemMessages;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.VaadinSessionState;
import com.vaadin.flow.server.WrappedSession;
import com.vaadin.flow.server.communication.MetadataWriter;
import java.io.IOException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import tools.jackson.databind.node.ObjectNode;

class MetadataWriterTest {
    private UI ui;
    private VaadinSession session;
    private SystemMessages messages;

    MetadataWriterTest() {
    }

    @BeforeEach
    public void setup() {
        this.ui = (UI)Mockito.mock(UI.class);
        this.session = (VaadinSession)Mockito.mock(VaadinSession.class);
        Mockito.when((Object)this.ui.getSession()).thenReturn((Object)this.session);
        this.messages = (SystemMessages)Mockito.mock(SystemMessages.class);
    }

    private void disableSessionExpirationMessages(SystemMessages messages) {
        Mockito.when((Object)messages.isSessionExpiredNotificationEnabled()).thenReturn((Object)true);
        Mockito.when((Object)messages.getSessionExpiredMessage()).thenReturn(null);
        Mockito.when((Object)messages.getSessionExpiredCaption()).thenReturn(null);
    }

    @Test
    public void writeAsyncTag() throws Exception {
        this.assertMetadataOutput(false, true, "{\"async\":true}");
    }

    @Test
    public void writeRepaintTag() throws Exception {
        this.assertMetadataOutput(true, false, "{\"repaintAll\":true}");
    }

    @Test
    public void writeRepaintAndAsyncTag() throws Exception {
        this.assertMetadataOutput(true, true, "{\"repaintAll\":true,\"async\":true}");
    }

    @Test
    public void writeRedirectWithExpiredSession() throws Exception {
        this.disableSessionExpirationMessages(this.messages);
        this.assertMetadataOutput(false, false, "{}");
    }

    @Test
    public void writeRedirectWithActiveSession() throws Exception {
        WrappedSession wrappedSession = (WrappedSession)Mockito.mock(WrappedSession.class);
        Mockito.when((Object)this.session.getSession()).thenReturn((Object)wrappedSession);
        this.disableSessionExpirationMessages(this.messages);
        this.assertMetadataOutput(false, false, "{\"timedRedirect\":{\"interval\":15,\"url\":\"\"}}");
    }

    @Test
    public void writeAsyncWithSystemMessages() throws IOException {
        WrappedSession wrappedSession = (WrappedSession)Mockito.mock(WrappedSession.class);
        Mockito.when((Object)this.session.getSession()).thenReturn((Object)wrappedSession);
        this.disableSessionExpirationMessages(this.messages);
        this.assertMetadataOutput(false, true, "{\"async\":true,\"timedRedirect\":{\"interval\":15,\"url\":\"\"}}");
    }

    @Test
    public void writeSessionExpiredTag_sessionIsOpen() throws Exception {
        Mockito.when((Object)this.session.getState()).thenReturn((Object)VaadinSessionState.OPEN);
        this.assertMetadataOutput(false, false, "{}");
    }

    @Test
    public void writeSessionExpiredTag_sessionIsClosing() throws Exception {
        Mockito.when((Object)this.session.getState()).thenReturn((Object)VaadinSessionState.CLOSING);
        this.assertMetadataOutput(false, false, "{\"sessionExpired\":true}");
        Mockito.when((Object)this.session.getState()).thenReturn((Object)VaadinSessionState.CLOSED);
        this.assertMetadataOutput(false, false, "{\"sessionExpired\":true}");
    }

    @Test
    public void writeSessionExpiredTag_sessionIsClosed() throws Exception {
        Mockito.when((Object)this.session.getState()).thenReturn((Object)VaadinSessionState.CLOSED);
        this.assertMetadataOutput(false, false, "{\"sessionExpired\":true}");
    }

    private void assertMetadataOutput(boolean repaintAll, boolean async, String expectedOutput) {
        ObjectNode meta = new MetadataWriter().createMetadata(this.ui, repaintAll, async, this.messages);
        Assertions.assertEquals((Object)expectedOutput, (Object)meta.toString());
    }
}

