/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.di.Lookup;
import com.vaadin.flow.internal.ApplicationClassLoaderAccess;
import com.vaadin.flow.internal.CurrentInstance;
import com.vaadin.flow.internal.VaadinContextInitializer;
import com.vaadin.flow.server.MockServletServiceSessionSetup;
import com.vaadin.flow.server.ServiceException;
import com.vaadin.flow.server.StaticFileHandler;
import com.vaadin.flow.server.StaticFileHandlerFactory;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinServlet;
import com.vaadin.flow.server.VaadinServletRequest;
import com.vaadin.flow.server.VaadinServletService;
import com.vaadin.flow.server.VaadinSession;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import net.jcip.annotations.NotThreadSafe;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;

@NotThreadSafe
class VaadinServletTest {
    VaadinServletTest() {
    }

    @Test
    public void testGetLastPathParameter() {
        Assertions.assertEquals((Object)"", (Object)VaadinServlet.getLastPathParameter((String)"http://myhost.com"));
        Assertions.assertEquals((Object)";a", (Object)VaadinServlet.getLastPathParameter((String)"http://myhost.com;a"));
        Assertions.assertEquals((Object)"", (Object)VaadinServlet.getLastPathParameter((String)"http://myhost.com/hello"));
        Assertions.assertEquals((Object)";b=c", (Object)VaadinServlet.getLastPathParameter((String)"http://myhost.com/hello;b=c"));
        Assertions.assertEquals((Object)"", (Object)VaadinServlet.getLastPathParameter((String)"http://myhost.com/hello/"));
        Assertions.assertEquals((Object)"", (Object)VaadinServlet.getLastPathParameter((String)"http://myhost.com/hello;a/"));
        Assertions.assertEquals((Object)"", (Object)VaadinServlet.getLastPathParameter((String)"http://myhost.com/hello;a=1/"));
        Assertions.assertEquals((Object)";b", (Object)VaadinServlet.getLastPathParameter((String)"http://myhost.com/hello/;b"));
        Assertions.assertEquals((Object)";b=1", (Object)VaadinServlet.getLastPathParameter((String)"http://myhost.com/hello/;b=1"));
        Assertions.assertEquals((Object)";b=1,c=2", (Object)VaadinServlet.getLastPathParameter((String)"http://myhost.com/hello/;b=1,c=2"));
        Assertions.assertEquals((Object)"", (Object)VaadinServlet.getLastPathParameter((String)"http://myhost.com/hello/;b=1,c=2/"));
        Assertions.assertEquals((Object)"", (Object)VaadinServlet.getLastPathParameter((String)"http://myhost.com/a;hello/;a/"));
        Assertions.assertEquals((Object)"", (Object)VaadinServlet.getLastPathParameter((String)"http://myhost.com/a;hello/;a=1/"));
        Assertions.assertEquals((Object)";b", (Object)VaadinServlet.getLastPathParameter((String)"http://myhost.com/a;hello/;b"));
        Assertions.assertEquals((Object)";b=1", (Object)VaadinServlet.getLastPathParameter((String)"http://myhost.com/a;hello/;b=1"));
        Assertions.assertEquals((Object)";b=1,c=2", (Object)VaadinServlet.getLastPathParameter((String)"http://myhost.com/a;hello/;b=1,c=2"));
        Assertions.assertEquals((Object)"", (Object)VaadinServlet.getLastPathParameter((String)"http://myhost.com/a;hello/;b=1,c=2/"));
    }

    @Test
    public void init_superInitCalledOnce() throws ServletException {
        final AtomicBoolean called = new AtomicBoolean();
        VaadinServlet servlet = new VaadinServlet(){

            public void init() throws ServletException {
                Assertions.assertFalse((boolean)called.get());
                called.set(true);
            }
        };
        ServletConfig config = this.mockConfig();
        servlet.init(config);
        Assertions.assertTrue((boolean)called.get());
        servlet.init(config);
        Assertions.assertSame((Object)config, (Object)servlet.getServletConfig());
    }

    @Test
    public void init_passDifferentConfigInstance_throws() throws ServletException {
        VaadinServlet servlet = new VaadinServlet();
        ServletConfig config = this.mockConfig();
        servlet.init(config);
        Assertions.assertThrows(IllegalArgumentException.class, () -> servlet.init(this.mockConfig()));
    }

    @Test
    public void init_noLookup_servletIsNotInitialized() throws ServletException {
        final AtomicBoolean called = new AtomicBoolean();
        VaadinServlet servlet = new VaadinServlet(){

            protected void servletInitialized() throws ServletException {
                called.set(true);
            }
        };
        ServletConfig config = this.mockConfig();
        servlet.init(config);
        Assertions.assertFalse((boolean)called.get());
    }

    @Test
    public void init_contextHasLookup_servletIsInitialized() throws ServletException {
        final AtomicBoolean called = new AtomicBoolean();
        VaadinServlet servlet = new VaadinServlet(){

            protected VaadinServletService createServletService() throws ServletException, ServiceException {
                return (VaadinServletService)Mockito.mock(VaadinServletService.class);
            }

            protected StaticFileHandler createStaticFileHandler(VaadinService servletService) {
                return (StaticFileHandler)Mockito.mock(StaticFileHandler.class);
            }

            protected void servletInitialized() throws ServletException {
                called.set(true);
            }
        };
        ServletConfig config = this.mockConfig();
        ServletContext servletContext = config.getServletContext();
        Mockito.when((Object)servletContext.getAttribute(Lookup.class.getName())).thenReturn(Mockito.mock(Lookup.class));
        servlet.init(config);
        Assertions.assertTrue((boolean)called.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void init_initServlet_CurrentInstanceClearAllIsCalled() throws ServletException {
        try {
            VaadinServlet servlet = new VaadinServlet(){

                public void init() throws ServletException {
                    VaadinSession.setCurrent((VaadinSession)((VaadinSession)Mockito.mock(VaadinSession.class)));
                }

                protected VaadinServletService createServletService() throws ServletException, ServiceException {
                    VaadinService.setCurrent((VaadinService)((VaadinService)Mockito.mock(VaadinService.class)));
                    return (VaadinServletService)Mockito.mock(VaadinServletService.class);
                }

                protected StaticFileHandler createStaticFileHandler(VaadinService servletService) {
                    return (StaticFileHandler)Mockito.mock(StaticFileHandler.class);
                }

                protected void servletInitialized() throws ServletException {
                    UI.setCurrent((UI)new UI());
                }
            };
            ServletConfig config = this.mockConfig();
            ServletContext servletContext = config.getServletContext();
            Mockito.when((Object)servletContext.getAttribute(Lookup.class.getName())).thenReturn(Mockito.mock(Lookup.class));
            servlet.init(config);
            Assertions.assertNull((Object)VaadinService.getCurrent());
            Assertions.assertNull((Object)UI.getCurrent());
            Assertions.assertNull((Object)VaadinSession.getCurrent());
        }
        finally {
            CurrentInstance.clearAll();
        }
    }

    @Test
    public void init_initOnlyConfig_CurrentInstanceClearAllIsCalled() throws ServletException {
        try {
            VaadinServlet servlet = new VaadinServlet(){

                public void init() throws ServletException {
                    VaadinService.setCurrent((VaadinService)((VaadinService)Mockito.mock(VaadinService.class)));
                }
            };
            ServletConfig config = this.mockConfig();
            servlet.init(config);
            Assertions.assertNull((Object)VaadinService.getCurrent());
        }
        finally {
            CurrentInstance.clearAll();
        }
    }

    @Test
    public void init_appClassLoaderIsSet() throws ServletException {
        VaadinServlet servlet = new VaadinServlet();
        ServletConfig config = this.mockConfig();
        ServletContext servletContext = config.getServletContext();
        ClassLoader loader = (ClassLoader)Mockito.mock(ClassLoader.class);
        Mockito.when((Object)servletContext.getClassLoader()).thenReturn((Object)loader);
        servlet.init(config);
        ArgumentCaptor captor = ArgumentCaptor.forClass(ApplicationClassLoaderAccess.class);
        ((ServletContext)Mockito.verify((Object)servletContext)).setAttribute((String)Mockito.eq((Object)ApplicationClassLoaderAccess.class.getName()), captor.capture());
        ApplicationClassLoaderAccess access = (ApplicationClassLoaderAccess)captor.getValue();
        Assertions.assertSame((Object)loader, (Object)access.getClassloader());
    }

    @Test
    public void init_contextInitializationIsExecuted() throws ServletException {
        VaadinServlet servlet = new VaadinServlet();
        ServletConfig config = this.mockConfig();
        ServletContext servletContext = config.getServletContext();
        ClassLoader loader = (ClassLoader)Mockito.mock(ClassLoader.class);
        VaadinContextInitializer initializer = (VaadinContextInitializer)Mockito.mock(VaadinContextInitializer.class);
        Mockito.when((Object)servletContext.getAttribute(VaadinContextInitializer.class.getName())).thenReturn((Object)initializer);
        Mockito.when((Object)servletContext.getClassLoader()).thenReturn((Object)loader);
        servlet.init(config);
        ((VaadinContextInitializer)Mockito.verify((Object)initializer)).initialize((VaadinContext)Mockito.any(VaadinContext.class));
    }

    @Test
    public void init_initIsCalledAfterDestroy_passDifferentConfigInstance_servletIsInitialized() throws ServletException {
        VaadinServlet servlet = new VaadinServlet();
        ServletConfig config = this.mockConfig();
        servlet.init(config);
        Assertions.assertSame((Object)config, (Object)servlet.getServletConfig());
        servlet.destroy();
        ServletConfig newConfig = this.mockConfig();
        servlet.init(newConfig);
        Assertions.assertSame((Object)newConfig, (Object)servlet.getServletConfig());
    }

    @Test
    public void destroy_servletIsInitializedBeforeDestroy_servletConfigIsNullAfterDestroy() throws ServletException {
        VaadinServlet servlet = new VaadinServlet();
        ServletConfig config = this.mockConfig();
        servlet.init(config);
        servlet.destroy();
        Assertions.assertNull((Object)servlet.getServletConfig());
    }

    @Test
    public void createStaticFileHandler_delegateToStaticFileHandlerFactory() {
        VaadinServlet servlet = new VaadinServlet();
        VaadinService service = (VaadinService)Mockito.mock(VaadinService.class);
        VaadinContext context = (VaadinContext)Mockito.mock(VaadinContext.class);
        Mockito.when((Object)service.getContext()).thenReturn((Object)context);
        Lookup lookup = (Lookup)Mockito.mock(Lookup.class);
        Mockito.when((Object)((Lookup)context.getAttribute(Lookup.class))).thenReturn((Object)lookup);
        StaticFileHandlerFactory factory = (StaticFileHandlerFactory)Mockito.mock(StaticFileHandlerFactory.class);
        Mockito.when((Object)((StaticFileHandlerFactory)lookup.lookup(StaticFileHandlerFactory.class))).thenReturn((Object)factory);
        StaticFileHandler handler = (StaticFileHandler)Mockito.mock(StaticFileHandler.class);
        Mockito.when((Object)factory.createHandler(service)).thenReturn((Object)handler);
        StaticFileHandler result = servlet.createStaticFileHandler(service);
        ((StaticFileHandlerFactory)Mockito.verify((Object)factory)).createHandler(service);
        Assertions.assertSame((Object)handler, (Object)result);
    }

    @Test
    public void destroy_servletConfigAvailableInServbiceDestroy() throws ServletException {
        final VaadinServletService service = (VaadinServletService)Mockito.mock(VaadinServletService.class);
        VaadinServlet servlet = new VaadinServlet(){

            public VaadinServletService getService() {
                return service;
            }
        };
        AtomicReference configDuringDestroy = new AtomicReference();
        ((VaadinServletService)Mockito.doAnswer(invocation -> {
            configDuringDestroy.set(servlet.getServletConfig());
            return null;
        }).when((Object)service)).destroy();
        ServletConfig config = this.mockConfig();
        servlet.init(config);
        servlet.destroy();
        Assertions.assertSame((Object)config, configDuringDestroy.get());
    }

    private ServletConfig mockConfig() {
        ServletConfig config = (ServletConfig)Mockito.mock(ServletConfig.class);
        ServletContext context = (ServletContext)Mockito.mock(ServletContext.class);
        Mockito.when((Object)config.getServletContext()).thenReturn((Object)context);
        return config;
    }

    private HttpServletRequest createRequest(final MockServletServiceSessionSetup mocks, final String path) {
        HttpServletRequest httpServletRequest = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        return new VaadinServletRequest(this, httpServletRequest, mocks.getService()){

            public String getPathInfo() {
                return path;
            }

            public String getServletPath() {
                return "";
            }

            public ServletContext getServletContext() {
                return mocks.getServletContext();
            }
        };
    }
}

