/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server;

import com.vaadin.flow.server.VaadinServletConfig;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class VaadinServletConfigTest {
    private VaadinServletConfig config;
    private ServletContext servletContext;
    private final Map<String, Object> attributeMap = new HashMap<String, Object>();
    private Map<String, String> properties;

    VaadinServletConfigTest() {
    }

    @BeforeEach
    public void setup() {
        ServletConfig servletConfig = (ServletConfig)Mockito.mock(ServletConfig.class);
        this.servletContext = (ServletContext)Mockito.mock(ServletContext.class);
        Mockito.when((Object)servletConfig.getServletContext()).thenReturn((Object)this.servletContext);
        Mockito.when((Object)this.servletContext.getAttribute(Mockito.anyString())).then(invocationOnMock -> this.attributeMap.get(invocationOnMock.getArguments()[0].toString()));
        ((ServletContext)Mockito.doAnswer(invocationOnMock -> this.attributeMap.put(invocationOnMock.getArguments()[0].toString(), invocationOnMock.getArguments()[1])).when((Object)this.servletContext)).setAttribute(Mockito.anyString(), Mockito.any());
        this.properties = new HashMap<String, String>();
        this.properties.put("productionMode", "true");
        this.properties.put("frontend.hotdeploy", "false");
        Mockito.when((Object)servletConfig.getInitParameterNames()).thenReturn(Collections.enumeration(this.properties.keySet()));
        Mockito.when((Object)servletConfig.getInitParameter(Mockito.anyString())).then(invocation -> this.properties.get(invocation.getArguments()[0]));
        this.config = new VaadinServletConfig(servletConfig);
    }

    @Test
    public void getPropertyNames_returnsExpectedProperties() {
        ArrayList list = Collections.list(this.config.getConfigParameterNames());
        Assertions.assertEquals((int)this.properties.size(), (int)list.size(), (String)"Context should return only keys defined in ServletContext");
        for (String key : this.properties.keySet()) {
            Assertions.assertEquals((Object)this.properties.get(key), (Object)this.config.getConfigParameter(key), (String)String.format("Value should be same from context for key '%s'", key));
        }
    }

    @Test
    public void vaadinContextThroughConfig_setAndGetAttribute() {
        String value = "my-attribute";
        this.config.getVaadinContext().setAttribute((Object)value);
        String result = (String)this.config.getVaadinContext().getAttribute(String.class);
        Assertions.assertEquals((Object)value, (Object)result);
        String newValue = "this is a new value";
        this.config.getVaadinContext().setAttribute((Object)newValue);
        result = (String)this.config.getVaadinContext().getAttribute(String.class);
        Assertions.assertEquals((Object)newValue, (Object)result);
        result = (String)this.config.getVaadinContext().getAttribute(String.class, () -> {
            throw new AssertionError((Object)"Should not be called");
        });
        Assertions.assertEquals((Object)newValue, (Object)result);
    }
}

