/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.internal.CurrentInstance;
import com.vaadin.flow.server.AbstractStreamResource;
import com.vaadin.flow.server.InputStreamFactory;
import com.vaadin.flow.server.MockVaadinServletService;
import com.vaadin.flow.server.ServiceException;
import com.vaadin.flow.server.StreamRegistration;
import com.vaadin.flow.server.StreamResource;
import com.vaadin.flow.server.StreamResourceRegistry;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinServletService;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.streams.ElementRequestHandler;
import jakarta.servlet.ServletException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.util.Optional;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class StreamResourceRegistryTest {
    private UI ui;
    private VaadinServletService service;
    private VaadinSession session;

    StreamResourceRegistryTest() {
    }

    @BeforeEach
    public void setUp() throws ServletException, ServiceException {
        this.service = new MockVaadinServletService();
        this.session = new VaadinSession((VaadinService)this.service){

            public boolean hasLock() {
                return true;
            }
        };
        this.ui = (UI)Mockito.mock(UI.class);
        Mockito.when((Object)this.ui.getUIId()).thenReturn((Object)1);
        UI.setCurrent((UI)this.ui);
    }

    @AfterEach
    public void tearDown() {
        CurrentInstance.clearAll();
    }

    @Test
    public void registerResource_registrationResultCanBeFound() {
        StreamResourceRegistry registry = new StreamResourceRegistry(this.session);
        StreamResource resource = new StreamResource("name", (InputStreamFactory & Serializable)() -> this.makeEmptyStream());
        StreamRegistration registration = registry.registerResource((AbstractStreamResource)resource);
        Assertions.assertNotNull((Object)registration);
        URI uri = registration.getResourceUri();
        Optional stored = registry.getResource(StreamResource.class, uri);
        Assertions.assertSame((Object)resource, stored.get(), (String)"Unexpected stored resource is returned for registered URI");
        Assertions.assertSame((Object)resource, (Object)registration.getResource(), (String)"Unexpected resource is returned by the registration instance");
    }

    @Test
    public void registerElementResourceHandler_registrationResultCanBeFound() {
        StreamResourceRegistry registry = new StreamResourceRegistry(this.session);
        ElementRequestHandler & Serializable handler = (ElementRequestHandler & Serializable)(request, response, session, owner) -> {};
        Element owner2 = (Element)Mockito.mock(Element.class);
        StreamRegistration registration = registry.registerResource((ElementRequestHandler)handler, owner2);
        Assertions.assertNotNull((Object)registration);
        URI uri = registration.getResourceUri();
        AbstractStreamResource generatedResource = registration.getResource();
        Optional stored = registry.getResource(uri);
        Assertions.assertSame((Object)generatedResource, stored.get(), (String)"Unexpected stored resource is returned for registered URI");
    }

    @Test
    public void unregisterResource_resourceIsRemoved() {
        StreamResourceRegistry registry = new StreamResourceRegistry(this.session);
        StreamResource resource = new StreamResource("name", (InputStreamFactory & Serializable)() -> this.makeEmptyStream());
        StreamRegistration registration = registry.registerResource((AbstractStreamResource)resource);
        Assertions.assertNotNull((Object)registration);
        URI uri = registration.getResourceUri();
        registration.unregister();
        Optional stored = registry.getResource(StreamResource.class, uri);
        Assertions.assertFalse((boolean)stored.isPresent(), (String)"Unexpected stored resource is found after unregister()");
        Assertions.assertNull((Object)registration.getResource(), (String)"Unexpected resource is returned by the registration instance");
    }

    @Test
    public void unregisterElementResourceHandler_resourceIsRemoved() {
        StreamResourceRegistry registry = new StreamResourceRegistry(this.session);
        ElementRequestHandler & Serializable handler = (ElementRequestHandler & Serializable)(request, response, session, owner) -> {};
        Element owner2 = (Element)Mockito.mock(Element.class);
        StreamRegistration registration = registry.registerResource((ElementRequestHandler)handler, owner2);
        Assertions.assertNotNull((Object)registration);
        URI uri = registration.getResourceUri();
        registration.unregister();
        Optional stored = registry.getResource(uri);
        Assertions.assertFalse((boolean)stored.isPresent(), (String)"Unexpected stored resource is found after unregister()");
        Assertions.assertNull((Object)registration.getResource(), (String)"Unexpected resource is returned by the registration instance");
    }

    @Test
    public void registerTwoResourcesWithSameName_resourcesHasDifferentURI() {
        StreamResourceRegistry registry = new StreamResourceRegistry(this.session);
        StreamResource resource1 = new StreamResource("name", (InputStreamFactory & Serializable)() -> this.makeEmptyStream());
        StreamRegistration registration1 = registry.registerResource((AbstractStreamResource)resource1);
        StreamResource resource2 = new StreamResource("name", (InputStreamFactory & Serializable)() -> this.makeEmptyStream());
        StreamRegistration registration2 = registry.registerResource((AbstractStreamResource)resource2);
        Assertions.assertNotEquals((Object)registration1.getResourceUri(), (Object)registration2.getResourceUri(), (String)"Two different resource are registered to the same URI");
        registration1.unregister();
        Assertions.assertTrue((boolean)registry.getResource(registration2.getResourceUri()).isPresent(), (String)"Second resource is not found after first resource has been unregistered");
    }

    @Test
    public void getResourceUriIsEncoded_withQueryParams() {
        this.assertResourceUriIsEncoded("a?b=c d&e", "a%3Fb%3Dc%20d%26e");
    }

    @Test
    public void getResourceUriIsEncoded_withContainingPlus() {
        this.assertResourceUriIsEncoded("image++.svg", "image%2B%2B.svg");
    }

    @Test
    public void getResourceUriIsEncoded_withSimpleSpace() {
        this.assertResourceUriIsEncoded("my file.png", "my%20file.png");
    }

    private void assertResourceUriIsEncoded(String resourceName, String suffix) {
        StreamResourceRegistry registry = new StreamResourceRegistry(this.session);
        StreamResource resource = new StreamResource(resourceName, this::makeEmptyStream);
        StreamRegistration registration = registry.registerResource((AbstractStreamResource)resource);
        URI uri = registration.getResourceUri();
        Assertions.assertTrue((boolean)uri.toString().endsWith(suffix), (String)"Resource URI is not properly encoded");
    }

    private InputStream makeEmptyStream() {
        return new ByteArrayInputStream(new byte[0]);
    }
}

