/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.page.Push;
import com.vaadin.flow.router.ParentLayout;
import com.vaadin.flow.router.RouteNotFoundError;
import com.vaadin.flow.router.RouterLayout;
import com.vaadin.flow.server.BootstrapHandler;
import com.vaadin.flow.server.MockVaadinSession;
import com.vaadin.flow.server.ServiceException;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinResponse;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.communication.JavaScriptBootstrapHandler;
import com.vaadin.flow.server.startup.ApplicationRouteRegistry;
import com.vaadin.flow.shared.communication.PushMode;
import com.vaadin.flow.shared.ui.Transport;
import java.util.Collections;
import java.util.Optional;
import java.util.function.Function;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class BootstrapContextTest {
    private MockVaadinSession session;
    private UI ui;
    private VaadinRequest request = (VaadinRequest)Mockito.mock(VaadinRequest.class);
    private Function<VaadinRequest, String> callback = request -> "";

    BootstrapContextTest() {
    }

    @BeforeEach
    public void setUp() throws ServiceException {
        MockVaadinSession session = new MockVaadinSession();
        session.lock();
        this.ui = new UI();
        this.ui.getInternals().setSession((VaadinSession)session);
    }

    @Test
    public void getPushAnnotation_routeTargetPresents_pushFromTheClassDefinitionIsUsed() {
        this.ui.getInternals().getRouter().getRegistry().setRoute("foo", MainView.class, Collections.emptyList());
        Mockito.when((Object)this.request.getParameter("location")).thenReturn((Object)"foo");
        JavaScriptBootstrapHandler.JavaScriptBootstrapContext context = new JavaScriptBootstrapHandler.JavaScriptBootstrapContext(this.request, (VaadinResponse)Mockito.mock(VaadinResponse.class), this.ui, this.callback);
        Optional push = context.getPageConfigurationAnnotation(Push.class);
        Assertions.assertTrue((boolean)push.isPresent());
        Push pushAnnotation = (Push)push.get();
        Assertions.assertEquals((Object)PushMode.MANUAL, (Object)pushAnnotation.value());
        Assertions.assertEquals((Object)Transport.LONG_POLLING, (Object)pushAnnotation.transport());
    }

    @Test
    public void getPushAnnotation_routeTargetPresents_pushDefinedOnParentLayout_pushFromTheClassDefinitionIsUsed() {
        this.ui.getInternals().getRouter().getRegistry().setRoute("foo", OtherView.class, Collections.singletonList(MainView.class));
        Mockito.when((Object)this.request.getParameter("location")).thenReturn((Object)"foo");
        JavaScriptBootstrapHandler.JavaScriptBootstrapContext context = new JavaScriptBootstrapHandler.JavaScriptBootstrapContext(this.request, (VaadinResponse)Mockito.mock(VaadinResponse.class), this.ui, this.callback);
        Optional push = context.getPageConfigurationAnnotation(Push.class);
        Assertions.assertTrue((boolean)push.isPresent());
        Push pushAnnotation = (Push)push.get();
        Assertions.assertEquals((Object)PushMode.MANUAL, (Object)pushAnnotation.value());
        Assertions.assertEquals((Object)Transport.LONG_POLLING, (Object)pushAnnotation.transport());
    }

    @Test
    public void getPushAnnotation_routeTargetIsAbsent_pushFromTheErrorNavigationTargetIsUsed() {
        Mockito.when((Object)this.request.getParameter("location")).thenReturn((Object)"bar");
        ApplicationRouteRegistry registry = ApplicationRouteRegistry.getInstance((VaadinContext)this.ui.getSession().getService().getContext());
        registry.setErrorNavigationTargets(Collections.singleton(CustomRouteNotFound.class));
        BootstrapHandler.BootstrapContext context = new BootstrapHandler.BootstrapContext(this.request, (VaadinResponse)Mockito.mock(VaadinResponse.class), (VaadinSession)this.session, this.ui, request -> "");
        Optional push = context.getPageConfigurationAnnotation(Push.class);
        Assertions.assertTrue((boolean)push.isPresent());
        Push pushAnnotation = (Push)push.get();
        Assertions.assertEquals((Object)PushMode.AUTOMATIC, (Object)pushAnnotation.value());
        Assertions.assertEquals((Object)Transport.WEBSOCKET, (Object)pushAnnotation.transport());
    }

    @Test
    public void getPushAnnotation_routeTargetIsAbsent_pushIsDefinedOnParentLayout_pushFromTheErrorNavigationTargetParentLayoutIsUsed() {
        Mockito.when((Object)this.request.getParameter("location")).thenReturn((Object)"bar");
        ApplicationRouteRegistry registry = ApplicationRouteRegistry.getInstance((VaadinContext)this.ui.getSession().getService().getContext());
        registry.setErrorNavigationTargets(Collections.singleton(AnotherCustomRouteNotFound.class));
        BootstrapHandler.BootstrapContext context = new BootstrapHandler.BootstrapContext(this.request, (VaadinResponse)Mockito.mock(VaadinResponse.class), (VaadinSession)this.session, this.ui, request -> "");
        Optional push = context.getPageConfigurationAnnotation(Push.class);
        Assertions.assertTrue((boolean)push.isPresent());
        Push pushAnnotation = (Push)push.get();
        Assertions.assertEquals((Object)PushMode.MANUAL, (Object)pushAnnotation.value());
        Assertions.assertEquals((Object)Transport.LONG_POLLING, (Object)pushAnnotation.transport());
    }

    @Tag(value="a")
    @Push(value=PushMode.MANUAL, transport=Transport.LONG_POLLING)
    private static class MainView
    extends Component
    implements RouterLayout {
        private MainView() {
        }
    }

    @Tag(value="a")
    private static class OtherView
    extends Component {
        private OtherView() {
        }
    }

    @Push(value=PushMode.AUTOMATIC, transport=Transport.WEBSOCKET)
    private static class CustomRouteNotFound
    extends RouteNotFoundError {
        private CustomRouteNotFound() {
        }
    }

    @ParentLayout(value=MainView.class)
    private static class AnotherCustomRouteNotFound
    extends RouteNotFoundError {
        private AnotherCustomRouteNotFound() {
        }
    }
}

