/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server;

import com.vaadin.flow.component.dependency.StyleSheet;
import com.vaadin.flow.component.page.AppShellConfigurator;
import com.vaadin.flow.server.AppShellRegistry;
import com.vaadin.flow.server.MockServletServiceSessionSetup;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinServletContext;
import com.vaadin.flow.server.VaadinServletRequest;
import com.vaadin.flow.server.VaadinServletService;
import jakarta.servlet.http.HttpServletRequest;
import java.util.regex.Pattern;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class AppShellRegistryStyleSheetDataFilePathTest {
    private MockServletServiceSessionSetup mocks;
    private VaadinServletContext context;
    private Document document;

    AppShellRegistryStyleSheetDataFilePathTest() {
    }

    @BeforeEach
    public void setup() {
        this.mocks = new MockServletServiceSessionSetup();
        this.context = new VaadinServletContext(this.mocks.getServletContext());
        VaadinService.setCurrent((VaadinService)this.mocks.getService());
        this.document = Document.createShell((String)"");
    }

    @AfterEach
    public void teardown() throws Exception {
        AppShellRegistry.getInstance((VaadinContext)this.context).reset();
        this.mocks.cleanup();
    }

    @Test
    public void modifyIndex_addsDataFilePathAttributes_normalized() throws Exception {
        AppShellRegistry registry = AppShellRegistry.getInstance((VaadinContext)this.context);
        registry.setShell(MyShell.class);
        VaadinServletRequest request = this.createRequest("/", "/ctx");
        registry.modifyIndexHtml(this.document, (VaadinRequest)request);
        Elements links = this.document.head().select("link[rel=stylesheet]");
        Assertions.assertEquals((int)4, (int)links.size());
        Element abs = (Element)links.get(0);
        Assertions.assertEquals((Object)"/absolute.css", (Object)abs.attr("href"));
        Assertions.assertEquals((Object)"absolute.css", (Object)abs.attr("data-file-path"));
        Element rel = (Element)links.get(1);
        Assertions.assertEquals((Object)"/ctx/relative/path.css", (Object)rel.attr("href"));
        Assertions.assertEquals((Object)"relative/path.css", (Object)rel.attr("data-file-path"));
        Element ctx = (Element)links.get(2);
        Assertions.assertEquals((Object)"/ctx/from-context.css", (Object)ctx.attr("href"));
        Assertions.assertEquals((Object)"from-context.css", (Object)ctx.attr("data-file-path"));
        Element remote = (Element)links.get(3);
        Assertions.assertEquals((Object)"https://cdn.example.com/remote.css", (Object)remote.attr("href"));
        Assertions.assertEquals((Object)"https://cdn.example.com/remote.css", (Object)remote.attr("data-file-path"));
    }

    @Test
    public void productionMode_hrefContainsHash_dataFilePathUnchanged() throws Exception {
        this.mocks.getDeploymentConfiguration().setProductionMode(true);
        this.mocks.getServlet().addServletContextResource("/absolute.css", "body { color: red; }");
        this.mocks.getServlet().addServletContextResource("/from-context.css", "body { color: blue; }");
        this.mocks.getServlet().addServletContextResource("./relative/path.css", "body { color: green; }");
        AppShellRegistry registry = AppShellRegistry.getInstance((VaadinContext)this.context);
        registry.setShell(MyShell.class);
        VaadinServletRequest request = this.createRequest("/", "/ctx");
        registry.modifyIndexHtml(this.document, (VaadinRequest)request);
        Elements links = this.document.head().select("link[rel=stylesheet]");
        Assertions.assertEquals((int)4, (int)links.size());
        Pattern hashPattern = Pattern.compile("\\?v=[0-9a-f]{8}$");
        Element abs = (Element)links.get(0);
        Assertions.assertTrue((boolean)hashPattern.matcher(abs.attr("href")).find(), (String)"Absolute href should contain ?v=<hash>");
        Assertions.assertTrue((boolean)abs.attr("href").startsWith("/absolute.css"), (String)"Absolute href should start with /absolute.css");
        Assertions.assertEquals((Object)"/absolute.css", (Object)abs.attr("data-file-path"));
        Element rel = (Element)links.get(1);
        Assertions.assertTrue((boolean)hashPattern.matcher(rel.attr("href")).find(), (String)"Relative href should contain ?v=<hash>");
        Assertions.assertTrue((boolean)rel.attr("href").startsWith("/ctx/relative/path.css"), (String)"Relative href should start with /ctx/");
        Assertions.assertEquals((Object)"./relative/path.css", (Object)rel.attr("data-file-path"));
        Element ctx = (Element)links.get(2);
        Assertions.assertTrue((boolean)hashPattern.matcher(ctx.attr("href")).find(), (String)"Context href should contain ?v=<hash>");
        Assertions.assertTrue((boolean)ctx.attr("href").startsWith("/ctx/from-context.css"), (String)"Context href should start with /ctx/");
        Assertions.assertEquals((Object)"context://from-context.css", (Object)ctx.attr("data-file-path"));
        Element remote = (Element)links.get(3);
        Assertions.assertEquals((Object)"https://cdn.example.com/remote.css", (Object)remote.attr("href"));
        Assertions.assertFalse((boolean)hashPattern.matcher(remote.attr("href")).find(), (String)"External href should not have hash");
        Assertions.assertEquals((Object)"https://cdn.example.com/remote.css", (Object)remote.attr("data-file-path"));
    }

    @Test
    public void productionMode_missingResource_fallsBackToOriginalUrl() throws Exception {
        this.mocks.getDeploymentConfiguration().setProductionMode(true);
        AppShellRegistry registry = AppShellRegistry.getInstance((VaadinContext)this.context);
        registry.setShell(MyShell.class);
        VaadinServletRequest request = this.createRequest("/", "/ctx");
        registry.modifyIndexHtml(this.document, (VaadinRequest)request);
        Elements links = this.document.head().select("link[rel=stylesheet]");
        for (Element link : links) {
            Assertions.assertFalse((boolean)link.attr("href").contains("?v="), (String)("Missing resource href should not have hash: " + link.attr("href")));
        }
    }

    private VaadinServletRequest createRequest(String pathInfo, String contextPath) {
        HttpServletRequest req = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)req.getServletPath()).thenReturn((Object)"");
        Mockito.when((Object)req.getPathInfo()).thenReturn((Object)pathInfo);
        Mockito.when((Object)req.getRequestURL()).thenReturn((Object)new StringBuffer(pathInfo));
        Mockito.when((Object)req.getContextPath()).thenReturn((Object)contextPath);
        return new VaadinServletRequest(req, (VaadinServletService)this.mocks.getService());
    }

    @StyleSheet.Container(value={@StyleSheet(value="/absolute.css"), @StyleSheet(value="./relative/path.css"), @StyleSheet(value="context://from-context.css"), @StyleSheet(value="https://cdn.example.com/remote.css")})
    public static class MyShell
    implements AppShellConfigurator {
    }
}

