/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal.nodefeature;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.internal.JacksonUtils;
import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.internal.StateNodeTest;
import com.vaadin.flow.internal.StateTree;
import com.vaadin.flow.internal.change.MapPutChange;
import com.vaadin.flow.internal.change.MapRemoveChange;
import com.vaadin.flow.internal.change.NodeChange;
import com.vaadin.flow.internal.nodefeature.AbstractNodeFeatureTest;
import com.vaadin.flow.internal.nodefeature.ElementChildrenList;
import com.vaadin.flow.internal.nodefeature.ElementPropertyMap;
import com.vaadin.flow.internal.nodefeature.ElementStylePropertyMap;
import com.vaadin.flow.internal.nodefeature.NodeFeature;
import com.vaadin.flow.internal.nodefeature.NodeMap;
import com.vaadin.flow.server.Command;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.SerializationUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import tools.jackson.databind.node.BaseJsonNode;

class NodeMapTest
extends AbstractNodeFeatureTest<ElementStylePropertyMap> {
    private static final String KEY = "key";
    private ElementStylePropertyMap nodeMap = (ElementStylePropertyMap)this.createFeature();

    NodeMapTest() {
    }

    @Test
    void testBasicFunctionality() {
        Assertions.assertFalse((boolean)this.nodeMap.contains(KEY));
        Assertions.assertNull((Object)this.nodeMap.get(KEY));
        this.nodeMap.put(KEY, (Serializable)((Object)"value"));
        Assertions.assertTrue((boolean)this.nodeMap.contains(KEY));
        Assertions.assertEquals((Object)"value", (Object)this.nodeMap.get(KEY));
        this.nodeMap.remove(KEY);
        Assertions.assertFalse((boolean)this.nodeMap.contains(KEY));
        Assertions.assertNull((Object)this.nodeMap.get(KEY));
    }

    @Test
    void testCollectChange() {
        List<NodeChange> initialChanges = this.collectChanges((NodeFeature)this.nodeMap);
        Assertions.assertEquals((int)0, (int)initialChanges.size());
        this.nodeMap.put(KEY, (Serializable)((Object)"value"));
        List<NodeChange> putChanges = this.collectChanges((NodeFeature)this.nodeMap);
        Assertions.assertEquals((int)1, (int)putChanges.size());
        MapPutChange putChange = (MapPutChange)putChanges.get(0);
        Assertions.assertEquals((Object)KEY, (Object)putChange.getKey());
        Assertions.assertEquals((Object)"value", (Object)putChange.getValue());
        this.nodeMap.put(KEY, null);
        List<NodeChange> putNullChanges = this.collectChanges((NodeFeature)this.nodeMap);
        Assertions.assertEquals((int)1, (int)putNullChanges.size());
        MapPutChange putNullChange = (MapPutChange)putNullChanges.get(0);
        Assertions.assertEquals((Object)KEY, (Object)putNullChange.getKey());
        Assertions.assertEquals(null, (Object)putNullChange.getValue());
        this.nodeMap.remove(KEY);
        List<NodeChange> removeChanges = this.collectChanges((NodeFeature)this.nodeMap);
        Assertions.assertEquals((int)1, (int)removeChanges.size());
        MapRemoveChange removeChange = (MapRemoveChange)removeChanges.get(0);
        Assertions.assertEquals((Object)KEY, (Object)removeChange.getKey());
    }

    @Test
    void testCollectChange_withSignalBinding() {
        this.nodeMap.put(KEY, (Serializable)new NodeMap.SignalBinding(null, null, (Serializable)((Object)"value"), null));
        List<NodeChange> putChanges = this.collectChanges((NodeFeature)this.nodeMap);
        Assertions.assertEquals((int)1, (int)putChanges.size());
        MapPutChange putChange = (MapPutChange)putChanges.get(0);
        Assertions.assertEquals((Object)KEY, (Object)putChange.getKey());
        Assertions.assertEquals((Object)"value", (Object)putChange.getValue());
    }

    @Test
    void testNoChangeEvent() {
        this.nodeMap.put(KEY, (Serializable)((Object)"value"), false);
        List<NodeChange> changes = this.collectChanges((NodeFeature)this.nodeMap);
        Assertions.assertEquals((int)0, (int)changes.size());
        this.nodeMap.put(KEY, (Serializable)((Object)"value"), true);
        changes = this.collectChanges((NodeFeature)this.nodeMap);
        Assertions.assertEquals((int)0, (int)changes.size());
        this.nodeMap.put(KEY, (Serializable)((Object)"bar"), true);
        changes = this.collectChanges((NodeFeature)this.nodeMap);
        Assertions.assertEquals((int)1, (int)changes.size());
    }

    @Test
    void testNoChangeOverwritesOldChanges() {
        this.nodeMap.put(KEY, (Serializable)((Object)"value"), true);
        this.nodeMap.put(KEY, (Serializable)((Object)"foobar"), false);
        List<NodeChange> changes = this.collectChanges((NodeFeature)this.nodeMap);
        Assertions.assertEquals((int)0, (int)changes.size());
        this.nodeMap.put(KEY, (Serializable)((Object)"urk"));
        changes = this.collectChanges((NodeFeature)this.nodeMap);
        Assertions.assertEquals((int)1, (int)changes.size());
        Assertions.assertEquals((Object)"urk", (Object)((MapPutChange)changes.get(0)).getValue());
    }

    @Test
    void testCoalescePutRemove() {
        this.nodeMap.put(KEY, (Serializable)((Object)"value"));
        this.nodeMap.remove(KEY);
        List<NodeChange> changes = this.collectChanges((NodeFeature)this.nodeMap);
        Assertions.assertEquals((int)0, (int)changes.size());
    }

    @Test
    void testCoalesceDoublePut() {
        this.nodeMap.put(KEY, (Serializable)((Object)"value1"));
        this.nodeMap.put(KEY, (Serializable)((Object)"value2"));
        List<NodeChange> changes = this.collectChanges((NodeFeature)this.nodeMap);
        Assertions.assertEquals((int)1, (int)changes.size());
        Assertions.assertEquals((Object)"value2", (Object)((MapPutChange)changes.get(0)).getValue());
    }

    @Test
    void testCoalescePutSame() {
        this.nodeMap.put(KEY, (Serializable)((Object)"value"));
        this.collectChanges((NodeFeature)this.nodeMap);
        this.nodeMap.put(KEY, (Serializable)((Object)"otherValue"));
        this.nodeMap.put(KEY, (Serializable)((Object)"value"));
        List<NodeChange> changes = this.collectChanges((NodeFeature)this.nodeMap);
        Assertions.assertEquals((int)0, (int)changes.size());
    }

    @Test
    void testCoalesceRemovePut() {
        this.nodeMap.put(KEY, (Serializable)((Object)"value"));
        this.collectChanges((NodeFeature)this.nodeMap);
        this.nodeMap.remove(KEY);
        this.nodeMap.put(KEY, (Serializable)((Object)"value"));
        List<NodeChange> changes = this.collectChanges((NodeFeature)this.nodeMap);
        Assertions.assertEquals((int)0, (int)changes.size());
    }

    @Test
    void testResetChanges() {
        this.nodeMap.put(KEY, (Serializable)((Object)"value"));
        this.collectChanges((NodeFeature)this.nodeMap);
        this.nodeMap.generateChangesFromEmpty();
        List<NodeChange> changes = this.collectChanges((NodeFeature)this.nodeMap);
        Assertions.assertEquals((int)1, (int)changes.size());
        Assertions.assertEquals((Object)"value", (Object)((MapPutChange)changes.get(0)).getValue());
    }

    @Test
    void testCoalesceRemoveReset() {
        this.nodeMap.put(KEY, (Serializable)((Object)"value"));
        this.collectChanges((NodeFeature)this.nodeMap);
        this.nodeMap.generateChangesFromEmpty();
        this.nodeMap.remove(KEY);
        List<NodeChange> changes = this.collectChanges((NodeFeature)this.nodeMap);
        Assertions.assertEquals((int)0, (int)changes.size());
    }

    @Test
    void testNullKeyThrows() {
        NodeMapTest.assertFailsAssert("get(null)", (Command & Serializable)() -> this.nodeMap.get(null));
        NodeMapTest.assertFailsAssert("contains(null)", (Command & Serializable)() -> this.nodeMap.contains(null));
        NodeMapTest.assertFailsAssert("put(null, x)", (Command & Serializable)() -> this.nodeMap.put(null, (Serializable)((Object)"")));
        NodeMapTest.assertFailsAssert("remove(null)", (Command & Serializable)() -> this.nodeMap.remove(null));
    }

    private static void assertFailsAssert(String name, Command command) {
        boolean threw = false;
        try {
            command.execute();
        }
        catch (AssertionError expected) {
            threw = true;
        }
        Assertions.assertTrue((boolean)threw, (String)(name + " should throw AssertionError"));
    }

    @Test
    void testPutAttachDetachChildren() {
        StateNode child = StateNodeTest.createEmptyNode("child");
        Assertions.assertNull((Object)child.getParent());
        this.nodeMap.put(KEY, (Serializable)child);
        Assertions.assertSame((Object)this.nodeMap.getNode(), (Object)child.getParent());
        this.nodeMap.put(KEY, (Serializable)((Object)"foo"));
        Assertions.assertNull((Object)child.getParent());
    }

    @Test
    void testRemoveDetachChildren() {
        StateNode child = StateNodeTest.createEmptyNode("child");
        this.nodeMap.put(KEY, (Serializable)child);
        Assertions.assertSame((Object)this.nodeMap.getNode(), (Object)child.getParent());
        this.nodeMap.remove(KEY);
        Assertions.assertNull((Object)child.getParent());
    }

    @Test
    void testSerializable() {
        this.nodeMap.put("string", (Serializable)((Object)"bar"));
        this.nodeMap.put("null", null);
        this.nodeMap.put("boolean", (Serializable)Boolean.TRUE);
        this.nodeMap.put("number", (Serializable)Double.valueOf(5.0));
        this.nodeMap.put("jsonString", (Serializable)JacksonUtils.writeValue((Object)"bar"));
        this.nodeMap.put("jsonNull", (Serializable)JacksonUtils.nullNode());
        this.nodeMap.put("jsonBoolean", (Serializable)JacksonUtils.writeValue((Object)true));
        this.nodeMap.put("jsonNumber", (Serializable)JacksonUtils.writeValue((Object)5));
        this.nodeMap.put("jsonObject", (Serializable)JacksonUtils.createObjectNode());
        this.nodeMap.put("jsonArray", (Serializable)JacksonUtils.createArrayNode());
        HashMap values = new HashMap();
        this.nodeMap.keySet().forEach(key -> values.put(key, this.nodeMap.get(key)));
        NodeMap copy = (NodeMap)SerializationUtils.deserialize((byte[])SerializationUtils.serialize((Serializable)this.nodeMap));
        Assertions.assertNotSame((Object)this.nodeMap, (Object)copy);
        Assertions.assertEquals(values.keySet(), (Object)copy.keySet());
        Assertions.assertEquals(values.keySet(), (Object)this.nodeMap.keySet());
        values.keySet().forEach(key -> {
            if (key.startsWith("json")) {
                BaseJsonNode originalValue = (BaseJsonNode)this.nodeMap.get(key);
                BaseJsonNode copyValue = (BaseJsonNode)copy.get(key);
                Assertions.assertEquals((Object)originalValue.toString(), (Object)copyValue.toString());
            } else {
                Assertions.assertEquals((Object)this.nodeMap.get(key), (Object)copy.get(key));
            }
            Assertions.assertSame(values.get(key), (Object)this.nodeMap.get(key));
        });
    }

    @Test
    void testGetIntDefaultValue() {
        Assertions.assertEquals((int)12, (int)this.nodeMap.getOrDefault(KEY, 12));
        this.nodeMap.put(KEY, (Serializable)Integer.valueOf(24));
        Assertions.assertEquals((int)24, (int)this.nodeMap.getOrDefault(KEY, 12));
        this.nodeMap.put(KEY, null);
        Assertions.assertEquals((int)12, (int)this.nodeMap.getOrDefault(KEY, 12));
        this.nodeMap.remove(KEY);
        Assertions.assertEquals((int)12, (int)this.nodeMap.getOrDefault(KEY, 12));
    }

    @Test
    void testGetBooleanDefaultValue() {
        Assertions.assertTrue((boolean)this.nodeMap.getOrDefault(KEY, true));
        Assertions.assertFalse((boolean)this.nodeMap.getOrDefault(KEY, false));
        this.nodeMap.put(KEY, (Serializable)Boolean.valueOf(true));
        Assertions.assertTrue((boolean)this.nodeMap.getOrDefault(KEY, false));
        this.nodeMap.put(KEY, null);
        Assertions.assertTrue((boolean)this.nodeMap.getOrDefault(KEY, true));
        Assertions.assertFalse((boolean)this.nodeMap.getOrDefault(KEY, false));
        this.nodeMap.remove(KEY);
        Assertions.assertTrue((boolean)this.nodeMap.getOrDefault(KEY, true));
        Assertions.assertFalse((boolean)this.nodeMap.getOrDefault(KEY, false));
    }

    @Test
    void testGetStringDefaultValue() {
        Assertions.assertEquals((Object)"default", (Object)this.nodeMap.getOrDefault(KEY, "default"));
        this.nodeMap.put(KEY, (Serializable)((Object)"assigned"));
        Assertions.assertEquals((Object)"assigned", (Object)this.nodeMap.getOrDefault(KEY, "default"));
        this.nodeMap.put(KEY, null);
        Assertions.assertEquals((Object)"default", (Object)this.nodeMap.getOrDefault(KEY, "default"));
        this.nodeMap.remove(KEY);
        Assertions.assertEquals((Object)"default", (Object)this.nodeMap.getOrDefault(KEY, "default"));
    }

    @Test
    void testClear() {
        this.nodeMap.put("foo", (Serializable)Integer.valueOf(1));
        this.nodeMap.put("bar", (Serializable)Integer.valueOf(1));
        this.nodeMap.put("baz", (Serializable)Integer.valueOf(1));
        this.nodeMap.clear();
        Assertions.assertEquals((long)0L, (long)this.nodeMap.getPropertyNames().count());
        Assertions.assertFalse((boolean)this.nodeMap.hasProperty("foo"));
        Assertions.assertFalse((boolean)this.nodeMap.hasProperty("bar"));
        Assertions.assertFalse((boolean)this.nodeMap.hasProperty("baz"));
    }

    @Test
    void put_sameValue_hasNoEffect() {
        StateTree tree = new StateTree(new UI().getInternals(), new Class[]{ElementChildrenList.class});
        StateNode child = new StateNode(new Class[0]);
        AtomicBoolean listenerIsCalled = new AtomicBoolean();
        child.addAttachListener((Command & Serializable)() -> {
            Assertions.assertFalse((boolean)listenerIsCalled.get());
            listenerIsCalled.set(true);
        });
        this.nodeMap.put("foo", (Serializable)child);
        ((ElementChildrenList)tree.getRootNode().getFeature(ElementChildrenList.class)).add((Serializable)child.getParent());
        Assertions.assertTrue((boolean)listenerIsCalled.get());
        this.nodeMap.put("foo", (Serializable)child);
    }

    @Test
    void put_replaceSingleValue_stillUseSingleValue() {
        this.nodeMap.put("foo", (Serializable)((Object)"bar"));
        Assertions.assertTrue((boolean)this.nodeMap.usesSingleMap());
        this.nodeMap.put("foo", (Serializable)((Object)"baz"));
        Assertions.assertTrue((boolean)this.nodeMap.usesSingleMap());
    }

    @Test
    void streamSingleNullValue() {
        this.nodeMap.put("foo", null);
        Assertions.assertTrue((boolean)this.nodeMap.usesSingleMap());
        this.nodeMap.forEachChild(child -> Assertions.fail((String)"Should not happen, but forEachChild shouldn't explode either"));
    }

    @Test
    void collectChanges_sameValue_alwaysCollect_allValueChangesCollected() {
        StateNode node = new StateNode(new Class[]{ElementPropertyMap.class});
        AlwaysProduceChangeMap map = new AlwaysProduceChangeMap(node);
        this.assertChangeCollected(map);
        this.assertChangeCollected(map);
    }

    @Test
    void put_sameValue_alwaysProduceChange_nodeIsDirty() {
        UI ui = new UI();
        StateNode node = new StateNode(new Class[]{ElementPropertyMap.class});
        StateTree tree = ui.getInternals().getStateTree();
        ((ElementChildrenList)tree.getRootNode().getFeature(ElementChildrenList.class)).add((Serializable)node);
        AlwaysProduceChangeMap map = new AlwaysProduceChangeMap(node);
        tree.collectChanges(change -> {});
        map.put("foo", (Serializable)((Object)"bar"));
        Set nodes = tree.collectDirtyNodes();
        Assertions.assertTrue((boolean)nodes.contains(node));
        tree.collectChanges(change -> {});
        Assertions.assertTrue((boolean)tree.collectDirtyNodes().isEmpty());
        map.put("foo", (Serializable)((Object)"bar"));
        nodes = tree.collectDirtyNodes();
        Assertions.assertTrue((boolean)nodes.contains(node));
    }

    @Test
    void put_sameValue_neverProduceChange_nodeIsNotDirty() {
        UI ui = new UI();
        StateNode node = new StateNode(new Class[]{ElementPropertyMap.class});
        StateTree tree = ui.getInternals().getStateTree();
        ((ElementChildrenList)tree.getRootNode().getFeature(ElementChildrenList.class)).add((Serializable)node);
        NeverProduceChangeMap map = new NeverProduceChangeMap(node);
        tree.collectChanges(change -> {});
        map.put("foo", (Serializable)((Object)"bar"));
        Set nodes = tree.collectDirtyNodes();
        Assertions.assertFalse((boolean)nodes.contains(node));
        tree.collectChanges(change -> {});
        Assertions.assertTrue((boolean)tree.collectDirtyNodes().isEmpty());
        map.put("foo", (Serializable)((Object)"baz"));
        nodes = tree.collectDirtyNodes();
        Assertions.assertFalse((boolean)nodes.contains(node));
    }

    @Test
    void collectChanges_sameValue_neverCollect_noValueChanges() {
        StateNode node = new StateNode(new Class[]{ElementPropertyMap.class});
        NeverProduceChangeMap map = new NeverProduceChangeMap(node);
        this.assertChangeIsNotCollected(map, "bar");
        this.assertChangeIsNotCollected(map, "baz");
    }

    private void assertChangeIsNotCollected(NeverProduceChangeMap map, String value) {
        map.put("foo", (Serializable)((Object)value));
        ArrayList changes = new ArrayList();
        map.collectChanges(changes::add);
        Assertions.assertTrue((boolean)changes.isEmpty());
    }

    private void assertChangeCollected(AlwaysProduceChangeMap map) {
        map.put("foo", (Serializable)((Object)"bar"));
        ArrayList changes = new ArrayList();
        map.collectChanges(changes::add);
        Assertions.assertEquals((int)1, (int)changes.size());
        Assertions.assertEquals(MapPutChange.class, ((NodeChange)changes.get(0)).getClass());
    }

    private static class AlwaysProduceChangeMap
    extends NodeMap {
        AlwaysProduceChangeMap(StateNode node) {
            super(node);
        }

        protected boolean producePutChange(String key, boolean hadValueEarlier, Serializable newValue) {
            return true;
        }
    }

    private static class NeverProduceChangeMap
    extends NodeMap {
        NeverProduceChangeMap(StateNode node) {
            super(node);
        }

        protected boolean producePutChange(String key, boolean hadValueEarlier, Serializable newValue) {
            return false;
        }
    }
}

