/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal.nodefeature;

import com.vaadin.flow.internal.JacksonUtils;
import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.internal.change.MapPutChange;
import com.vaadin.flow.internal.change.NodeChange;
import com.vaadin.flow.internal.nodefeature.AbstractNodeFeatureTest;
import com.vaadin.flow.internal.nodefeature.ElementData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import tools.jackson.databind.node.BaseJsonNode;
import tools.jackson.databind.node.ObjectNode;

class ElementDataTest
extends AbstractNodeFeatureTest<ElementData> {
    private final ElementData elementData = (ElementData)new StateNode(Collections.singletonList(ElementData.class), new Class[0]).getFeature(ElementData.class);

    ElementDataTest() {
    }

    @Test
    void setGetTag() {
        Assertions.assertNull((Object)this.elementData.getTag(), (String)"Tag should initially be null");
        this.elementData.setTag("myTag");
        Assertions.assertEquals((Object)"myTag", (Object)this.elementData.getTag());
    }

    @Test
    void setGetPayload() {
        Assertions.assertNull((Object)this.elementData.getPayload(), (String)"Tag should initially be null");
        ObjectNode object = JacksonUtils.createObjectNode();
        this.elementData.setPayload((BaseJsonNode)object);
        Assertions.assertEquals((Object)object, (Object)this.elementData.getPayload());
    }

    @Test
    void collectChanges_setTagOnly_onlyOneChanges() {
        this.elementData.setTag("foo");
        ArrayList changes = new ArrayList();
        this.elementData.collectChanges(changes::add);
        Assertions.assertEquals((int)1, (int)changes.size());
        Assertions.assertTrue((boolean)(changes.get(0) instanceof MapPutChange));
        MapPutChange change = (MapPutChange)changes.get(0);
        Assertions.assertEquals((Object)"tag", (Object)change.getKey());
        Assertions.assertEquals((Object)this.elementData.getNode(), (Object)change.getNode());
        Assertions.assertEquals((Object)"foo", (Object)change.getValue());
    }

    @Test
    void collectChanges_setPayloadOnly_onlyOneChanges() {
        ObjectNode object = JacksonUtils.createObjectNode();
        this.elementData.setPayload((BaseJsonNode)object);
        ArrayList changes = new ArrayList();
        this.elementData.collectChanges(changes::add);
        Assertions.assertEquals((int)1, (int)changes.size());
        Assertions.assertTrue((boolean)(changes.get(0) instanceof MapPutChange));
        MapPutChange change = (MapPutChange)changes.get(0);
        Assertions.assertEquals((Object)"payload", (Object)change.getKey());
        Assertions.assertEquals((Object)this.elementData.getNode(), (Object)change.getNode());
        Assertions.assertEquals((Object)object, (Object)change.getValue());
    }

    @Test
    void collectChanges_setBothTagAndPayload_twoChanges() {
        ObjectNode object = JacksonUtils.createObjectNode();
        this.elementData.setPayload((BaseJsonNode)object);
        this.elementData.setTag("foo");
        ArrayList<NodeChange> changes = new ArrayList<NodeChange>();
        this.elementData.collectChanges(changes::add);
        Assertions.assertEquals((int)2, (int)changes.size());
        Assertions.assertTrue((boolean)(changes.get(0) instanceof MapPutChange));
        Assertions.assertTrue((boolean)(changes.get(1) instanceof MapPutChange));
        MapPutChange change = this.getChange(changes, "tag");
        Assertions.assertEquals((Object)"tag", (Object)change.getKey());
        Assertions.assertEquals((Object)this.elementData.getNode(), (Object)change.getNode());
        Assertions.assertEquals((Object)"foo", (Object)change.getValue());
        change = this.getChange(changes, "payload");
        Assertions.assertEquals((Object)"payload", (Object)change.getKey());
        Assertions.assertEquals((Object)this.elementData.getNode(), (Object)change.getNode());
        Assertions.assertEquals((Object)object, (Object)change.getValue());
    }

    private MapPutChange getChange(List<NodeChange> changes, String key) {
        Optional<MapPutChange> keyFound = changes.stream().filter(MapPutChange.class::isInstance).map(MapPutChange.class::cast).filter(chang -> chang.getKey().equals(key)).findFirst();
        Assertions.assertTrue((boolean)keyFound.isPresent(), (String)("No " + key + " change found"));
        return keyFound.get();
    }
}

