/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal.change;

import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.internal.StateNodeTest;
import com.vaadin.flow.internal.change.ListAddChange;
import com.vaadin.flow.internal.nodefeature.AbstractNodeFeatureTest;
import com.vaadin.flow.internal.nodefeature.ElementChildrenList;
import com.vaadin.flow.internal.nodefeature.NodeFeatureRegistry;
import com.vaadin.flow.internal.nodefeature.NodeList;
import java.util.Arrays;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import tools.jackson.databind.node.ArrayNode;
import tools.jackson.databind.node.ObjectNode;

class ListChangeTest {
    private NodeList<StateNode> feature = (NodeList)AbstractNodeFeatureTest.createFeature(ElementChildrenList.class);

    ListChangeTest() {
    }

    @Test
    void testBasicJson() {
        StateNode child1 = StateNodeTest.createEmptyNode("child1");
        StateNode child2 = StateNodeTest.createEmptyNode("child2");
        ListAddChange change = new ListAddChange(this.feature, true, 0, Arrays.asList(child1, child2));
        ObjectNode json = change.toJson(null);
        Assertions.assertEquals((int)change.getNode().getId(), (int)json.get("node").intValue());
        Assertions.assertEquals((int)NodeFeatureRegistry.getId(this.feature.getClass()), (int)json.get("feat").intValue());
        Assertions.assertEquals((Object)"splice", (Object)json.get("type").textValue());
        Assertions.assertEquals((int)0, (int)json.get("index").intValue());
        ArrayNode addNodes = (ArrayNode)json.get("addNodes");
        Assertions.assertEquals((int)2, (int)addNodes.size());
        Assertions.assertEquals((int)child1.getId(), (int)addNodes.get(0).intValue());
        Assertions.assertEquals((int)child2.getId(), (int)addNodes.get(1).intValue());
    }

    @Test
    void testZeroRemoveNotInJson() {
        ListAddChange change = new ListAddChange(this.feature, false, 1, Arrays.asList(new StateNode[0]));
        ObjectNode json = change.toJson(null);
        Assertions.assertFalse((boolean)json.has("remove"));
    }

    @Test
    void testEmptyAddNotInJson() {
        ListAddChange change = new ListAddChange(this.feature, false, 1, Arrays.asList(new StateNode[0]));
        ObjectNode json = change.toJson(null);
        Assertions.assertFalse((boolean)json.has("addNodes"));
    }
}

