/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal;

import com.vaadin.flow.internal.MessageDigestUtil;
import com.vaadin.flow.internal.StylesheetContentHashUtil;
import com.vaadin.flow.server.VaadinService;
import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class StylesheetContentHashUtilTest {
    private VaadinService service;

    @Before
    public void setUp() {
        this.service = (VaadinService)Mockito.mock(VaadinService.class);
    }

    @Test
    public void getContentHash_knownContent_returnsExpectedHash() {
        byte[] content = "body { color: red; }".getBytes(StandardCharsets.UTF_8);
        Mockito.when((Object)this.service.getResourceAsStream("styles.css")).thenReturn((Object)new ByteArrayInputStream(content));
        String hash = StylesheetContentHashUtil.getContentHash((VaadinService)this.service, (String)"styles.css");
        Assert.assertNotNull((Object)hash);
        Assert.assertEquals((long)8L, (long)hash.length());
        String expectedHash = MessageDigestUtil.sha256Hex((byte[])content).substring(0, 8);
        Assert.assertEquals((Object)expectedHash, (Object)hash);
    }

    @Test
    public void getContentHash_externalHttpUrl_returnsNull() {
        Assert.assertNull((Object)StylesheetContentHashUtil.getContentHash((VaadinService)this.service, (String)"http://cdn.example.com/styles.css"));
    }

    @Test
    public void getContentHash_externalHttpsUrl_returnsNull() {
        Assert.assertNull((Object)StylesheetContentHashUtil.getContentHash((VaadinService)this.service, (String)"https://cdn.example.com/styles.css"));
    }

    @Test
    public void getContentHash_externalUrlMixedCase_returnsNull() {
        Assert.assertNull((Object)StylesheetContentHashUtil.getContentHash((VaadinService)this.service, (String)"HTTPS://cdn.example.com/styles.css"));
    }

    @Test
    public void getContentHash_nullUrl_returnsNull() {
        Assert.assertNull((Object)StylesheetContentHashUtil.getContentHash((VaadinService)this.service, null));
    }

    @Test
    public void getContentHash_blankUrl_returnsNull() {
        Assert.assertNull((Object)StylesheetContentHashUtil.getContentHash((VaadinService)this.service, (String)"  "));
    }

    @Test
    public void getContentHash_missingResource_returnsNull() {
        Mockito.when((Object)this.service.getResourceAsStream("missing.css")).thenReturn(null);
        Mockito.when((Object)this.service.getResourceAsStream("/missing.css")).thenReturn(null);
        Assert.assertNull((Object)StylesheetContentHashUtil.getContentHash((VaadinService)this.service, (String)"missing.css"));
    }

    @Test
    public void getContentHash_barePath_fallsBackToSlashPrefixed() {
        byte[] content = "body { color: blue; }".getBytes(StandardCharsets.UTF_8);
        Mockito.when((Object)this.service.getResourceAsStream("bare.css")).thenReturn(null);
        Mockito.when((Object)this.service.getResourceAsStream("/bare.css")).thenReturn((Object)new ByteArrayInputStream(content));
        String hash = StylesheetContentHashUtil.getContentHash((VaadinService)this.service, (String)"bare.css");
        Assert.assertNotNull((Object)hash);
        Assert.assertEquals((long)8L, (long)hash.length());
    }

    @Test
    public void getContentHash_cachedAfterFirstCall() {
        byte[] content = "body {}".getBytes(StandardCharsets.UTF_8);
        Mockito.when((Object)this.service.getResourceAsStream("cached.css")).thenReturn((Object)new ByteArrayInputStream(content));
        String hash1 = StylesheetContentHashUtil.getContentHash((VaadinService)this.service, (String)"cached.css");
        String hash2 = StylesheetContentHashUtil.getContentHash((VaadinService)this.service, (String)"cached.css");
        Assert.assertEquals((Object)hash1, (Object)hash2);
        ((VaadinService)Mockito.verify((Object)this.service, (VerificationMode)Mockito.times((int)1))).getResourceAsStream("cached.css");
    }

    @Test
    public void getContentHash_servletContextFails_fallsBackToClasspath() {
        Mockito.when((Object)this.service.getResourceAsStream("classpath-test.css")).thenReturn(null);
        Mockito.when((Object)this.service.getResourceAsStream("/classpath-test.css")).thenReturn(null);
        String hash = StylesheetContentHashUtil.getContentHash((VaadinService)this.service, (String)"classpath-test.css");
        Assert.assertNotNull((String)"Should find resource via classpath static/ fallback", (Object)hash);
        Assert.assertEquals((long)8L, (long)hash.length());
    }

    @Test
    public void appendHashToUrl_withHash_appendsQueryParam() {
        String result = StylesheetContentHashUtil.appendHashToUrl((String)"/styles.css", (String)"abcd1234");
        Assert.assertEquals((Object)"/styles.css?v-c=abcd1234", (Object)result);
    }

    @Test
    public void appendHashToUrl_urlWithExistingQueryParam_usesAmpersand() {
        String result = StylesheetContentHashUtil.appendHashToUrl((String)"/styles.css?theme=dark", (String)"abcd1234");
        Assert.assertEquals((Object)"/styles.css?theme=dark&v-c=abcd1234", (Object)result);
    }

    @Test
    public void appendHashToUrl_nullHash_returnsOriginalUrl() {
        String result = StylesheetContentHashUtil.appendHashToUrl((String)"/styles.css", null);
        Assert.assertEquals((Object)"/styles.css", (Object)result);
    }
}

