/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal;

import com.vaadin.flow.internal.JacksonSerializer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.ArrayNode;
import tools.jackson.databind.node.BooleanNode;
import tools.jackson.databind.node.NullNode;
import tools.jackson.databind.node.NumericNode;
import tools.jackson.databind.node.ObjectNode;
import tools.jackson.databind.node.StringNode;

class JacksonSerializerTest {
    private static final double PRECISION = 1.0E-6;

    JacksonSerializerTest() {
    }

    @Test
    public void serializeBasicTypes_returnJsonBasicTypes() {
        JsonNode json = JacksonSerializer.toJson((Object)"someString");
        Assertions.assertTrue((boolean)(json instanceof StringNode), (String)"The JsonNode should be instanceof JsonString");
        Assertions.assertEquals((Object)"someString", (Object)json.asString());
        json = JacksonSerializer.toJson((Object)0);
        Assertions.assertTrue((boolean)(json instanceof NumericNode), (String)"The JsonNode should be instanceof JsonNumber");
        Assertions.assertEquals((double)0.0, (double)json.doubleValue(), (double)1.0E-6);
        json = JacksonSerializer.toJson((Object)0.0);
        Assertions.assertTrue((boolean)(json instanceof NumericNode), (String)"The JsonNode should be instanceof JsonNumber");
        Assertions.assertEquals((double)0.0, (double)json.doubleValue(), (double)1.0E-6);
        json = JacksonSerializer.toJson((Object)0L);
        Assertions.assertTrue((boolean)(json instanceof NumericNode), (String)"The JsonNode should be instanceof JsonNumber");
        Assertions.assertEquals((double)0.0, (double)json.doubleValue(), (double)1.0E-6);
        json = JacksonSerializer.toJson((Object)0);
        Assertions.assertTrue((boolean)(json instanceof NumericNode), (String)"The JsonNode should be instanceof JsonNumber");
        Assertions.assertEquals((double)0.0, (double)json.doubleValue(), (double)1.0E-6);
        json = JacksonSerializer.toJson((Object)0);
        Assertions.assertTrue((boolean)(json instanceof NumericNode), (String)"The JsonNode should be instanceof JsonNumber");
        Assertions.assertEquals((double)0.0, (double)json.doubleValue(), (double)1.0E-6);
        json = JacksonSerializer.toJson((Object)true);
        Assertions.assertTrue((boolean)(json instanceof BooleanNode), (String)"The JsonNode should be instanceof JsonBoolean");
        Assertions.assertTrue((boolean)json.asBoolean());
        json = JacksonSerializer.toJson((Object)false);
        Assertions.assertTrue((boolean)(json instanceof BooleanNode), (String)"The JsonNode should be instanceof JsonBoolean");
        Assertions.assertFalse((boolean)json.asBoolean());
        json = JacksonSerializer.toJson((Object)((Object)SomeEnum.SOME_VALUE_1));
        Assertions.assertTrue((boolean)(json instanceof StringNode), (String)"The JsonNode should be instanceof JsonString");
        Assertions.assertEquals((Object)SomeEnum.SOME_VALUE_1.name(), (Object)json.asString());
    }

    @Test
    public void serializeNull_returnNull() {
        JsonNode json = JacksonSerializer.toJson(null);
        Assertions.assertTrue((boolean)(json instanceof NullNode), (String)"The JsonNode should be instanceof JsonNull");
    }

    @Test
    public void serializeEmptyObjectWithBasicTypes_returnJsonObjectWithEmptyProperties() {
        ObjectWithSimpleTypes bean = new ObjectWithSimpleTypes();
        JsonNode json = JacksonSerializer.toJson((Object)bean);
        Assertions.assertTrue((boolean)(json instanceof ObjectNode), (String)"The JsonNode should be instanceof JsonObject");
        ObjectNode object = (ObjectNode)json;
        this.assertObjectHasNullValueForKey(object, "stringProperty");
        this.assertObjectHas0ValueForKey(object, "intProperty");
        this.assertObjectHasNullValueForKey(object, "integerProperty");
        this.assertObjectHas0ValueForKey(object, "longProperty");
        this.assertObjectHasNullValueForKey(object, "longObjectProperty");
        this.assertObjectHas0ValueForKey(object, "shortProperty");
        this.assertObjectHasNullValueForKey(object, "shortObjectProperty");
        this.assertObjectHas0ValueForKey(object, "doubleProperty");
        this.assertObjectHasNullValueForKey(object, "doubleObjectProperty");
        this.assertObjectHas0ValueForKey(object, "byteProperty");
        this.assertObjectHasNullValueForKey(object, "byteObjectProperty");
        this.assertObjectHasFalseValueForKey(object, "booleanProperty");
        this.assertObjectHasNullValueForKey(object, "booleanObjectProperty");
        this.assertObjectHasNullValueForKey(object, "characterProperty");
        this.assertObjectHasNullValueForKey(object, "enumProperty");
        Assertions.assertTrue((boolean)object.has("charProperty"));
        Assertions.assertEquals((char)'\u0000', (char)object.get("charProperty").asString().charAt(0));
        bean = (ObjectWithSimpleTypes)JacksonSerializer.toObject(ObjectWithSimpleTypes.class, (JsonNode)json);
        Assertions.assertNotNull((Object)bean);
        Assertions.assertNull((Object)bean.getStringProperty());
        Assertions.assertEquals((int)0, (int)bean.getIntProperty());
        Assertions.assertNull((Object)bean.getIntegerProperty());
        Assertions.assertEquals((long)0L, (long)bean.getLongProperty());
        Assertions.assertNull((Object)bean.getLongObjectProperty());
        Assertions.assertEquals((int)0, (int)bean.getShortProperty());
        Assertions.assertNull((Object)bean.getShortObjectProperty());
        Assertions.assertEquals((double)0.0, (double)bean.getDoubleProperty(), (double)1.0E-5);
        Assertions.assertNull((Object)bean.getDoubleObjectProperty());
        Assertions.assertEquals((int)0, (int)bean.getByteProperty());
        Assertions.assertNull((Object)bean.getByteObjectProperty());
        Assertions.assertEquals((Object)false, (Object)bean.isBooleanProperty());
        Assertions.assertNull((Object)bean.getBooleanObjectProperty());
        Assertions.assertEquals((int)0, (int)bean.getCharProperty());
        Assertions.assertNull((Object)bean.getCharacterProperty());
        Assertions.assertNull((Object)((Object)bean.getEnumProperty()));
    }

    @Test
    public void serializePopulatedObjectWithBasicTypes_returnJsonObjectWithDefinedProperties() {
        ObjectWithSimpleTypes bean = JacksonSerializerTest.getPopulatedObjectWithSimpleTypes();
        JsonNode json = JacksonSerializer.toJson((Object)bean);
        Assertions.assertTrue((boolean)(json instanceof ObjectNode), (String)"The JsonNode should be instanceof JsonObject");
        JsonNode object = json;
        Assertions.assertEquals((Object)"someProperty", (Object)object.get("stringProperty").asString());
        Assertions.assertEquals((double)1.0, (double)object.get("intProperty").intValue(), (double)1.0E-6);
        Assertions.assertEquals((double)2.0, (double)object.get("integerProperty").intValue(), (double)1.0E-6);
        Assertions.assertEquals((double)3.0, (double)object.get("longProperty").longValue(), (double)1.0E-6);
        Assertions.assertEquals((double)4.0, (double)object.get("longObjectProperty").longValue(), (double)1.0E-6);
        Assertions.assertEquals((double)5.0, (double)object.get("shortProperty").shortValue(), (double)1.0E-6);
        Assertions.assertEquals((double)6.0, (double)object.get("shortObjectProperty").shortValue(), (double)1.0E-6);
        Assertions.assertEquals((double)7.0, (double)object.get("doubleProperty").doubleValue(), (double)1.0E-6);
        Assertions.assertEquals((double)8.0, (double)object.get("doubleObjectProperty").doubleValue(), (double)1.0E-6);
        Assertions.assertEquals((double)9.0, (double)object.get("byteProperty").numberValue().byteValue(), (double)1.0E-6);
        Assertions.assertEquals((double)10.0, (double)object.get("byteObjectProperty").numberValue().byteValue(), (double)1.0E-6);
        Assertions.assertEquals((Object)true, (Object)object.get("booleanProperty").booleanValue());
        Assertions.assertEquals((Object)false, (Object)object.get("booleanObjectProperty").booleanValue());
        Assertions.assertEquals((char)'c', (char)object.get("charProperty").asString().charAt(0));
        Assertions.assertEquals((char)'C', (char)object.get("characterProperty").asString().charAt(0));
        Assertions.assertEquals((Object)SomeEnum.SOME_VALUE_2.name(), (Object)object.get("enumProperty").asString());
        bean = (ObjectWithSimpleTypes)JacksonSerializer.toObject(ObjectWithSimpleTypes.class, (JsonNode)json);
        Assertions.assertNotNull((Object)bean);
        Assertions.assertEquals((Object)"someProperty", (Object)bean.getStringProperty());
        Assertions.assertEquals((int)1, (int)bean.getIntProperty());
        Assertions.assertEquals((Integer)2, (Integer)bean.getIntegerProperty());
        Assertions.assertEquals((long)3L, (long)bean.getLongProperty());
        Assertions.assertEquals((Long)4L, (Long)bean.getLongObjectProperty());
        Assertions.assertEquals((int)5, (int)bean.getShortProperty());
        Assertions.assertEquals((Short)6, (Short)bean.getShortObjectProperty());
        Assertions.assertEquals((double)7.0, (double)bean.getDoubleProperty(), (double)1.0E-5);
        Assertions.assertEquals((Double)8.0, (Double)bean.getDoubleObjectProperty());
        Assertions.assertEquals((int)9, (int)bean.getByteProperty());
        Assertions.assertEquals((Byte)10, (Byte)bean.getByteObjectProperty());
        Assertions.assertEquals((Object)true, (Object)bean.isBooleanProperty());
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)bean.getBooleanObjectProperty());
        Assertions.assertEquals((char)'c', (char)bean.getCharProperty());
        Assertions.assertEquals((Character)Character.valueOf('C'), (Character)bean.getCharacterProperty());
        Assertions.assertEquals((Object)((Object)SomeEnum.SOME_VALUE_2), (Object)((Object)bean.getEnumProperty()));
    }

    @Test
    public void serializeEmptyObjectWithObjects_returnJsonObjectWithNullProperties() {
        ObjectWithOtherObjects bean = new ObjectWithOtherObjects();
        JsonNode json = JacksonSerializer.toJson((Object)bean);
        Assertions.assertTrue((boolean)(json instanceof ObjectNode), (String)"The JsonNode should be instanceof JsonObject");
        JsonNode jsonObject = json;
        Assertions.assertTrue((boolean)jsonObject.has("object1"));
        Assertions.assertTrue((boolean)(jsonObject.get("object1") instanceof NullNode));
        Assertions.assertTrue((boolean)jsonObject.has("object2"));
        Assertions.assertTrue((boolean)(jsonObject.get("object2") instanceof NullNode));
        Assertions.assertTrue((boolean)jsonObject.has("record"));
        Assertions.assertTrue((boolean)(jsonObject.get("record") instanceof NullNode));
        bean = (ObjectWithOtherObjects)JacksonSerializer.toObject(ObjectWithOtherObjects.class, (JsonNode)json);
        Assertions.assertNotNull((Object)bean, (String)"The deserialized object should not be null");
        Assertions.assertNull((Object)bean.getObject1());
        Assertions.assertNull((Object)bean.getObject2());
        Assertions.assertNull((Object)bean.getRecord());
    }

    @Test
    public void serializeObjectWithObjects_returnJsonObjectWithPopulatedProperties() {
        ObjectWithOtherObjects bean = new ObjectWithOtherObjects();
        ObjectWithSimpleTypes innerBean = JacksonSerializerTest.getPopulatedObjectWithSimpleTypes();
        bean.setObject1(innerBean);
        innerBean = new ObjectWithSimpleTypes();
        innerBean.setStringProperty("someOtherProperty");
        innerBean.setIntProperty(10);
        innerBean.setIntegerProperty(20);
        innerBean.setLongProperty(30L);
        innerBean.setLongObjectProperty(40L);
        innerBean.setShortProperty((short)50);
        innerBean.setShortObjectProperty((short)60);
        innerBean.setDoubleProperty(70.0);
        innerBean.setDoubleObjectProperty(80.0);
        innerBean.setByteProperty((byte)90);
        innerBean.setByteObjectProperty((byte)100);
        innerBean.setBooleanProperty(true);
        innerBean.setBooleanObjectProperty(false);
        innerBean.setCharProperty('d');
        innerBean.setCharacterProperty(Character.valueOf('D'));
        innerBean.setEnumProperty(SomeEnum.SOME_VALUE_1);
        bean.setObject2(innerBean);
        SomeRecord record = new SomeRecord("someone", 42);
        bean.setRecord(record);
        JsonNode json = JacksonSerializer.toJson((Object)bean);
        Assertions.assertTrue((boolean)(json instanceof ObjectNode), (String)"The JsonNode should be instanceof JsonObject");
        JsonNode object = json.get("object1");
        Assertions.assertNotNull((Object)object, (String)"The object1 should be not be null");
        Assertions.assertEquals((Object)"someProperty", (Object)object.get("stringProperty").asString());
        Assertions.assertEquals((double)1.0, (double)object.get("intProperty").intValue(), (double)1.0E-6);
        Assertions.assertEquals((double)2.0, (double)object.get("integerProperty").intValue(), (double)1.0E-6);
        Assertions.assertEquals((double)3.0, (double)object.get("longProperty").longValue(), (double)1.0E-6);
        Assertions.assertEquals((double)4.0, (double)object.get("longObjectProperty").longValue(), (double)1.0E-6);
        Assertions.assertEquals((double)5.0, (double)object.get("shortProperty").shortValue(), (double)1.0E-6);
        Assertions.assertEquals((double)6.0, (double)object.get("shortObjectProperty").shortValue(), (double)1.0E-6);
        Assertions.assertEquals((double)7.0, (double)object.get("doubleProperty").doubleValue(), (double)1.0E-6);
        Assertions.assertEquals((double)8.0, (double)object.get("doubleObjectProperty").doubleValue(), (double)1.0E-6);
        Assertions.assertEquals((double)9.0, (double)object.get("byteProperty").numberValue().byteValue(), (double)1.0E-6);
        Assertions.assertEquals((double)10.0, (double)object.get("byteObjectProperty").numberValue().byteValue(), (double)1.0E-6);
        Assertions.assertEquals((Object)true, (Object)object.get("booleanProperty").booleanValue());
        Assertions.assertEquals((Object)false, (Object)object.get("booleanObjectProperty").booleanValue());
        Assertions.assertEquals((char)'c', (char)object.get("charProperty").asString().charAt(0));
        Assertions.assertEquals((char)'C', (char)object.get("characterProperty").asString().charAt(0));
        Assertions.assertEquals((Object)SomeEnum.SOME_VALUE_2.name(), (Object)object.get("enumProperty").asString());
        object = json.get("object2");
        Assertions.assertNotNull((Object)object, (String)"The object2 should be not be null");
        Assertions.assertEquals((Object)"someOtherProperty", (Object)object.get("stringProperty").asString());
        Assertions.assertEquals((double)10.0, (double)object.get("intProperty").intValue(), (double)1.0E-6);
        Assertions.assertEquals((double)20.0, (double)object.get("integerProperty").intValue(), (double)1.0E-6);
        Assertions.assertEquals((double)30.0, (double)object.get("longProperty").longValue(), (double)1.0E-6);
        Assertions.assertEquals((double)40.0, (double)object.get("longObjectProperty").longValue(), (double)1.0E-6);
        Assertions.assertEquals((double)50.0, (double)object.get("shortProperty").shortValue(), (double)1.0E-6);
        Assertions.assertEquals((double)60.0, (double)object.get("shortObjectProperty").shortValue(), (double)1.0E-6);
        Assertions.assertEquals((double)70.0, (double)object.get("doubleProperty").doubleValue(), (double)1.0E-6);
        Assertions.assertEquals((double)80.0, (double)object.get("doubleObjectProperty").doubleValue(), (double)1.0E-6);
        Assertions.assertEquals((double)90.0, (double)object.get("byteProperty").numberValue().byteValue(), (double)1.0E-6);
        Assertions.assertEquals((double)100.0, (double)object.get("byteObjectProperty").numberValue().byteValue(), (double)1.0E-6);
        Assertions.assertEquals((Object)true, (Object)object.get("booleanProperty").booleanValue());
        Assertions.assertEquals((Object)false, (Object)object.get("booleanObjectProperty").booleanValue());
        Assertions.assertEquals((char)'d', (char)object.get("charProperty").asString().charAt(0));
        Assertions.assertEquals((char)'D', (char)object.get("characterProperty").asString().charAt(0));
        Assertions.assertEquals((Object)SomeEnum.SOME_VALUE_1.name(), (Object)object.get("enumProperty").asString());
        object = json.get("record");
        Assertions.assertNotNull((Object)object, (String)"The record should be not be null");
        Assertions.assertEquals((Object)"someone", (Object)object.get("name").asString());
        Assertions.assertEquals((double)42.0, (double)object.get("age").intValue(), (double)1.0E-6);
    }

    @Test
    public void serializeEmptyRecursiveObject_returnJsonObjectWithNullProperties() {
        RecursiveObject bean = new RecursiveObject();
        JsonNode json = JacksonSerializer.toJson((Object)bean);
        Assertions.assertTrue((boolean)(json instanceof ObjectNode), (String)"The JsonNode should be instanceof JsonObject");
        JsonNode jsonObject = json;
        Assertions.assertTrue((boolean)jsonObject.has("recursive"));
        Assertions.assertTrue((boolean)(jsonObject.get("recursive") instanceof NullNode));
        Assertions.assertEquals((double)0.0, (double)jsonObject.get("index").intValue(), (double)1.0E-6);
        bean = (RecursiveObject)JacksonSerializer.toObject(RecursiveObject.class, (JsonNode)json);
        Assertions.assertNotNull((Object)bean, (String)"The deserialized object should not be null");
        Assertions.assertNull((Object)bean.getRecursive());
        Assertions.assertEquals((int)0, (int)bean.getIndex());
    }

    @Test
    public void serializePopulatedRecursiveObject_returnJsonObjectWithPopulatedProperties() {
        int i;
        int recursions = 10;
        RecursiveObject bean = this.createRecusiveObject(10, 0);
        JsonNode json = JacksonSerializer.toJson((Object)bean);
        Assertions.assertTrue((boolean)(json instanceof ObjectNode), (String)"The JsonNode should be instanceof JsonObject");
        JsonNode object = json;
        for (i = 0; i < 10; ++i) {
            Assertions.assertEquals((double)i, (double)object.get("index").intValue(), (double)1.0E-6);
            if (i < 9) {
                object = object.get("recursive");
                continue;
            }
            Assertions.assertTrue((boolean)(object.get("recursive") instanceof NullNode));
        }
        bean = (RecursiveObject)JacksonSerializer.toObject(RecursiveObject.class, (JsonNode)json);
        for (i = 0; i < 10; ++i) {
            Assertions.assertEquals((int)i, (int)bean.getIndex());
            bean = bean.getRecursive();
        }
    }

    @Test
    public void serializeEmptyObjectWithBasicCollections_returnJsonObjectWithNullProperties() {
        ObjectWithBasicCollections bean = new ObjectWithBasicCollections();
        JsonNode json = JacksonSerializer.toJson((Object)bean);
        Assertions.assertTrue((boolean)(json instanceof ObjectNode), (String)"The JsonNode should be instanceof JsonObject");
        JsonNode jsonObject = json;
        Assertions.assertTrue((boolean)jsonObject.has("listOfStrings"));
        Assertions.assertTrue((boolean)(jsonObject.get("listOfStrings") instanceof NullNode));
        Assertions.assertTrue((boolean)jsonObject.has("setOfIntegers"));
        Assertions.assertTrue((boolean)(jsonObject.get("setOfIntegers") instanceof NullNode));
        Assertions.assertTrue((boolean)jsonObject.has("linkedListOfBooleans"));
        Assertions.assertTrue((boolean)(jsonObject.get("linkedListOfBooleans") instanceof NullNode));
        Assertions.assertTrue((boolean)jsonObject.has("arrayListOfDoubles"));
        Assertions.assertTrue((boolean)(jsonObject.get("arrayListOfDoubles") instanceof NullNode));
        Assertions.assertTrue((boolean)jsonObject.has("arrayOfStrings"));
        Assertions.assertTrue((boolean)(jsonObject.get("arrayOfStrings") instanceof NullNode));
        bean = (ObjectWithBasicCollections)JacksonSerializer.toObject(ObjectWithBasicCollections.class, (JsonNode)json);
        Assertions.assertNotNull((Object)bean, (String)"The deserialized object should not be null");
        Assertions.assertNull(bean.getListOfStrings());
        Assertions.assertNull(bean.getSetOfIntegers());
        Assertions.assertNull(bean.getLinkedListOfBooleans());
        Assertions.assertNull(bean.getArrayListOfDoubles());
    }

    @Test
    public void serializeObjectWithCollections_returnJsonObjectWithPopulatedProperties() {
        ObjectWithBasicCollections bean = new ObjectWithBasicCollections();
        bean.setListOfStrings(Arrays.asList("string1", "string2"));
        bean.setSetOfIntegers(new LinkedHashSet<Integer>(Arrays.asList(3, 4)));
        bean.setLinkedListOfBooleans(new LinkedList<Boolean>(Arrays.asList(true, false)));
        bean.setArrayListOfDoubles(new ArrayList<Double>(Arrays.asList(5.0, 6.0)));
        bean.setArrayOfStrings(new String[]{"string3", "string4"});
        JsonNode json = JacksonSerializer.toJson((Object)bean);
        Assertions.assertTrue((boolean)(json instanceof ObjectNode), (String)"The JsonNode should be instanceof JsonObject");
        JsonNode jsonObject = json;
        ArrayNode array = (ArrayNode)jsonObject.get("listOfStrings");
        Assertions.assertEquals((Object)"string1", (Object)array.get(0).asString());
        Assertions.assertEquals((Object)"string2", (Object)array.get(1).asString());
        array = (ArrayNode)jsonObject.get("setOfIntegers");
        Assertions.assertEquals((double)3.0, (double)array.get(0).intValue(), (double)1.0E-6);
        Assertions.assertEquals((double)4.0, (double)array.get(1).intValue(), (double)1.0E-6);
        array = (ArrayNode)jsonObject.get("linkedListOfBooleans");
        Assertions.assertEquals((Object)true, (Object)array.get(0).booleanValue());
        Assertions.assertEquals((Object)false, (Object)array.get(1).booleanValue());
        array = (ArrayNode)jsonObject.get("arrayListOfDoubles");
        Assertions.assertEquals((double)5.0, (double)array.get(0).doubleValue(), (double)1.0E-6);
        Assertions.assertEquals((double)6.0, (double)array.get(1).doubleValue(), (double)1.0E-6);
        array = (ArrayNode)jsonObject.get("arrayOfStrings");
        Assertions.assertEquals((Object)"string3", (Object)array.get(0).asString());
        Assertions.assertEquals((Object)"string4", (Object)array.get(1).asString());
        bean = (ObjectWithBasicCollections)JacksonSerializer.toObject(ObjectWithBasicCollections.class, (JsonNode)json);
        Assertions.assertNotNull((Object)bean, (String)"The deserialized object should not be null");
        this.assertCollectionItemsAreEqual(bean.getListOfStrings(), "string1", "string2");
        this.assertCollectionItemsAreEqual(bean.getSetOfIntegers(), 3, 4);
        this.assertCollectionItemsAreEqual(bean.getLinkedListOfBooleans(), true, false);
        this.assertCollectionItemsAreEqual(bean.getArrayListOfDoubles(), 5.0, 6.0);
        this.assertCollectionItemsAreEqual(List.of(bean.getArrayOfStrings()), "string3", "string4");
    }

    @Test
    public void serializeRecordWithRecordAndObject_returnJsonObjectWithPopulatedProperties() {
        SomeRecord record = new SomeRecord("someone", 42);
        ObjectWithSimpleTypes bean = JacksonSerializerTest.getPopulatedObjectWithSimpleTypes();
        RecordWithRecordAndObject mainRecord = new RecordWithRecordAndObject(record, bean);
        JsonNode json = JacksonSerializer.toJson((Object)mainRecord);
        Assertions.assertTrue((boolean)(json instanceof ObjectNode), (String)"The JsonNode should be instanceof JsonObject");
        JsonNode object = json;
        JsonNode nestedRecord = object.get("record");
        JsonNode nestedObject = object.get("object");
        Assertions.assertNotNull((Object)nestedRecord);
        Assertions.assertNotNull((Object)nestedObject);
        Assertions.assertEquals((Object)"someone", (Object)nestedRecord.get("name").asString());
        Assertions.assertEquals((double)42.0, (double)nestedRecord.get("age").intValue(), (double)1.0E-6);
        Assertions.assertEquals((Object)"someProperty", (Object)nestedObject.get("stringProperty").asString());
        Assertions.assertEquals((double)1.0, (double)nestedObject.get("intProperty").intValue(), (double)1.0E-6);
        Assertions.assertEquals((double)2.0, (double)nestedObject.get("integerProperty").intValue(), (double)1.0E-6);
        Assertions.assertEquals((double)3.0, (double)nestedObject.get("longProperty").longValue(), (double)1.0E-6);
        Assertions.assertEquals((double)4.0, (double)nestedObject.get("longObjectProperty").longValue(), (double)1.0E-6);
        Assertions.assertEquals((double)5.0, (double)nestedObject.get("shortProperty").shortValue(), (double)1.0E-6);
        Assertions.assertEquals((double)6.0, (double)nestedObject.get("shortObjectProperty").shortValue(), (double)1.0E-6);
        Assertions.assertEquals((double)7.0, (double)nestedObject.get("doubleProperty").doubleValue(), (double)1.0E-6);
        Assertions.assertEquals((double)8.0, (double)nestedObject.get("doubleObjectProperty").doubleValue(), (double)1.0E-6);
        Assertions.assertEquals((double)9.0, (double)nestedObject.get("byteProperty").numberValue().byteValue(), (double)1.0E-6);
        Assertions.assertEquals((double)10.0, (double)nestedObject.get("byteObjectProperty").numberValue().byteValue(), (double)1.0E-6);
        Assertions.assertTrue((boolean)nestedObject.get("booleanProperty").asBoolean());
        Assertions.assertFalse((boolean)nestedObject.get("booleanObjectProperty").asBoolean());
        Assertions.assertEquals((char)'c', (char)nestedObject.get("charProperty").asString().charAt(0));
        Assertions.assertEquals((char)'C', (char)nestedObject.get("characterProperty").asString().charAt(0));
        Assertions.assertEquals((Object)SomeEnum.SOME_VALUE_2.name(), (Object)nestedObject.get("enumProperty").asString());
        mainRecord = (RecordWithRecordAndObject)JacksonSerializer.toObject(RecordWithRecordAndObject.class, (JsonNode)json);
        Assertions.assertNotNull((Object)mainRecord);
        SomeRecord deserializedRecord = mainRecord.record;
        Assertions.assertEquals((Object)"someone", (Object)deserializedRecord.name);
        Assertions.assertEquals((int)42, (int)deserializedRecord.age);
        ObjectWithSimpleTypes deserializedObject = mainRecord.object;
        Assertions.assertEquals((Object)"someProperty", (Object)deserializedObject.getStringProperty());
        Assertions.assertEquals((int)1, (int)deserializedObject.getIntProperty());
        Assertions.assertEquals((Integer)2, (Integer)deserializedObject.getIntegerProperty());
        Assertions.assertEquals((long)3L, (long)deserializedObject.getLongProperty());
        Assertions.assertEquals((Long)4L, (Long)deserializedObject.getLongObjectProperty());
        Assertions.assertEquals((int)5, (int)deserializedObject.getShortProperty());
        Assertions.assertEquals((Short)6, (Short)deserializedObject.getShortObjectProperty());
        Assertions.assertEquals((double)7.0, (double)deserializedObject.getDoubleProperty(), (double)1.0E-5);
        Assertions.assertEquals((Double)8.0, (Double)deserializedObject.getDoubleObjectProperty());
        Assertions.assertEquals((int)9, (int)deserializedObject.getByteProperty());
        Assertions.assertEquals((Byte)10, (Byte)deserializedObject.getByteObjectProperty());
        Assertions.assertEquals((Object)true, (Object)deserializedObject.isBooleanProperty());
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)deserializedObject.getBooleanObjectProperty());
        Assertions.assertEquals((char)'c', (char)deserializedObject.getCharProperty());
        Assertions.assertEquals((Character)Character.valueOf('C'), (Character)deserializedObject.getCharacterProperty());
        Assertions.assertEquals((Object)((Object)SomeEnum.SOME_VALUE_2), (Object)((Object)deserializedObject.getEnumProperty()));
    }

    private static ObjectWithSimpleTypes getPopulatedObjectWithSimpleTypes() {
        ObjectWithSimpleTypes bean = new ObjectWithSimpleTypes();
        bean.setStringProperty("someProperty");
        bean.setIntProperty(1);
        bean.setIntegerProperty(2);
        bean.setLongProperty(3L);
        bean.setLongObjectProperty(4L);
        bean.setShortProperty((short)5);
        bean.setShortObjectProperty((short)6);
        bean.setDoubleProperty(7.0);
        bean.setDoubleObjectProperty(8.0);
        bean.setByteProperty((byte)9);
        bean.setByteObjectProperty((byte)10);
        bean.setBooleanProperty(true);
        bean.setBooleanObjectProperty(false);
        bean.setCharProperty('c');
        bean.setCharacterProperty(Character.valueOf('C'));
        bean.setEnumProperty(SomeEnum.SOME_VALUE_2);
        return bean;
    }

    private <T> void assertCollectionItemsAreEqual(Collection<T> collection, T ... values) {
        int index = 0;
        for (T collectionValue : collection) {
            Assertions.assertEquals(collectionValue, values[index]);
            ++index;
        }
    }

    private RecursiveObject createRecusiveObject(int recursions, int index) {
        if (index < recursions) {
            RecursiveObject bean = new RecursiveObject();
            bean.setIndex(index);
            bean.setRecursive(this.createRecusiveObject(recursions, index + 1));
            return bean;
        }
        return null;
    }

    private void assertObjectHasNullValueForKey(ObjectNode object, String key) {
        Assertions.assertTrue((boolean)object.has(key), (String)(key + " should be present in the JsonObject"));
        Assertions.assertTrue((boolean)(object.get(key) instanceof NullNode), (String)(key + " property should be JsonNull"));
    }

    private void assertObjectHas0ValueForKey(ObjectNode object, String key) {
        Assertions.assertTrue((boolean)object.has(key), (String)(key + " should be present in the JsonObject"));
        Assertions.assertEquals((double)0.0, (double)object.get(key).doubleValue(), (double)1.0E-6, (String)(key + " should be 0.0 in the JsonObject"));
    }

    private void assertObjectHasFalseValueForKey(ObjectNode object, String key) {
        Assertions.assertTrue((boolean)object.has(key), (String)(key + " should be present in the JsonObject"));
        Assertions.assertEquals((Object)false, (Object)object.get(key).booleanValue(), (String)(key + " should be false in the JsonObject"));
    }

    public static enum SomeEnum {
        SOME_VALUE_1,
        SOME_VALUE_2;

    }

    public static class ObjectWithSimpleTypes {
        private String stringProperty;
        private int intProperty;
        private Integer integerProperty;
        private long longProperty;
        private Long longObjectProperty;
        private short shortProperty;
        private Short shortObjectProperty;
        private double doubleProperty;
        private Double doubleObjectProperty;
        private byte byteProperty;
        private Byte byteObjectProperty;
        private boolean booleanProperty;
        private Boolean booleanObjectProperty;
        private char charProperty;
        private Character characterProperty;
        private SomeEnum enumProperty;

        public String getStringProperty() {
            return this.stringProperty;
        }

        public void setStringProperty(String stringProperty) {
            this.stringProperty = stringProperty;
        }

        public int getIntProperty() {
            return this.intProperty;
        }

        public void setIntProperty(int intProperty) {
            this.intProperty = intProperty;
        }

        public Integer getIntegerProperty() {
            return this.integerProperty;
        }

        public void setIntegerProperty(Integer integerProperty) {
            this.integerProperty = integerProperty;
        }

        public long getLongProperty() {
            return this.longProperty;
        }

        public void setLongProperty(long longProperty) {
            this.longProperty = longProperty;
        }

        public Long getLongObjectProperty() {
            return this.longObjectProperty;
        }

        public void setLongObjectProperty(Long longObjectProperty) {
            this.longObjectProperty = longObjectProperty;
        }

        public short getShortProperty() {
            return this.shortProperty;
        }

        public void setShortProperty(short shortProperty) {
            this.shortProperty = shortProperty;
        }

        public Short getShortObjectProperty() {
            return this.shortObjectProperty;
        }

        public void setShortObjectProperty(Short shortObjectProperty) {
            this.shortObjectProperty = shortObjectProperty;
        }

        public Double getDoubleObjectProperty() {
            return this.doubleObjectProperty;
        }

        public void setDoubleObjectProperty(Double doubleObjectProperty) {
            this.doubleObjectProperty = doubleObjectProperty;
        }

        public double getDoubleProperty() {
            return this.doubleProperty;
        }

        public void setDoubleProperty(double doubleProperty) {
            this.doubleProperty = doubleProperty;
        }

        public byte getByteProperty() {
            return this.byteProperty;
        }

        public void setByteProperty(byte byteProperty) {
            this.byteProperty = byteProperty;
        }

        public Byte getByteObjectProperty() {
            return this.byteObjectProperty;
        }

        public void setByteObjectProperty(Byte byteObjectProperty) {
            this.byteObjectProperty = byteObjectProperty;
        }

        public boolean isBooleanProperty() {
            return this.booleanProperty;
        }

        public void setBooleanProperty(boolean booleanProperty) {
            this.booleanProperty = booleanProperty;
        }

        public Boolean getBooleanObjectProperty() {
            return this.booleanObjectProperty;
        }

        public void setBooleanObjectProperty(Boolean booleanObjectProperty) {
            this.booleanObjectProperty = booleanObjectProperty;
        }

        public char getCharProperty() {
            return this.charProperty;
        }

        public void setCharProperty(char charProperty) {
            this.charProperty = charProperty;
        }

        public Character getCharacterProperty() {
            return this.characterProperty;
        }

        public void setCharacterProperty(Character characterProperty) {
            this.characterProperty = characterProperty;
        }

        public SomeEnum getEnumProperty() {
            return this.enumProperty;
        }

        public void setEnumProperty(SomeEnum enumProperty) {
            this.enumProperty = enumProperty;
        }
    }

    public static class ObjectWithOtherObjects {
        private ObjectWithSimpleTypes object1;
        private ObjectWithSimpleTypes object2;
        private SomeRecord record;

        public ObjectWithSimpleTypes getObject1() {
            return this.object1;
        }

        public void setObject1(ObjectWithSimpleTypes object1) {
            this.object1 = object1;
        }

        public ObjectWithSimpleTypes getObject2() {
            return this.object2;
        }

        public void setObject2(ObjectWithSimpleTypes object2) {
            this.object2 = object2;
        }

        public SomeRecord getRecord() {
            return this.record;
        }

        public void setRecord(SomeRecord record) {
            this.record = record;
        }
    }

    public record SomeRecord(String name, int age) {
    }

    public static class RecursiveObject {
        private RecursiveObject recursive;
        private int index;

        public RecursiveObject getRecursive() {
            return this.recursive;
        }

        public void setRecursive(RecursiveObject recursive) {
            this.recursive = recursive;
        }

        public int getIndex() {
            return this.index;
        }

        public void setIndex(int index) {
            this.index = index;
        }
    }

    public static class ObjectWithBasicCollections {
        private List<String> listOfStrings;
        private Set<Integer> setOfIntegers;
        private LinkedList<Boolean> linkedListOfBooleans;
        private List<Double> arrayListOfDoubles;
        private String[] arrayOfStrings;

        public List<String> getListOfStrings() {
            return this.listOfStrings;
        }

        public void setListOfStrings(List<String> listOfStrings) {
            this.listOfStrings = listOfStrings;
        }

        public Set<Integer> getSetOfIntegers() {
            return this.setOfIntegers;
        }

        public void setSetOfIntegers(Set<Integer> setOfIntegers) {
            this.setOfIntegers = setOfIntegers;
        }

        public LinkedList<Boolean> getLinkedListOfBooleans() {
            return this.linkedListOfBooleans;
        }

        public void setLinkedListOfBooleans(LinkedList<Boolean> linkedListOfBooleans) {
            this.linkedListOfBooleans = linkedListOfBooleans;
        }

        public List<Double> getArrayListOfDoubles() {
            return this.arrayListOfDoubles;
        }

        public void setArrayListOfDoubles(List<Double> arrayListOfDoubles) {
            this.arrayListOfDoubles = arrayListOfDoubles;
        }

        public String[] getArrayOfStrings() {
            return this.arrayOfStrings;
        }

        public void setArrayOfStrings(String[] arrayOfStrings) {
            this.arrayOfStrings = arrayOfStrings;
        }
    }

    public record RecordWithRecordAndObject(SomeRecord record, ObjectWithSimpleTypes object) {
    }
}

