/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal;

import com.vaadin.flow.internal.DevBundleUtils;
import com.vaadin.flow.internal.StringUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import org.apache.commons.io.FileUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

class DevBundleUtilsTest {
    @TempDir
    Path temporaryFolder;

    DevBundleUtilsTest() {
    }

    @Test
    public void compileDevBundle_uncompileDevBundle_filesHasSameHash() throws IOException {
        File projectBase = this.temporaryFolder.toFile();
        File devFolder = new File(projectBase, "target/dev-bundle");
        devFolder.mkdirs();
        File configFolder = new File(devFolder, "config");
        configFolder.mkdir();
        File stats = new File(configFolder, "stats.json");
        File packages = new File(devFolder, "package.json");
        Files.write(stats.toPath(), Collections.singleton("{ \"stats\": 1 }"), new OpenOption[0]);
        Files.write(packages.toPath(), Collections.singleton("{ \"packages\": [] }"), new OpenOption[0]);
        String statsHash = StringUtil.getHash((String)Files.readString(stats.toPath()));
        String packagesHash = StringUtil.getHash((String)Files.readString(packages.toPath()));
        DevBundleUtils.compressBundle((File)projectBase, (File)devFolder);
        Assertions.assertTrue((boolean)new File(projectBase, "src/main/bundles/dev.bundle").exists(), (String)"Compressed bundle should have been created");
        FileUtils.deleteDirectory((File)devFolder);
        Assertions.assertFalse((boolean)devFolder.exists(), (String)"Dev folder not deleted!");
        DevBundleUtils.unpackBundle((File)projectBase, (File)devFolder);
        Assertions.assertTrue((boolean)devFolder.exists(), (String)"Dev folder not created!");
        Assertions.assertTrue((boolean)configFolder.exists(), (String)"Config folder not created!");
        Assertions.assertTrue((boolean)stats.exists(), (String)"stats file not created!");
        Assertions.assertTrue((boolean)packages.exists(), (String)"packages file not created!");
        Assertions.assertEquals((Object)statsHash, (Object)StringUtil.getHash((String)Files.readString(stats.toPath())));
        Assertions.assertEquals((Object)packagesHash, (Object)StringUtil.getHash((String)Files.readString(packages.toPath())));
    }
}

