/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.dom;

import com.vaadin.flow.dom.impl.ShadowRootStateProvider;
import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.internal.nodefeature.ShadowRootData;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ShadowRootStateProviderTest {
    ShadowRootStateProviderTest() {
    }

    @Test
    public void supportsSelfCreatedNode() {
        ShadowRootStateProvider provider = ShadowRootStateProvider.get();
        StateNode node = new StateNode(new Class[]{ShadowRootData.class});
        StateNode shadowRoot = provider.createShadowRootNode(node);
        Assertions.assertTrue((boolean)provider.supports(shadowRoot));
    }

    @Test
    public void doesNotSupportEmptyNode() {
        ShadowRootStateProvider provider = ShadowRootStateProvider.get();
        Assertions.assertFalse((boolean)provider.supports(new StateNode(new Class[0])));
    }

    @Test
    public void createShadowRootNode_originalNodeIsInitialized() {
        ShadowRootStateProvider provider = ShadowRootStateProvider.get();
        StateNode node = new StateNode(new Class[]{ShadowRootData.class});
        StateNode shadowRoot = provider.createShadowRootNode(node);
        Assertions.assertEquals((Object)shadowRoot, (Object)((ShadowRootData)node.getFeature(ShadowRootData.class)).getShadowRoot());
    }

    @Test
    public void getParent_parentIsHostElement() {
        ShadowRootStateProvider provider = ShadowRootStateProvider.get();
        StateNode node = new StateNode(new Class[]{ShadowRootData.class});
        StateNode shadowRoot = provider.createShadowRootNode(node);
        Assertions.assertEquals((Object)node, (Object)shadowRoot.getParent());
    }
}

