/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.dom;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasText;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.internal.CurrentInstance;
import com.vaadin.flow.internal.nodefeature.TextBindingFeature;
import com.vaadin.flow.server.ErrorEvent;
import com.vaadin.flow.server.MockVaadinServletService;
import com.vaadin.flow.server.MockVaadinSession;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.signals.BindingActiveException;
import com.vaadin.flow.signals.Signal;
import com.vaadin.flow.signals.function.SignalComputation;
import com.vaadin.flow.signals.function.SignalMapper;
import com.vaadin.flow.signals.local.ValueSignal;
import com.vaadin.tests.util.MockUI;
import java.io.Serializable;
import java.util.LinkedList;
import org.jspecify.annotations.Nullable;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class ElementBindTextTest {
    private static MockVaadinServletService service;
    private LinkedList<ErrorEvent> events;

    ElementBindTextTest() {
    }

    @BeforeAll
    public static void init() {
        service = new MockVaadinServletService();
    }

    @AfterAll
    public static void clean() {
        CurrentInstance.clearAll();
        service.destroy();
    }

    @BeforeEach
    public void before() {
        this.events = this.mockLockedSessionWithErrorHandler();
    }

    @AfterEach
    public void after() {
        CurrentInstance.clearAll();
        this.events = null;
    }

    private LinkedList<ErrorEvent> mockLockedSessionWithErrorHandler() {
        VaadinService.setCurrent((VaadinService)service);
        MockVaadinSession session = new MockVaadinSession((VaadinService)service);
        session.lock();
        MockUI ui = new MockUI(session);
        LinkedList<ErrorEvent> events = new LinkedList<ErrorEvent>();
        session.setErrorHandler(events::add);
        return events;
    }

    @Test
    public void bindTextComputedSignal_getText_returnsCorrectValue() {
        Element element = new Element("span");
        UI.getCurrent().getElement().appendChild(new Element[]{element});
        ValueSignal signal = new ValueSignal((Object)"text");
        Signal computedSignal = Signal.computed((SignalComputation & Serializable)() -> "computed-" + (String)signal.get());
        element.bindText(computedSignal);
        Assertions.assertEquals((Object)"computed-text", (Object)element.getText());
    }

    @Test
    public void bindTextMappedSignal_getText_returnsCorrectValue() {
        Element element = new Element("span");
        UI.getCurrent().getElement().appendChild(new Element[]{element});
        ValueSignal signal = new ValueSignal((Object)"text");
        element.bindText(signal.map((SignalMapper & Serializable)text -> "mapped-" + text));
        Assertions.assertEquals((Object)"mapped-text", (Object)element.getText());
    }

    @Test
    public void bindText_detachAttach_returnsCorrectValue() {
        Element element = new Element("span");
        UI.getCurrent().getElement().appendChild(new Element[]{element});
        ValueSignal signal = new ValueSignal((Object)"text");
        element.bindText((Signal)signal);
        Assertions.assertEquals((Object)"text", (Object)element.getText());
        UI.getCurrent().getElement().removeChild(new Element[]{element});
        signal.set((Object)"text2");
        Assertions.assertEquals((Object)"text", (Object)element.getText());
        UI.getCurrent().getElement().appendChild(new Element[]{element});
        Assertions.assertEquals((Object)"text2", (Object)element.getText());
    }

    @Test
    public void bindText_setTextWithExistingActiveBinding_throws() {
        Element element = new Element("span");
        UI.getCurrent().getElement().appendChild(new Element[]{element});
        ValueSignal signal = new ValueSignal((Object)"text");
        element.bindText((Signal)signal);
        Assertions.assertThrows(BindingActiveException.class, () -> element.setText("text2"));
    }

    @Test
    public void bindText_setTextWithExistingInactiveBinding_throws() {
        Element element = new Element("span");
        UI.getCurrent().getElement().appendChild(new Element[]{element});
        ValueSignal signal = new ValueSignal((Object)"text");
        element.bindText((Signal)signal);
        UI.getCurrent().getElement().removeChild(new Element[]{element});
        Assertions.assertThrows(BindingActiveException.class, () -> element.setText("text2"));
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void bindText_initialEmptySignalValue_treatAsBlank() {
        Element element = new Element("span");
        UI.getCurrent().getElement().appendChild(new Element[]{element});
        @Nullable ValueSignal signal = new ValueSignal(null);
        element.bindText((Signal)signal);
        Assertions.assertEquals((Object)"", (Object)element.getText());
        Assertions.assertTrue((boolean)this.events.isEmpty());
    }

    @Test
    public void bindText_setNullSignalValue_treatAsBlank() {
        Element element = new Element("span");
        UI.getCurrent().getElement().appendChild(new Element[]{element});
        ValueSignal signal = new ValueSignal((Object)"text");
        element.bindText((Signal)signal);
        signal.set(null);
        Assertions.assertTrue((boolean)this.events.isEmpty());
        Assertions.assertEquals((Object)"", (Object)element.getText());
    }

    @Test
    public void bindText_bindTextWithExistingActiveBinding_throws() {
        Element element = new Element("span");
        UI.getCurrent().getElement().appendChild(new Element[]{element});
        ValueSignal signal = new ValueSignal((Object)"text");
        element.bindText((Signal)signal);
        ValueSignal signal2 = new ValueSignal((Object)"text2");
        Assertions.assertThrows(BindingActiveException.class, () -> element.bindText((Signal)signal2));
    }

    @Test
    public void bindText_bindTextWithExistingInactiveBinding_returnsCorrectValue() {
        Element element = new Element("span");
        UI.getCurrent().getElement().appendChild(new Element[]{element});
        ValueSignal signal = new ValueSignal((Object)"text");
        element.bindText((Signal)signal);
        UI.getCurrent().getElement().removeChild(new Element[]{element});
        ValueSignal signal2 = new ValueSignal((Object)"text2");
        element.bindText((Signal)signal2);
    }

    @Test
    public void bindText_removeBindingViaFeature_stopsUpdatesAndAllowsManualSet() {
        Element element = new Element("span");
        UI.getCurrent().getElement().appendChild(new Element[]{element});
        ValueSignal signal = new ValueSignal((Object)"text");
        element.bindText((Signal)signal);
        Assertions.assertEquals((Object)"text", (Object)element.getText());
        TextBindingFeature feature = (TextBindingFeature)element.getNode().getFeature(TextBindingFeature.class);
        feature.removeBinding();
        signal.set((Object)"text2");
        Assertions.assertEquals((Object)"text", (Object)element.getText());
        element.setText("manual");
        Assertions.assertEquals((Object)"manual", (Object)element.getText());
    }

    @Test
    public void bindText_nullSignal_throwsNPE() {
        Element element = new Element("span");
        UI.getCurrent().getElement().appendChild(new Element[]{element});
        Assertions.assertThrows(NullPointerException.class, () -> element.bindText(null));
    }

    @Test
    public void bindText_componentNotAttached_bindingIgnored() {
        Element element = new Element("span");
        ValueSignal signal = new ValueSignal((Object)"text");
        element.bindText((Signal)signal);
        Assertions.assertEquals((Object)"", (Object)element.getText());
    }

    @Test
    public void bindText_componentAttached_returnsCorrectValue() {
        Element element = new Element("span");
        UI.getCurrent().getElement().appendChild(new Element[]{element});
        ValueSignal signal = new ValueSignal((Object)"text");
        element.bindText((Signal)signal);
        Assertions.assertEquals((Object)"text", (Object)element.getText());
        signal.set((Object)"text2");
        Assertions.assertEquals((Object)"text2", (Object)element.getText());
    }

    @Test
    public void lazyInitSignalBindingFeature() {
        Element element = new Element("span");
        UI.getCurrent().getElement().appendChild(new Element[]{element});
        element.setText("text2");
        element.getText();
        element.getNode().getFeatureIfInitialized(TextBindingFeature.class).ifPresent(feature -> Assertions.fail((String)"TextBindingFeature should not be initialized before binding a signal"));
        ValueSignal signal = new ValueSignal((Object)"text");
        element.bindText((Signal)signal);
        element.getNode().getFeatureIfInitialized(TextBindingFeature.class).orElseThrow(() -> new AssertionError((Object)"TextBindingFeature should be initialized after binding a signal"));
    }

    @Test
    public void bindText_componentWithHasText() {
        @Tag(value="span")
        class SpanWithHasText
        extends Component
        implements HasText {
            SpanWithHasText() {
            }
        }
        SpanWithHasText span = new SpanWithHasText();
        UI.getCurrent().add(new Component[]{span});
        ValueSignal signal = new ValueSignal((Object)"text");
        span.bindText((Signal)signal);
        Assertions.assertEquals((Object)"text", (Object)span.getText());
        signal.set((Object)"text2");
        Assertions.assertEquals((Object)"text2", (Object)span.getText());
        signal.set(null);
        Assertions.assertEquals((Object)"", (Object)span.getText());
        Assertions.assertThrows(BindingActiveException.class, () -> span.setText(""));
        UI.getCurrent().remove(new Component[]{span});
        signal.set((Object)"text3");
        Assertions.assertEquals((Object)"", (Object)span.getText());
        UI.getCurrent().add(new Component[]{span});
        Assertions.assertEquals((Object)"text3", (Object)span.getText());
    }

    @Test
    public void bindText_hasText_nullSignal_throwsNPE() {
        @Tag(value="span")
        class SpanWithHasText
        extends Component
        implements HasText {
            SpanWithHasText() {
            }
        }
        SpanWithHasText span = new SpanWithHasText();
        UI.getCurrent().add(new Component[]{span});
        Assertions.assertThrows(NullPointerException.class, () -> span.bindText(null));
    }
}

