/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.Shortcuts;
import com.vaadin.flow.router.RouterLink;
import com.vaadin.flow.shared.Registration;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ShortcutsTest {
    ShortcutsTest() {
    }

    @Test
    public void hasOnlyStaticMethods() {
        Method[] methods;
        for (Method method : methods = Shortcuts.class.getDeclaredMethods()) {
            if (Modifier.isStatic(method.getModifiers())) continue;
            Assertions.fail((String)String.format("Method %s(%s) should be static", method.getName(), Stream.of(method.getParameterTypes()).map(Class::getSimpleName).collect(Collectors.joining(", "))));
        }
    }

    @Test
    public void setShortcutListenOnElementLocatorJs_storesLocatorOnComponentData() {
        RouterLink routerLink = new RouterLink();
        String locator = "foobar";
        Registration registration = Shortcuts.setShortcutListenOnElement((String)"foobar", (Component)routerLink);
        Assertions.assertEquals((Object)"foobar", (Object)ComponentUtil.getData((Component)routerLink, (String)"_element_locator_js_key"));
        registration.remove();
        Assertions.assertNull((Object)ComponentUtil.getData((Component)routerLink, (String)"_element_locator_js_key"));
    }

    @Test
    public void setShortcutListenOnElementLocatorJs_registrationDoesNotRemoveModifiedData_nullClearsAlways() {
        RouterLink routerLink = new RouterLink();
        String locator = "foobar";
        Registration registration = Shortcuts.setShortcutListenOnElement((String)"foobar", (Component)routerLink);
        Assertions.assertEquals((Object)"foobar", (Object)ComponentUtil.getData((Component)routerLink, (String)"_element_locator_js_key"));
        Shortcuts.setShortcutListenOnElement((String)"another", (Component)routerLink);
        registration.remove();
        Assertions.assertEquals((Object)"another", (Object)ComponentUtil.getData((Component)routerLink, (String)"_element_locator_js_key"));
        Registration nullRegistration = Shortcuts.setShortcutListenOnElement(null, (Component)routerLink);
        Assertions.assertNull((Object)ComponentUtil.getData((Component)routerLink, (String)"_element_locator_js_key"));
        nullRegistration.remove();
    }
}

