/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Key;
import com.vaadin.flow.component.KeyModifier;
import com.vaadin.flow.component.ShortcutEvent;
import java.util.Arrays;
import java.util.HashSet;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class ShortcutEventTest {
    private ShortcutEvent eventNoModifiers = ShortcutEventTest.event(Key.KEY_F, new KeyModifier[0]);
    private ShortcutEvent eventOneModifier = ShortcutEventTest.event(Key.KEY_F, KeyModifier.ALT);
    private ShortcutEvent eventTwoModifiers = ShortcutEventTest.event(Key.KEY_F, KeyModifier.ALT, KeyModifier.CONTROL);
    private ShortcutEvent eventWithAltAndAltGr = ShortcutEventTest.event(Key.KEY_F, KeyModifier.ALT, KeyModifier.ALT_GRAPH);

    ShortcutEventTest() {
    }

    @Test
    public void matches() {
        Assertions.assertFalse((boolean)this.eventNoModifiers.matches(null, new KeyModifier[0]), (String)"Null key should return false");
        Assertions.assertFalse((boolean)this.eventNoModifiers.matches(Key.KEY_F, new KeyModifier[]{KeyModifier.ALT}), (String)"Extra modifier should return false");
        Assertions.assertFalse((boolean)this.eventOneModifier.matches(Key.KEY_F, new KeyModifier[0]), (String)"Missing modifier should return false");
        Assertions.assertFalse((boolean)this.eventWithAltAndAltGr.matches(Key.KEY_F, new KeyModifier[]{KeyModifier.ALT, KeyModifier.ALT_GRAPH, KeyModifier.CONTROL}), (String)"Matching key and two modifiers (Alt, Alt_Gr) plus an extra one (Control), should return false");
        Assertions.assertTrue((boolean)this.eventNoModifiers.matches(Key.KEY_F, new KeyModifier[0]), (String)"Matching key should return true");
        Assertions.assertTrue((boolean)this.eventOneModifier.matches(Key.KEY_F, new KeyModifier[]{KeyModifier.ALT}), (String)"Matching key and modifier should return true");
        Assertions.assertTrue((boolean)this.eventTwoModifiers.matches(Key.KEY_F, new KeyModifier[]{KeyModifier.ALT, KeyModifier.CONTROL}), (String)"Matching key and two modifiers should return true");
        Assertions.assertTrue((boolean)this.eventWithAltAndAltGr.matches(Key.KEY_F, new KeyModifier[]{KeyModifier.ALT_GRAPH, KeyModifier.ALT}), (String)"Matching key and two modifiers (Alt_Gr, Alt) should return true");
    }

    private static ShortcutEvent event(Key key, KeyModifier ... modifiers) {
        Component component = (Component)Mockito.mock(Component.class);
        return new ShortcutEvent(component, component, key, new HashSet<KeyModifier>(Arrays.asList(modifiers)));
    }
}

