/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.i18n.LocaleChangeEvent;
import com.vaadin.flow.i18n.LocaleChangeObserver;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.router.RouteConfiguration;
import com.vaadin.flow.router.Router;
import com.vaadin.flow.router.TestRouteRegistry;
import com.vaadin.flow.server.InvalidRouteConfigurationException;
import com.vaadin.flow.server.RouteRegistry;
import com.vaadin.tests.util.MockUI;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class LocationObserverTest {
    protected Router router;
    private UI ui;
    private static List<String> eventCollector = new ArrayList<String>(0);

    LocationObserverTest() {
    }

    @BeforeEach
    public void init() throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        this.ui = new MockUI();
        eventCollector.clear();
    }

    @Test
    public void navigation_and_locale_change_should_fire_locale_change_observer() throws InvalidRouteConfigurationException {
        this.router = new Router((RouteRegistry)new TestRouteRegistry());
        this.ui = new MockUI(this.router);
        RouteConfiguration.forRegistry((RouteRegistry)this.router.getRegistry()).setAnnotatedRoute(Translations.class);
        this.ui.navigate("");
        Assertions.assertEquals((int)1, (int)eventCollector.size(), (String)"Expected event amount was wrong");
        Assertions.assertEquals((Object)("Received locale change event for locale: " + Locale.getDefault().getDisplayName()), (Object)eventCollector.get(0));
        this.ui.setLocale(Locale.CANADA);
        Assertions.assertEquals((int)2, (int)eventCollector.size(), (String)"Expected event amount was wrong");
        Assertions.assertEquals((Object)("Received locale change event for locale: " + Locale.CANADA.getDisplayName()), (Object)eventCollector.get(1));
    }

    @Test
    public void location_change_should_only_fire_if_location_actually_changed() {
        this.ui.add(new Component[]{new Translations()});
        Assertions.assertEquals((int)1, (int)eventCollector.size(), (String)"Expected event amount was wrong");
        Assertions.assertEquals((Object)("Received locale change event for locale: " + Locale.getDefault().getDisplayName()), (Object)eventCollector.get(0));
        this.ui.setLocale(this.ui.getLocale());
        Assertions.assertEquals((int)1, (int)eventCollector.size(), (String)"Expected event amount was wrong");
        this.ui.setLocale(Locale.FRENCH);
        Assertions.assertEquals((int)2, (int)eventCollector.size(), (String)"Expected event amount was wrong");
        Assertions.assertEquals((Object)("Received locale change event for locale: " + Locale.FRENCH.getDisplayName()), (Object)eventCollector.get(1));
    }

    @Test
    public void location_change_should_be_fired_also_on_component_attach() {
        RootComponent root = new RootComponent();
        this.ui.add(new Component[]{root});
        Assertions.assertEquals((int)0, (int)eventCollector.size(), (String)"Expected event amount was wrong");
        root.getElement().appendChild(new Element[]{new Translations().getElement()});
        Assertions.assertEquals((int)1, (int)eventCollector.size(), (String)"Expected event amount was wrong");
        Assertions.assertEquals((Object)("Received locale change event for locale: " + Locale.getDefault().getDisplayName()), (Object)eventCollector.get(0));
    }

    @Test
    public void location_change_should_be_fired_also_on_consequent_component_attach() {
        RootComponent root = new RootComponent();
        this.ui.add(new Component[]{root});
        Assertions.assertEquals((int)0, (int)eventCollector.size(), (String)"No change observers so no events should be gotten.");
        Translations translations = new Translations();
        root.getElement().appendChild(new Element[]{translations.getElement()});
        Assertions.assertEquals((int)1, (int)eventCollector.size(), (String)"Observer should have been notified on attach");
        translations.getElement().removeFromParent();
        Assertions.assertEquals((int)1, (int)eventCollector.size(), (String)"No event should have been gotten for removal");
        root.getElement().appendChild(new Element[]{translations.getElement()});
        Assertions.assertEquals((int)2, (int)eventCollector.size(), (String)"Reattach should have given an event");
    }

    @Route(value="")
    @Tag(value="div")
    public static class Translations
    extends Component
    implements LocaleChangeObserver {
        public void localeChange(LocaleChangeEvent event) {
            eventCollector.add("Received locale change event for locale: " + event.getLocale().getDisplayName());
            Assertions.assertNotNull((Object)event.getUI());
        }
    }

    @Route(value="")
    @Tag(value="div")
    public static class RootComponent
    extends Component {
    }
}

