/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.UITest;
import com.vaadin.flow.function.DeploymentConfiguration;
import com.vaadin.flow.internal.CurrentInstance;
import com.vaadin.flow.router.RouteConfiguration;
import com.vaadin.flow.server.Command;
import com.vaadin.flow.server.InvalidRouteConfigurationException;
import com.vaadin.flow.server.MockVaadinContext;
import com.vaadin.flow.server.MockVaadinServletService;
import com.vaadin.flow.server.RouteRegistry;
import com.vaadin.flow.server.ServiceException;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinResponse;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinServletRequest;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.tests.util.AlwaysLockedVaadinSession;
import java.io.File;
import java.io.Serializable;
import java.util.Arrays;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;

class InvalidUrlTest {
    InvalidUrlTest() {
    }

    @Test
    public void invalidUrlAtInitialization_uiInitialiazesWith404ReturnCode() throws InvalidRouteConfigurationException, ServiceException {
        UI ui = new UI();
        ArgumentCaptor statusCodeCaptor = ArgumentCaptor.forClass(Integer.class);
        InvalidUrlTest.initUI(ui, "%3faaa", (ArgumentCaptor<Integer>)statusCodeCaptor);
        Assertions.assertEquals((Integer)404, (Integer)((Integer)statusCodeCaptor.getValue()), (String)"Return message should have been 404 not found.");
    }

    @AfterEach
    public void tearDown() {
        CurrentInstance.clearAll();
    }

    private static void initUI(UI ui, String initialLocation, ArgumentCaptor<Integer> statusCodeCaptor) throws InvalidRouteConfigurationException, ServiceException {
        String pathInfo;
        VaadinServletRequest request = (VaadinServletRequest)Mockito.mock(VaadinServletRequest.class);
        VaadinResponse response = (VaadinResponse)Mockito.mock(VaadinResponse.class);
        if (initialLocation.isEmpty()) {
            pathInfo = null;
        } else {
            Assertions.assertFalse((boolean)initialLocation.startsWith("/"));
            pathInfo = "/" + initialLocation;
        }
        Mockito.when((Object)request.getPathInfo()).thenReturn((Object)pathInfo);
        MockVaadinServletService service = new MockVaadinServletService(){

            public VaadinContext getContext() {
                return new MockVaadinContext();
            }

            @Override
            public DeploymentConfiguration getDeploymentConfiguration() {
                if (super.getDeploymentConfiguration() != null) {
                    return super.getDeploymentConfiguration();
                }
                DeploymentConfiguration config = (DeploymentConfiguration)Mockito.mock(DeploymentConfiguration.class);
                Mockito.when((Object)config.isProductionMode()).thenReturn((Object)false);
                this.setConfiguration(config);
                return config;
            }
        };
        service.setCurrentInstances((VaadinRequest)request, response);
        AlwaysLockedVaadinSession session = new AlwaysLockedVaadinSession((VaadinService)service);
        DeploymentConfiguration config = (DeploymentConfiguration)Mockito.mock(DeploymentConfiguration.class);
        Mockito.when((Object)config.isProductionMode()).thenReturn((Object)false);
        Mockito.when((Object)config.getFrontendFolder()).thenReturn((Object)new File("front"));
        Mockito.when((Object)config.getProjectFolder()).thenReturn((Object)new File("./"));
        Mockito.when((Object)config.getBuildFolder()).thenReturn((Object)"build");
        ((MockVaadinServletService)service).setConfiguration(config);
        CurrentInstance.set(VaadinSession.class, (Object)((Object)session));
        ui.getInternals().setSession((VaadinSession)session);
        RouteConfiguration routeConfiguration = RouteConfiguration.forRegistry((RouteRegistry)ui.getInternals().getRouter().getRegistry());
        routeConfiguration.update((Command & Serializable)() -> {
            routeConfiguration.getHandledRegistry().clean();
            Arrays.asList(UITest.RootNavigationTarget.class, UITest.FooBarNavigationTarget.class).forEach(arg_0 -> ((RouteConfiguration)routeConfiguration).setAnnotatedRoute(arg_0));
        });
        ui.doInit((VaadinRequest)request, 0, "foo");
        ui.getInternals().getRouter().initializeUI(ui, UITest.requestToLocation((VaadinRequest)request));
        if (statusCodeCaptor != null) {
            ((VaadinResponse)Mockito.verify((Object)response)).setStatus(((Integer)statusCodeCaptor.capture()).intValue());
        }
    }
}

