/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.ComponentTest;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.PollEvent;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.Collection;
import java.util.Set;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ComponentUtilTest {
    private Component component = new ComponentTest.TestDiv();

    ComponentUtilTest() {
    }

    @Test
    public void setData_byString() {
        Assertions.assertNull((Object)ComponentUtil.getData((Component)this.component, (String)"name"), (String)"There should initially not be any value");
        ComponentUtil.setData((Component)this.component, (String)"name", (Object)"value");
        Assertions.assertEquals((Object)"value", (Object)ComponentUtil.getData((Component)this.component, (String)"name"), (String)"The stored value should be returned");
        ComponentUtil.setData((Component)this.component, (String)"name", (Object)"value2");
        Assertions.assertEquals((Object)"value2", (Object)ComponentUtil.getData((Component)this.component, (String)"name"), (String)"The replaced value should be returned");
        ComponentUtil.setData((Component)this.component, (String)"name", null);
        Assertions.assertNull((Object)ComponentUtil.getData((Component)this.component, (String)"name"), (String)"The value should be removed");
        Assertions.assertNull((Object)this.component.attributes, (String)"Storage should be cleared after removing the last attribute");
    }

    @Test
    public void setData_byClass() {
        Integer instance1 = new Integer(1);
        Integer instance2 = new Integer(2);
        Assertions.assertNull((Object)ComponentUtil.getData((Component)this.component, Integer.class), (String)"There should initially not be any value");
        ComponentUtil.setData((Component)this.component, Integer.class, (Object)instance1);
        Assertions.assertSame((Object)instance1, (Object)ComponentUtil.getData((Component)this.component, Integer.class), (String)"The stored value should be returned");
        Assertions.assertNull((Object)ComponentUtil.getData((Component)this.component, Number.class), (String)"Attribute should not be available based on super type");
        ComponentUtil.setData((Component)this.component, Integer.class, (Object)instance2);
        Assertions.assertSame((Object)instance2, (Object)ComponentUtil.getData((Component)this.component, Integer.class), (String)"The replaced value should be returned");
        ComponentUtil.setData((Component)this.component, Integer.class, null);
        Assertions.assertNull((Object)ComponentUtil.getData((Component)this.component, Integer.class), (String)"The value should be removed");
        Assertions.assertNull((Object)this.component.attributes, (String)"Storage should be cleared after removing the last attribute");
    }

    @Test
    public void addListenerToComponent_hasListener_returnsTrue() {
        Assertions.assertFalse((boolean)ComponentUtil.hasEventListener((Component)this.component, PollEvent.class));
        Registration listener = ComponentUtil.addListener((Component)this.component, PollEvent.class, (ComponentEventListener & Serializable)event -> {});
        Assertions.assertTrue((boolean)ComponentUtil.hasEventListener((Component)this.component, PollEvent.class));
        listener.remove();
        Assertions.assertFalse((boolean)ComponentUtil.hasEventListener((Component)this.component, PollEvent.class));
    }

    @Test
    public void addListenerToComponent_getListeners_returnsCollection() {
        Assertions.assertFalse((boolean)ComponentUtil.hasEventListener((Component)this.component, PollEvent.class));
        Registration listener = ComponentUtil.addListener((Component)this.component, PollEvent.class, (ComponentEventListener & Serializable)event -> {});
        Collection listeners = ComponentUtil.getListeners((Component)this.component, PollEvent.class);
        Assertions.assertEquals((int)1, (int)listeners.size());
        listener.remove();
        Assertions.assertTrue((boolean)ComponentUtil.getListeners((Component)this.component, PollEvent.class).isEmpty());
    }

    @Test
    public void registerComponentClass_and_getComponentsByTag_shouldReturnCorrectComponent() {
        Class<ComponentTest.TestDiv> testComponentClass = ComponentTest.TestDiv.class;
        String testTag = "test-div";
        ComponentUtil.registerComponentClass((String)testTag, testComponentClass);
        Set retrievedClasses = ComponentUtil.getComponentsByTag((String)testTag);
        Assertions.assertTrue((boolean)retrievedClasses.contains(testComponentClass), (String)"The retrieved classes should contain the registered component class");
        ComponentUtil.getComponentsByTag((String)testTag).clear();
    }

    @Test
    public void getComponentsByTag_withUnregisteredTag_shouldReturnEmptySet() {
        String unregisteredTag = "unregistered-tag";
        Set retrievedClasses = ComponentUtil.getComponentsByTag((String)unregisteredTag);
        Assertions.assertTrue((boolean)retrievedClasses.isEmpty(), (String)"The retrieved classes should be empty for an unregistered tag");
    }
}

