/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.communication;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.server.HandlerHelper;
import com.vaadin.flow.server.RequestHandler;
import com.vaadin.flow.server.SessionExpiredHandler;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinResponse;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinServletRequest;
import com.vaadin.flow.server.VaadinServletResponse;
import com.vaadin.flow.server.VaadinServletService;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.communication.PushConnection;
import com.vaadin.flow.server.communication.SsePushConnection;
import jakarta.servlet.AsyncContext;
import jakarta.servlet.AsyncEvent;
import jakarta.servlet.AsyncListener;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SseRequestHandler
implements RequestHandler,
SessionExpiredHandler {
    private final VaadinServletService service;

    public SseRequestHandler(VaadinServletService service) {
        this.service = service;
        service.addServiceDestroyListener(event -> this.destroy());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean handleRequest(VaadinSession session, VaadinRequest request, VaadinResponse response) throws IOException {
        if (!HandlerHelper.isRequestType(request, HandlerHelper.RequestType.SSE)) {
            return false;
        }
        if (!(request instanceof VaadinServletRequest) || !(response instanceof VaadinServletResponse)) {
            throw new IllegalArgumentException("Only VaadinServletRequest/Response are supported for SSE");
        }
        HttpServletRequest servletRequest = (HttpServletRequest)((VaadinServletRequest)request).getRequest();
        HttpServletResponse servletResponse = (HttpServletResponse)((VaadinServletResponse)response).getResponse();
        if (!servletRequest.isAsyncSupported()) {
            SseRequestHandler.getLogger().error("Async not supported. SSE push unavailable.");
            servletResponse.sendError(500, "Async not supported. SSE push unavailable.");
            return true;
        }
        if (session == null) {
            SseRequestHandler.getLogger().debug("Session expired, sending session expired event");
            this.sendSessionExpired(servletResponse);
            return true;
        }
        session.lock();
        try {
            UI ui = this.service.findUI(request);
            if (ui == null) {
                SseRequestHandler.getLogger().warn("UI not found for SSE request");
                this.sendError(servletResponse, "UI not found");
                boolean bl = true;
                return bl;
            }
            String requestPushId = request.getParameter("v-pushId");
            if (!SseRequestHandler.isPushIdValid(session, requestPushId)) {
                SseRequestHandler.getLogger().warn("Invalid push ID received from {}", (Object)servletRequest.getRemoteHost());
                this.sendRefresh(servletResponse);
                boolean bl = true;
                return bl;
            }
            PushConnection pushConnection = ui.getInternals().getPushConnection();
            if (!(pushConnection instanceof SsePushConnection)) {
                SseRequestHandler.getLogger().warn("SSE request received but UI does not have SsePushConnection. Connection type: {}", (Object)(pushConnection != null ? pushConnection.getClass().getName() : "null"));
                this.sendError(servletResponse, "SSE not configured for this UI");
                boolean bl = true;
                return bl;
            }
            final SsePushConnection sseConnection = (SsePushConnection)pushConnection;
            AsyncContext asyncContext = servletRequest.startAsync();
            asyncContext.setTimeout(0L);
            asyncContext.addListener(new AsyncListener(){

                public void onComplete(AsyncEvent event) {
                    SseRequestHandler.this.handleDisconnect(sseConnection);
                }

                public void onTimeout(AsyncEvent event) {
                    SseRequestHandler.getLogger().debug("SSE connection timed out");
                    SseRequestHandler.this.handleDisconnect(sseConnection);
                }

                public void onError(AsyncEvent event) {
                    SseRequestHandler.getLogger().debug("SSE connection error", event.getThrowable());
                    SseRequestHandler.this.handleDisconnect(sseConnection);
                }

                public void onStartAsync(AsyncEvent event) {
                }
            });
            sseConnection.connect(asyncContext);
            SseRequestHandler.getLogger().debug("SSE connection established for UI {}", (Object)ui.getUIId());
        }
        finally {
            session.unlock();
        }
        return true;
    }

    private void handleDisconnect(SsePushConnection connection) {
        SseRequestHandler.getLogger().debug("SSE connection disconnected");
        connection.connectionLost();
    }

    private static boolean isPushIdValid(VaadinSession session, String requestPushId) {
        String sessionPushId = session.getPushId();
        return requestPushId != null && MessageDigest.isEqual(requestPushId.getBytes(StandardCharsets.UTF_8), sessionPushId.getBytes(StandardCharsets.UTF_8));
    }

    private void sendSessionExpired(HttpServletResponse response) throws IOException {
        response.setContentType("application/json; charset=UTF-8");
        response.getWriter().write(VaadinService.createSessionExpiredJSON(true));
    }

    private void sendRefresh(HttpServletResponse response) throws IOException {
        response.setContentType("application/json; charset=UTF-8");
        response.getWriter().write(VaadinService.createCriticalNotificationJSON(null, null, null, null));
    }

    private void sendError(HttpServletResponse response, String message) throws IOException {
        response.sendError(400, message);
    }

    @Override
    public boolean handleSessionExpired(VaadinRequest request, VaadinResponse response) throws IOException {
        if (!HandlerHelper.isRequestType(request, HandlerHelper.RequestType.SSE)) {
            return false;
        }
        return this.handleRequest(null, request, response);
    }

    public void destroy() {
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger((String)SseRequestHandler.class.getName());
    }
}

