/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.communication;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.internal.UsageStatistics;
import com.vaadin.flow.server.communication.PushConnection;
import com.vaadin.flow.server.communication.UidlWriter;
import jakarta.servlet.AsyncContext;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tools.jackson.databind.node.ObjectNode;

public class SsePushConnection
implements PushConnection,
Serializable {
    private static final String SSE_VERSION = "1.0";
    private UI ui;
    private transient State state = State.DISCONNECTED;
    private transient AsyncContext asyncContext;
    private transient PrintWriter writer;
    private transient Object lock = new Object();
    private volatile boolean disconnecting;

    public SsePushConnection(UI ui) {
        this.ui = ui;
        UsageStatistics.markAsUsed("flow/SsePushConnection", SSE_VERSION);
    }

    @Override
    public void push() {
        this.push(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void push(boolean async) {
        if (this.disconnecting || !this.isConnected()) {
            if (this.disconnecting) {
                SsePushConnection.getLogger().debug("Disconnection in progress, ignoring push request");
            }
            this.state = async && this.state != State.RESPONSE_PENDING ? State.PUSH_PENDING : State.RESPONSE_PENDING;
        } else {
            Object object = this.lock;
            synchronized (object) {
                try {
                    ObjectNode response = new UidlWriter().createUidl(this.getUI(), async);
                    this.sendMessage("for(;;);[" + String.valueOf(response) + "]");
                }
                catch (Exception e) {
                    throw new RuntimeException("Push failed", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendMessage(String message) {
        assert (this.isConnected()) : "Cannot send message when not connected";
        Object object = this.lock;
        synchronized (object) {
            try {
                String[] lines;
                this.writer.write("event: uidl\n");
                this.writer.write("id: " + (this.ui.getInternals().getServerSyncId() - 1) + "\n");
                for (String line : lines = message.split("\n", -1)) {
                    this.writer.write("data: " + line + "\n");
                }
                this.writer.write("\n");
                this.writer.flush();
                if (this.writer.checkError()) {
                    SsePushConnection.getLogger().debug("Error detected while writing SSE message");
                    this.connectionLost();
                }
            }
            catch (Exception e) {
                SsePushConnection.getLogger().debug("Failed to send SSE message", (Throwable)e);
                this.connectionLost();
            }
        }
    }

    @Override
    public boolean isConnected() {
        assert (this.state != null);
        return this.state == State.CONNECTED;
    }

    public void connect(AsyncContext asyncContext) throws IOException {
        assert (asyncContext != null);
        if (this.isConnected()) {
            this.disconnect();
        }
        this.asyncContext = asyncContext;
        HttpServletResponse response = (HttpServletResponse)asyncContext.getResponse();
        response.setContentType("text/event-stream");
        response.setCharacterEncoding("UTF-8");
        response.setHeader("Cache-Control", "no-cache, no-store, must-revalidate");
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Connection", "keep-alive");
        response.setHeader("X-Accel-Buffering", "no");
        this.writer = response.getWriter();
        State oldState = this.state;
        this.state = State.CONNECTED;
        this.sendConnectionEstablishedEvent();
        if (oldState == State.PUSH_PENDING || oldState == State.RESPONSE_PENDING) {
            this.push(oldState == State.PUSH_PENDING);
        }
    }

    private void sendConnectionEstablishedEvent() {
        try {
            this.writer.write("event: connected\n");
            this.writer.write("data: {\"uiId\":" + this.ui.getUIId() + "}\n\n");
            this.writer.flush();
        }
        catch (Exception e) {
            SsePushConnection.getLogger().debug("Failed to send connection established event", (Throwable)e);
        }
    }

    protected UI getUI() {
        return this.ui;
    }

    protected AsyncContext getAsyncContext() {
        return this.asyncContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect() {
        if (this.disconnecting) {
            SsePushConnection.getLogger().debug("Disconnection already in progress, ignoring request");
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            if (!this.isConnected() || this.asyncContext == null) {
                SsePushConnection.getLogger().debug("Disconnection already happened, ignoring request");
                return;
            }
            try {
                this.disconnecting = true;
                try {
                    this.asyncContext.complete();
                }
                catch (Exception e) {
                    SsePushConnection.getLogger().debug("Error when completing async context", (Throwable)e);
                }
                this.connectionLost();
            }
            finally {
                this.disconnecting = false;
            }
        }
    }

    public void connectionLost() {
        this.asyncContext = null;
        this.writer = null;
        if (this.state == State.CONNECTED) {
            this.state = State.DISCONNECTED;
        }
    }

    protected State getState() {
        return this.state;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.state = State.DISCONNECTED;
        this.disconnecting = false;
        this.lock = new Object();
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger((String)SsePushConnection.class.getName());
    }

    protected static enum State {
        DISCONNECTED,
        PUSH_PENDING,
        RESPONSE_PENDING,
        CONNECTED;

    }
}

