/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.signals.local;

import com.vaadin.flow.function.SerializableBiPredicate;
import com.vaadin.flow.signals.impl.Transaction;
import com.vaadin.flow.signals.local.AbstractLocalSignal;
import com.vaadin.flow.signals.local.ValueSignal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class ListSignal<T>
extends AbstractLocalSignal<List<ValueSignal<T>>> {
    private final SerializableBiPredicate<T, T> equalityChecker;

    public ListSignal() {
        this(Objects::equals);
    }

    public ListSignal(SerializableBiPredicate<T, T> equalityChecker) {
        super(List.of());
        this.equalityChecker = Objects.requireNonNull(equalityChecker, "Equality checker must not be null");
    }

    @Override
    public List<ValueSignal<T>> get() {
        return Objects.requireNonNull((List)super.get());
    }

    @Override
    public List<ValueSignal<T>> peek() {
        return Objects.requireNonNull((List)super.peek());
    }

    @Override
    protected void checkPreconditions() {
        this.assertLockHeld();
        super.checkPreconditions();
        if (Transaction.inExplicitTransaction()) {
            throw new IllegalStateException("ListSignal cannot be used inside signal transactions because it can hold a reference to a mutable object that can be mutated directly, bypassing transaction control. Use SharedListSignal instead.");
        }
    }

    public ValueSignal<T> insertFirst(T value) {
        this.lock();
        try {
            this.checkPreconditions();
            ValueSignal<T> valueSignal = this.insertAtInternal(0, value);
            return valueSignal;
        }
        finally {
            this.unlock();
        }
    }

    public ValueSignal<T> insertLast(T value) {
        this.lock();
        try {
            this.checkPreconditions();
            ValueSignal<T> valueSignal = this.insertAtInternal(Objects.requireNonNull((List)this.getSignalValue()).size(), value);
            return valueSignal;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ValueSignal<T> insertAt(int index, T value) {
        this.lock();
        try {
            this.checkPreconditions();
            List entries = Objects.requireNonNull((List)this.getSignalValue());
            if (index < 0 || index > entries.size()) {
                throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + entries.size());
            }
            ValueSignal<T> valueSignal = this.insertAtInternal(index, value);
            return valueSignal;
        }
        finally {
            this.unlock();
        }
    }

    private ValueSignal<T> insertAtInternal(int index, T value) {
        this.assertLockHeld();
        ValueSignal<T> entry = new ValueSignal<T>(value, this.equalityChecker);
        ArrayList<ValueSignal<T>> newEntries = new ArrayList<ValueSignal<T>>(Objects.requireNonNull((List)this.getSignalValue()));
        newEntries.add(index, entry);
        this.setSignalValue(Collections.unmodifiableList(newEntries));
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(ValueSignal<T> entry) {
        this.lock();
        try {
            this.checkPreconditions();
            List entries = Objects.requireNonNull((List)this.getSignalValue());
            List<ValueSignal> newEntries = entries.stream().filter(e -> e != entry).toList();
            if (newEntries.size() < entries.size()) {
                this.setSignalValue(newEntries);
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveTo(ValueSignal<T> entry, int toIndex) {
        this.lock();
        try {
            this.checkPreconditions();
            List entries = Objects.requireNonNull((List)this.getSignalValue());
            int fromIndex = entries.indexOf(entry);
            if (fromIndex == -1) {
                throw new IllegalArgumentException("Entry is not in the list");
            }
            if (toIndex < 0 || toIndex >= entries.size()) {
                throw new IndexOutOfBoundsException("Index: " + toIndex + ", Size: " + entries.size());
            }
            if (fromIndex == toIndex) {
                return;
            }
            ArrayList<ValueSignal<T>> newEntries = new ArrayList<ValueSignal<T>>(entries);
            newEntries.remove(fromIndex);
            newEntries.add(toIndex, entry);
            this.setSignalValue(Collections.unmodifiableList(newEntries));
        }
        finally {
            this.unlock();
        }
    }

    public void clear() {
        this.lock();
        try {
            this.checkPreconditions();
            if (!Objects.requireNonNull((List)this.getSignalValue()).isEmpty()) {
                this.setSignalValue(List.of());
            }
        }
        finally {
            this.unlock();
        }
    }

    public String toString() {
        return this.peek().stream().map(AbstractLocalSignal::peek).map(Objects::toString).collect(Collectors.joining(", ", "ListSignal[", "]"));
    }
}

