/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.signals;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.dom.ElementEffect;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.shared.Registration;
import com.vaadin.flow.signals.EffectContext;
import com.vaadin.flow.signals.function.EffectAction;
import com.vaadin.flow.signals.function.SignalComputation;
import com.vaadin.flow.signals.function.SignalMapper;
import com.vaadin.flow.signals.function.TransactionTask;
import com.vaadin.flow.signals.function.ValueSupplier;
import com.vaadin.flow.signals.impl.ComputedSignal;
import com.vaadin.flow.signals.impl.Effect;
import com.vaadin.flow.signals.impl.Transaction;
import com.vaadin.flow.signals.impl.UsageTracker;
import com.vaadin.flow.signals.operations.TransactionOperation;
import java.io.Serializable;
import java.util.Objects;

@FunctionalInterface
public interface Signal<T>
extends Serializable {
    public T get();

    default public T peek() {
        return (T)Signal.untracked(() -> this.get());
    }

    default public <C> Signal<C> map(SignalMapper<T, C> mapper) {
        return () -> mapper.map(this.get());
    }

    public static <C extends Component> Registration effect(C owner, EffectAction effectFunction) {
        return ElementEffect.effect(owner.getElement(), effectFunction);
    }

    public static <C extends Component> Registration effect(C owner, SerializableConsumer<EffectContext> effectFunction) {
        return ElementEffect.effect(owner.getElement(), effectFunction);
    }

    public static Registration unboundEffect(EffectAction action) {
        Effect effect = new Effect(Objects.requireNonNull(action));
        return effect::dispose;
    }

    public static <T> Signal<T> computed(SignalComputation<T> computation) {
        return new ComputedSignal<T>(computation);
    }

    public static Signal<Boolean> not(Signal<Boolean> signal) {
        return Objects.requireNonNull(signal).map(value -> value == false);
    }

    public static <T> TransactionOperation<T> runInTransaction(ValueSupplier<T> transactionTask) {
        return Transaction.runInTransaction(transactionTask);
    }

    public static TransactionOperation<Void> runInTransaction(TransactionTask transactionTask) {
        return Transaction.runInTransaction(transactionTask);
    }

    public static <T> T runWithoutTransaction(ValueSupplier<T> task) {
        return Transaction.runWithoutTransaction(task);
    }

    public static void runWithoutTransaction(TransactionTask task) {
        Transaction.runWithoutTransaction(task);
    }

    public static <T> T untracked(ValueSupplier<T> task) {
        return UsageTracker.untracked(task);
    }
}

