/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal.nodefeature;

import com.vaadin.flow.function.SerializableBiPredicate;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.internal.nodefeature.ServerSideFeature;
import com.vaadin.flow.shared.Registration;
import com.vaadin.flow.signals.Signal;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class SignalBindingFeature
extends ServerSideFeature {
    public static final String CLASSES = "classes/";
    public static final String ENABLED = "enabled";
    public static final String VALUE = "value";
    public static final String THEMES = "themes/";
    public static final String HTML_CONTENT = "htmlContent";
    public static final String CHILDREN = "children";
    private Map<String, SignalBinding> values;

    public SignalBindingFeature(StateNode node) {
        super(node);
    }

    public void setBinding(String key, Registration registration, Signal<?> signal) {
        this.setBinding(key, registration, signal, null);
    }

    public void setBinding(String key, Registration registration, Signal<?> signal, SerializableConsumer<?> writeCallback) {
        this.ensureValues();
        this.values.put(key, new SignalBinding(signal, registration, writeCallback));
    }

    public boolean hasBinding(String key) {
        if (this.values == null) {
            return false;
        }
        SignalBinding binding = this.values.get(key);
        return binding != null && binding.signal != null;
    }

    public void clearBindings(String keyPrefix) {
        if (this.values == null) {
            return;
        }
        this.values.entrySet().removeIf(entry -> {
            String key = (String)entry.getKey();
            if (key.startsWith(keyPrefix)) {
                SignalBinding binding = (SignalBinding)entry.getValue();
                if (binding != null && binding.registration != null) {
                    binding.registration.remove();
                }
                return true;
            }
            return false;
        });
    }

    public void removeBinding(String key) {
        if (this.values == null) {
            return;
        }
        SignalBinding binding = this.values.get(key);
        if (binding != null && binding.registration != null) {
            binding.registration.remove();
        }
        this.values.remove(key);
    }

    public <T> SerializableConsumer<T> getWriteCallback(String key) {
        if (this.values == null) {
            return null;
        }
        SignalBinding binding = this.values.get(key);
        return binding != null ? binding.writeCallback : null;
    }

    public <T> Signal<T> getSignal(String key) {
        if (this.values == null) {
            return null;
        }
        SignalBinding binding = this.values.get(key);
        return binding != null ? this.values.get((Object)key).signal : null;
    }

    public <T> boolean updateSignalByWriteCallback(String key, T oldValue, T newValue, SerializableBiPredicate<T, T> valueEquals, SerializableConsumer<T> revertCallback) {
        SerializableConsumer<T> callback = this.getWriteCallback(key);
        Signal<T> signal = this.getSignal(key);
        if (callback != null) {
            callback.accept(newValue);
            T signalValue = signal.peek();
            if (!valueEquals.test(signalValue, newValue)) {
                revertCallback.accept(signalValue);
                return false;
            }
        } else {
            revertCallback.accept(oldValue);
            throw new IllegalStateException("Cannot set value on a read-only signal binding. Provide a write callback to enable two-way binding.");
        }
        return true;
    }

    private void ensureValues() {
        if (this.values == null) {
            this.values = new HashMap<String, SignalBinding>();
        }
    }

    private record SignalBinding(Signal<?> signal, Registration registration, SerializableConsumer<?> writeCallback) implements Serializable
    {
    }
}

