/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal.nodefeature;

import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.ElementEffect;
import com.vaadin.flow.function.SerializableBiConsumer;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.internal.change.EmptyChange;
import com.vaadin.flow.internal.change.MapPutChange;
import com.vaadin.flow.internal.change.MapRemoveChange;
import com.vaadin.flow.internal.change.NodeChange;
import com.vaadin.flow.internal.nodefeature.NodeFeature;
import com.vaadin.flow.shared.Registration;
import com.vaadin.flow.shared.util.UniqueSerializable;
import com.vaadin.flow.signals.BindingActiveException;
import com.vaadin.flow.signals.Signal;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Stream;

public abstract class NodeMap
extends NodeFeature {
    private static final Serializable REMOVED_MARKER = new UniqueSerializable(){};
    private Values values;
    private boolean isPopulated;

    public NodeMap(StateNode node) {
        super(node);
        this.isPopulated = !node.isReportedFeature(this.getClass());
    }

    protected void put(String key, Serializable value) {
        this.put(key, value, true);
    }

    protected Serializable put(String key, Serializable value, boolean emitChange) {
        Serializable oldValue = this.get(key);
        if (!this.producePutChange(key, this.contains(key), value)) {
            return oldValue;
        }
        if (emitChange) {
            this.setChanged(key);
        } else {
            this.setUnChanged(key);
        }
        if (this.values == null) {
            this.values = new SingleValue(key, value);
        } else {
            if (this.values instanceof SingleValue && !this.values.containsKey(key)) {
                this.values = new HashMapValues(this.values);
            }
            this.values.set(key, value);
        }
        this.detatchPotentialChild(oldValue);
        this.attachPotentialChild(value);
        return oldValue;
    }

    protected Serializable get(String key) {
        return this.doGet(key);
    }

    private Serializable doGet(String key) {
        this.setAccessed(key);
        if (this.values == null) {
            return null;
        }
        return this.values.get(key);
    }

    protected String getOrDefault(String key, String defaultValue) {
        if (this.contains(key)) {
            Serializable value = this.get(key);
            if (value == null) {
                return defaultValue;
            }
            return (String)((Object)value);
        }
        return defaultValue;
    }

    protected int getOrDefault(String key, int defaultValue) {
        if (this.contains(key)) {
            Serializable value = this.get(key);
            if (value == null) {
                return defaultValue;
            }
            return (Integer)value;
        }
        return defaultValue;
    }

    protected boolean getOrDefault(String key, boolean defaultValue) {
        if (this.contains(key)) {
            Serializable value = this.get(key);
            if (value == null) {
                return defaultValue;
            }
            return (Boolean)value;
        }
        return defaultValue;
    }

    protected Set<String> keySet() {
        if (this.values == null) {
            return Collections.emptySet();
        }
        return this.values.keySet();
    }

    protected boolean contains(String key) {
        this.setAccessed(key);
        if (this.values == null) {
            return false;
        }
        return this.values.containsKey(key);
    }

    protected Serializable remove(String key) {
        Serializable oldValue;
        this.setChanged(key);
        if (this.values == null) {
            return null;
        }
        if (this.values instanceof SingleValue) {
            oldValue = this.values.get(key);
            if (this.values.containsKey(key)) {
                this.values = null;
            }
        } else {
            assert (this.values instanceof HashMapValues);
            HashMapValues hashMapValues = (HashMapValues)this.values;
            oldValue = (Serializable)hashMapValues.remove(key);
            if (hashMapValues.isEmpty()) {
                this.values = null;
            }
        }
        this.detatchPotentialChild(oldValue);
        return oldValue;
    }

    protected void clear() {
        for (String key : new ArrayList<String>(this.keySet())) {
            this.remove(key);
        }
    }

    private void setUnChanged(String key) {
        assert (key != null);
        this.getChangeTracker().remove(key);
    }

    private void setChanged(String key) {
        assert (key != null);
        this.getNode().markAsDirty();
        Map<String, Serializable> changes = this.getChangeTracker();
        if (!changes.containsKey(key)) {
            if (this.values != null && this.values.containsKey(key)) {
                Serializable oldValue = this.values.get(key);
                changes.put(key, oldValue);
            } else {
                changes.put(key, REMOVED_MARKER);
            }
        }
    }

    private Map<String, Serializable> getChangeTracker() {
        return this.getNode().getChangeTracker(this, HashMap::new);
    }

    private void setAccessed(String key) {
        assert (key != null);
    }

    @Override
    public void collectChanges(Consumer<NodeChange> collector) {
        boolean hasChanges = false;
        for (Map.Entry<String, Serializable> entry : this.getChangeTracker().entrySet()) {
            boolean containedEarlier;
            String key = entry.getKey();
            Serializable value = entry.getValue();
            boolean containsNow = this.values != null && this.values.containsKey(key);
            boolean bl = containedEarlier = value != REMOVED_MARKER;
            if (containedEarlier && !containsNow) {
                collector.accept(new MapRemoveChange(this, key));
                hasChanges = true;
                continue;
            }
            if (!containsNow || !this.producePutChange(key, containedEarlier, value)) continue;
            Serializable currentValue = this.values.get(key);
            if (currentValue instanceof SignalBinding) {
                SignalBinding binding = (SignalBinding)currentValue;
                currentValue = binding.value();
            }
            collector.accept(new MapPutChange(this, key, currentValue));
            hasChanges = true;
        }
        if (!this.isPopulated) {
            if (!hasChanges) {
                collector.accept(new EmptyChange(this));
            }
            this.isPopulated = true;
        }
    }

    @Override
    public void generateChangesFromEmpty() {
        if (this.values == null) {
            if (!this.isPopulated) {
                this.getChangeTracker();
            }
            return;
        }
        assert (!this.values.isEmpty());
        Map<String, Serializable> changes = this.getChangeTracker();
        this.values.keySet().forEach(k -> changes.put((String)k, REMOVED_MARKER));
    }

    @Override
    public void forEachChild(Consumer<StateNode> action) {
        if (this.values == null) {
            return;
        }
        assert (!this.values.isEmpty());
        this.values.streamValues().filter(v -> v instanceof StateNode).forEach(v -> action.accept((StateNode)v));
    }

    public void updateFromClient(String key, Serializable value) {
        if (!this.mayUpdateFromClient(key, value)) {
            throw new IllegalArgumentException(String.format("Feature '%s' doesn't allow the client to update '%s'", this.getClass().getName(), key));
        }
        this.put(key, value, false);
    }

    protected boolean mayUpdateFromClient(String key, Serializable value) {
        return false;
    }

    protected boolean producePutChange(String key, boolean hadValueEarlier, Serializable newValue) {
        return !hadValueEarlier || !Objects.equals(newValue, this.values.get(key));
    }

    boolean usesSingleMap() {
        return this.values instanceof SingleValue;
    }

    protected <T> com.vaadin.flow.dom.SignalBinding<T> bindSignal(Element owner, String key, Signal<T> signal, SerializableBiConsumer<Element, T> setter, SerializableConsumer<?> writeCallback) {
        SignalBinding binding;
        Objects.requireNonNull(signal, "Signal cannot be null");
        Serializable serializable = this.doGet(key);
        SignalBinding previousSignalBinding = serializable instanceof SignalBinding ? (binding = (SignalBinding)serializable) : null;
        if (previousSignalBinding != null && previousSignalBinding.signal() != null) {
            throw new BindingActiveException();
        }
        com.vaadin.flow.dom.SignalBinding<T> domBinding = ElementEffect.bind(owner, signal, setter);
        this.put(key, new SignalBinding(signal, domBinding.getEffectRegistration(), this.get(key), writeCallback), false);
        return domBinding;
    }

    public boolean hasSignal(String key) {
        SignalBinding binding;
        Serializable serializable = this.doGet(key);
        return serializable instanceof SignalBinding && (binding = (SignalBinding)serializable).signal() != null;
    }

    private static interface Values
    extends Serializable {
        public int size();

        public Serializable get(String var1);

        public Set<String> keySet();

        public boolean containsKey(String var1);

        default public boolean isEmpty() {
            return this.size() == 0;
        }

        public Stream<Serializable> streamValues();

        public void set(String var1, Serializable var2);
    }

    private static class SingleValue
    implements Values {
        private final String key;
        private Serializable value;

        public SingleValue(String key, Serializable value) {
            assert (key != null);
            this.key = key;
            this.value = value;
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public Serializable get(String key) {
            if (this.containsKey(key)) {
                return this.value;
            }
            return null;
        }

        @Override
        public Set<String> keySet() {
            return Collections.singleton(this.key);
        }

        @Override
        public boolean containsKey(String key) {
            return this.key.equals(key);
        }

        @Override
        public Stream<Serializable> streamValues() {
            return Stream.of(this.value);
        }

        @Override
        public void set(String key, Serializable value) {
            assert (key.equals(this.key));
            this.value = value;
        }
    }

    private static class HashMapValues
    extends HashMap<String, Serializable>
    implements Values {
        public HashMapValues(Values previousValues) {
            super(previousValues == null ? 0 : previousValues.size());
            if (previousValues != null) {
                previousValues.keySet().forEach((? super T key) -> super.put(key, previousValues.get((String)key)));
            }
        }

        @Override
        public Serializable get(String key) {
            return (Serializable)super.get(key);
        }

        @Override
        public void set(String key, Serializable value) {
            super.put(key, value);
        }

        @Override
        public boolean containsKey(String key) {
            return super.containsKey(key);
        }

        @Override
        public Stream<Serializable> streamValues() {
            return super.values().stream();
        }
    }

    public record SignalBinding(Signal<?> signal, Registration registration, Serializable value, SerializableConsumer<?> writeCallback) implements Serializable
    {
    }
}

