/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal.nodefeature;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.SignalBinding;
import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.internal.nodefeature.NodeMap;
import com.vaadin.flow.signals.Signal;
import java.io.Serializable;
import tools.jackson.databind.node.BaseJsonNode;

public class ElementData
extends NodeMap {
    public ElementData(StateNode node) {
        super(node);
    }

    @Override
    protected Serializable get(String key) {
        Serializable value = super.get(key);
        if (value instanceof NodeMap.SignalBinding) {
            return ((NodeMap.SignalBinding)value).value();
        }
        return value;
    }

    public void setTag(String tag) {
        this.put("tag", (Serializable)((Object)tag));
    }

    public String getTag() {
        return this.getOrDefault("tag", null);
    }

    public void setNamespace(String namespace) {
        this.put("namespace", (Serializable)((Object)namespace));
    }

    public String getNamespace() {
        return this.getOrDefault("namespace", null);
    }

    public void setPayload(BaseJsonNode payload) {
        this.put("payload", (Serializable)payload);
    }

    public void setVisible(boolean visible) {
        this.put("visible", Boolean.valueOf(visible));
    }

    public boolean isVisible() {
        Serializable serializable;
        Serializable value = this.get("visible");
        if (value instanceof NodeMap.SignalBinding) {
            NodeMap.SignalBinding signalBinding = (NodeMap.SignalBinding)value;
            serializable = signalBinding.value();
        } else {
            serializable = value;
        }
        return !Boolean.FALSE.equals(serializable);
    }

    public BaseJsonNode getPayload() {
        Serializable value = this.get("payload");
        return value == null ? null : (BaseJsonNode)value;
    }

    @Override
    public boolean allowsChanges() {
        return this.isVisible();
    }

    public void setJavaClass(Class<? extends Component> componentClass) {
        this.put("jc", (Serializable)((Object)componentClass.getName()));
    }

    public String getJavaClass() {
        return this.getOrDefault("jc", null);
    }

    public SignalBinding<Boolean> bindVisibleSignal(Element owner, Signal<Boolean> signal) {
        return this.bindSignal(owner, "visible", signal, (element, value) -> this.putVisibleSignalValue((Boolean)value), null);
    }

    private void putVisibleSignalValue(Boolean value) {
        boolean booleanValue = value != null ? value : Boolean.FALSE;
        if (this.hasSignal("visible")) {
            NodeMap.SignalBinding b = (NodeMap.SignalBinding)super.get("visible");
            this.put("visible", new NodeMap.SignalBinding(b.signal(), b.registration(), Boolean.valueOf(booleanValue), null));
        } else {
            this.put("visible", Boolean.valueOf(booleanValue));
        }
    }
}

