/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.dom;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.ScrollIntoViewOption;
import com.vaadin.flow.component.ScrollOptions;
import com.vaadin.flow.component.internal.PendingJavaScriptInvocation;
import com.vaadin.flow.component.internal.UIInternals;
import com.vaadin.flow.component.page.PendingJavaScriptResult;
import com.vaadin.flow.dom.ClassList;
import com.vaadin.flow.dom.DomEventListener;
import com.vaadin.flow.dom.DomListenerRegistration;
import com.vaadin.flow.dom.ElementAttachEvent;
import com.vaadin.flow.dom.ElementAttachListener;
import com.vaadin.flow.dom.ElementDetachEvent;
import com.vaadin.flow.dom.ElementDetachListener;
import com.vaadin.flow.dom.ElementEffect;
import com.vaadin.flow.dom.ElementStateProvider;
import com.vaadin.flow.dom.ElementUtil;
import com.vaadin.flow.dom.Node;
import com.vaadin.flow.dom.PropertyChangeListener;
import com.vaadin.flow.dom.ShadowRoot;
import com.vaadin.flow.dom.SignalBinding;
import com.vaadin.flow.dom.Style;
import com.vaadin.flow.dom.ThemeList;
import com.vaadin.flow.dom.impl.BasicElementStateProvider;
import com.vaadin.flow.dom.impl.BasicTextElementStateProvider;
import com.vaadin.flow.dom.impl.CustomAttribute;
import com.vaadin.flow.dom.impl.ThemeListImpl;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.internal.JacksonCodec;
import com.vaadin.flow.internal.JacksonUtils;
import com.vaadin.flow.internal.JavaScriptSemantics;
import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.internal.nodefeature.NodeFeature;
import com.vaadin.flow.internal.nodefeature.SignalBindingFeature;
import com.vaadin.flow.internal.nodefeature.TextBindingFeature;
import com.vaadin.flow.internal.nodefeature.VirtualChildrenList;
import com.vaadin.flow.server.AbstractStreamResource;
import com.vaadin.flow.server.Command;
import com.vaadin.flow.server.StreamResourceRegistry;
import com.vaadin.flow.server.streams.ElementRequestHandler;
import com.vaadin.flow.shared.Registration;
import com.vaadin.flow.signals.BindingActiveException;
import com.vaadin.flow.signals.Signal;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.jsoup.nodes.Document;
import tools.jackson.core.type.TypeReference;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.BaseJsonNode;
import tools.jackson.databind.node.BooleanNode;
import tools.jackson.databind.node.NullNode;
import tools.jackson.databind.node.ObjectNode;

public class Element
extends Node<Element> {
    private static final String EVENT_TYPE_MUST_NOT_BE_NULL = "Event type must not be null";
    static final String ATTRIBUTE_NAME_CANNOT_BE_NULL = "The attribute name cannot be null";
    private static final String USE_SET_PROPERTY_WITH_JSON_NULL = "setProperty(name, Json.createNull()) must be used to set a property to null";
    private static final String USE_SET_PROPERTY_WITH_JACKSON_NULL = "setProperty(name, JacksonUtils.nullNode()) must be used to set a property to null";
    private static final Map<String, String> illegalPropertyReplacements = new HashMap<String, String>();
    private static final DomEventListener NO_OP_DOM_LISTENER;

    protected Element(StateNode node, ElementStateProvider stateProvider) {
        super(node, stateProvider);
    }

    public Element(String tag) {
        super(Element.createStateNode(tag), BasicElementStateProvider.get());
        assert (this.getNode() != null);
        assert (this.getStateProvider() != null);
    }

    public static Element get(StateNode node) {
        assert (node != null);
        return ElementUtil.from(node).orElseThrow(() -> new IllegalArgumentException("Node is not valid as an element"));
    }

    public static Element get(StateNode node, ElementStateProvider stateProvider) {
        return new Element(node, stateProvider);
    }

    @Override
    public int getChildCount() {
        return super.getChildCount();
    }

    @Override
    public Element getChild(int index) {
        return super.getChild(index);
    }

    @Override
    public Stream<Element> getChildren() {
        return super.getChildren();
    }

    public static Element createText(String text) {
        if (text == null) {
            text = "";
        }
        return new Element(BasicTextElementStateProvider.createStateNode(text), BasicTextElementStateProvider.get());
    }

    private static StateNode createStateNode(String tag) {
        if (!ElementUtil.isValidTagName(tag)) {
            throw new IllegalArgumentException("Tag " + tag + " is not a valid tag name");
        }
        return BasicElementStateProvider.createStateNode(tag);
    }

    public String getTag() {
        return this.getStateProvider().getTag(this.getNode());
    }

    public SignalBinding<String> bindAttribute(String attribute, Signal<String> signal) {
        String validAttribute = this.validateAttribute(attribute);
        Optional<CustomAttribute> customAttribute = CustomAttribute.get(validAttribute);
        if (customAttribute.isPresent()) {
            throw new UnsupportedOperationException("Binding style or class attribute to a Signal is not supported.");
        }
        return this.getStateProvider().bindAttributeSignal(this, validAttribute, signal);
    }

    public Element setAttribute(String attribute, String value) {
        if (value == null) {
            throw new IllegalArgumentException("Value cannot be null");
        }
        String lowerCaseAttribute = this.validateAttribute(attribute);
        Optional<CustomAttribute> customAttribute = CustomAttribute.get(lowerCaseAttribute);
        if (customAttribute.isPresent()) {
            customAttribute.get().setAttribute(this, value);
        } else {
            this.getStateProvider().setAttribute(this.getNode(), lowerCaseAttribute, value);
        }
        return this;
    }

    public Element setAttribute(String attribute, boolean value) {
        if (value) {
            return this.setAttribute(attribute, "");
        }
        return this.removeAttribute(attribute);
    }

    public Element setAttribute(String attribute, AbstractStreamResource resource) {
        String lowerCaseAttribute = this.validateAttribute(attribute);
        if (resource == null) {
            throw new IllegalArgumentException("Value cannot be null");
        }
        Optional<CustomAttribute> customAttribute = CustomAttribute.get(lowerCaseAttribute);
        if (customAttribute.isPresent()) {
            throw new IllegalArgumentException("Can't set " + attribute + " to StreamResource value. This attribute has special semantic");
        }
        this.getStateProvider().setAttribute(this.getNode(), attribute, resource);
        return this;
    }

    public Element setAttribute(String attribute, ElementRequestHandler requestHandler) {
        StreamResourceRegistry.ElementStreamResource resource = new StreamResourceRegistry.ElementStreamResource(requestHandler, this);
        return this.setAttribute(attribute, resource);
    }

    public String getAttribute(String attribute) {
        if (attribute == null) {
            throw new IllegalArgumentException(ATTRIBUTE_NAME_CANNOT_BE_NULL);
        }
        String lowerCaseAttribute = attribute.toLowerCase(Locale.ENGLISH);
        return CustomAttribute.get(lowerCaseAttribute).map(attr -> attr.getAttribute(this)).orElseGet(() -> this.getStateProvider().getAttribute(this.getNode(), lowerCaseAttribute));
    }

    public boolean hasAttribute(String attribute) {
        if (attribute == null) {
            throw new IllegalArgumentException(ATTRIBUTE_NAME_CANNOT_BE_NULL);
        }
        String lowerCaseAttribute = attribute.toLowerCase(Locale.ENGLISH);
        Optional<CustomAttribute> customAttribute = CustomAttribute.get(lowerCaseAttribute);
        if (customAttribute.isPresent()) {
            return customAttribute.get().hasAttribute(this);
        }
        return this.getStateProvider().hasAttribute(this.getNode(), lowerCaseAttribute);
    }

    public Stream<String> getAttributeNames() {
        assert (this.getStateProvider().getAttributeNames(this.getNode()).map(CustomAttribute::get).filter(Optional::isPresent).filter(attr -> ((CustomAttribute)attr.get()).hasAttribute(this)).count() == 0L) : "Overlap between stored attributes and existing custom attributes";
        Stream<String> regularNames = this.getStateProvider().getAttributeNames(this.getNode());
        Stream<String> customNames = CustomAttribute.getNames().stream().filter(name -> CustomAttribute.get(name).get().hasAttribute(this));
        return Stream.concat(regularNames, customNames);
    }

    public Element removeAttribute(String attribute) {
        if (attribute == null) {
            throw new IllegalArgumentException(ATTRIBUTE_NAME_CANNOT_BE_NULL);
        }
        String lowerCaseAttribute = attribute.toLowerCase(Locale.ENGLISH);
        if (this.hasAttribute(lowerCaseAttribute)) {
            Optional<CustomAttribute> customAttribute = CustomAttribute.get(lowerCaseAttribute);
            if (customAttribute.isPresent()) {
                customAttribute.get().removeAttribute(this);
            } else {
                this.getStateProvider().removeAttribute(this.getNode(), lowerCaseAttribute);
            }
        }
        return this;
    }

    public DomListenerRegistration addEventListener(String eventType, DomEventListener listener) {
        if (eventType == null) {
            throw new IllegalArgumentException(EVENT_TYPE_MUST_NOT_BE_NULL);
        }
        if (listener == null) {
            throw new IllegalArgumentException("Listener must not be null");
        }
        return this.getStateProvider().addEventListener(this.getNode(), eventType, listener);
    }

    public Element removeFromParent() {
        Node parent = this.getParentNode();
        if (parent != null) {
            parent.removeChild(this);
        }
        return this;
    }

    public Element removeFromTree() {
        return this.removeFromTree(true);
    }

    public Element removeFromTree(boolean sendDetach) {
        Node parent = this.getParentNode();
        if (parent != null) {
            if (parent.getChildren().anyMatch(Predicate.isEqual(this))) {
                parent.removeChild(this);
            }
            if (this.isVirtualChild()) {
                parent.removeVirtualChild(this);
            }
        }
        this.getNode().removeFromTree(sendDetach);
        return this;
    }

    public Element getParent() {
        Node parent = this.getParentNode();
        if (parent instanceof Element) {
            return (Element)parent;
        }
        return null;
    }

    public Element setProperty(String name, String value) {
        return this.setRawProperty(name, (Serializable)((Object)value));
    }

    public Element setProperty(String name, boolean value) {
        return this.setRawProperty(name, Boolean.valueOf(value));
    }

    public Element setProperty(String name, double value) {
        return this.setRawProperty(name, Double.valueOf(value));
    }

    public Element setPropertyJson(String name, BaseJsonNode value) {
        if (value == null) {
            throw new IllegalArgumentException(USE_SET_PROPERTY_WITH_JACKSON_NULL);
        }
        this.setRawProperty(name, (Serializable)value);
        return this;
    }

    public Element setPropertyBean(String name, Object value) {
        if (value == null) {
            throw new IllegalArgumentException(USE_SET_PROPERTY_WITH_JSON_NULL);
        }
        return this.setPropertyJson(name, (BaseJsonNode)JacksonUtils.beanToJson(value));
    }

    public <T> Element setPropertyList(String name, List<T> value) {
        if (value == null) {
            throw new IllegalArgumentException(USE_SET_PROPERTY_WITH_JSON_NULL);
        }
        return this.setPropertyJson(name, (BaseJsonNode)JacksonUtils.listToJson(value));
    }

    public Element setPropertyMap(String name, Map<String, ?> value) {
        if (value == null) {
            throw new IllegalArgumentException(USE_SET_PROPERTY_WITH_JSON_NULL);
        }
        return this.setPropertyJson(name, (BaseJsonNode)JacksonUtils.mapToJson(value));
    }

    public <T> SignalBinding<T> bindProperty(String name, Signal<T> signal, SerializableConsumer<T> writeCallback) {
        Element.verifySetPropertyName(name);
        return this.getStateProvider().bindPropertySignal(this, name, signal, writeCallback);
    }

    public Registration addPropertyChangeListener(String name, PropertyChangeListener listener) {
        Element.verifySetPropertyName(name);
        return this.getStateProvider().addPropertyChangeListener(this.getNode(), name, listener);
    }

    public DomListenerRegistration addPropertyChangeListener(String propertyName, String domEventName, PropertyChangeListener listener) {
        Registration propertyListenerRegistration = this.addPropertyChangeListener(propertyName, listener);
        return this.addEventListener(domEventName, NO_OP_DOM_LISTENER).synchronizeProperty(propertyName).onUnregister(propertyListenerRegistration::remove);
    }

    private Element setRawProperty(String name, Serializable value) {
        Element.verifySetPropertyName(name);
        if ("innerHTML".equals(name)) {
            this.removeAllChildren();
        }
        this.getStateProvider().setProperty(this.getNode(), name, value, true);
        return this;
    }

    private static void verifySetPropertyName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("A property name cannot be null");
        }
        String replacement = illegalPropertyReplacements.get(name);
        if (replacement != null) {
            throw new IllegalArgumentException("Can't set or synchronize " + name + " as a property, use " + replacement + " instead.");
        }
    }

    public String getProperty(String name, String defaultValue) {
        Serializable value = this.getPropertyRaw(name);
        if (value == null || value instanceof NullNode) {
            return defaultValue;
        }
        if (value instanceof Number) {
            int intValue;
            double doubleValue = ((Number)value).doubleValue();
            if (Double.doubleToRawLongBits(doubleValue - (double)(intValue = (int)doubleValue)) == 0L) {
                return Integer.toString(intValue);
            }
            return Double.toString(doubleValue);
        }
        return value.toString();
    }

    public String getProperty(String name) {
        return this.getProperty(name, null);
    }

    public boolean getProperty(String name, boolean defaultValue) {
        Serializable value = this.getPropertyRaw(name);
        if (value == null) {
            return defaultValue;
        }
        return JavaScriptSemantics.isTrueish(value);
    }

    public double getProperty(String name, double defaultValue) {
        Serializable value = this.getPropertyRaw(name);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            return number.doubleValue();
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? 1.0 : 0.0;
        }
        if (value instanceof String) {
            String string = (String)((Object)value);
            if (string.isEmpty()) {
                return 0.0;
            }
            try {
                return Double.parseDouble(string);
            }
            catch (NumberFormatException ignore) {
                return Double.NaN;
            }
        }
        if (value instanceof BooleanNode) {
            return ((BooleanNode)value).booleanValue() ? 1.0 : 0.0;
        }
        if (value instanceof JsonNode) {
            return ((JsonNode)value).asDouble(Double.NaN);
        }
        throw new IllegalStateException("Unsupported property type: " + String.valueOf(value.getClass()));
    }

    public int getProperty(String name, int defaultValue) {
        return (int)this.getProperty(name, (double)defaultValue);
    }

    public Serializable getPropertyRaw(String name) {
        return this.getStateProvider().getProperty(this.getNode(), name);
    }

    public <T> T getPropertyBean(String name, Class<T> type) {
        Serializable raw = this.getPropertyRaw(name);
        if (raw == null || raw instanceof NullNode) {
            return null;
        }
        return JacksonCodec.decodeAs((JsonNode)raw, type);
    }

    public <T> T getPropertyBean(String name, TypeReference<T> typeReference) {
        Serializable raw = this.getPropertyRaw(name);
        if (raw == null || raw instanceof NullNode) {
            return null;
        }
        return JacksonCodec.decodeAs((JsonNode)raw, typeReference);
    }

    public Element removeProperty(String name) {
        this.getStateProvider().removeProperty(this.getNode(), name);
        return this;
    }

    public boolean hasProperty(String name) {
        return this.getStateProvider().hasProperty(this.getNode(), name);
    }

    public Stream<String> getPropertyNames() {
        return this.getStateProvider().getPropertyNames(this.getNode());
    }

    public boolean isTextNode() {
        return this.getStateProvider().isTextNode(this.getNode());
    }

    public Element setText(String textContent) {
        this.getFeatureIfInitialized(TextBindingFeature.class).ifPresent(feature -> {
            if (feature.hasBinding()) {
                throw new BindingActiveException("setText is not allowed while a binding for text exists.");
            }
        });
        this.setTextContent(textContent);
        return this;
    }

    private void setTextContent(String textContent) {
        if (textContent == null) {
            textContent = "";
        }
        if (this.isTextNode()) {
            this.getStateProvider().setTextContent(this.getNode(), textContent);
        } else if (textContent.isEmpty()) {
            this.removeAllChildren();
        } else {
            Element child = this.getChildCount() == 1 && this.getChild(0).isTextNode() ? this.getChild(0).setText(textContent) : Element.createText(textContent);
            this.removeAllChildren();
            this.appendChild(child);
        }
    }

    public SignalBinding<String> bindText(Signal<String> signal) {
        Objects.requireNonNull(signal, "Signal cannot be null");
        TextBindingFeature feature = this.getNode().getFeature(TextBindingFeature.class);
        if (feature.hasBinding() && this.getNode().isAttached()) {
            throw new BindingActiveException();
        }
        SignalBinding<String> binding = ElementEffect.bind(this, signal, (element, value) -> this.setTextContent((String)value));
        feature.setBinding(binding.getEffectRegistration(), signal);
        return binding;
    }

    public String getText() {
        return this.getTextContent(Element::isTextNode);
    }

    public String getTextRecursively() {
        return this.getTextContent(e -> true);
    }

    private String getTextContent(Predicate<? super Element> childFilter) {
        if (this.isTextNode()) {
            return this.getStateProvider().getTextContent(this.getNode());
        }
        StringBuilder builder = new StringBuilder();
        this.appendTextContent(builder, childFilter);
        return builder.toString();
    }

    private void appendTextContent(StringBuilder builder, Predicate<? super Element> childFilter) {
        if (this.isTextNode()) {
            builder.append(this.getText());
        } else {
            this.getChildren().filter(childFilter).forEach(e -> e.appendTextContent(builder, childFilter));
        }
    }

    public ClassList getClassList() {
        return this.getStateProvider().getClassList(this.getNode());
    }

    public void flashClass(String className) {
        Objects.requireNonNull(className, "className cannot be null");
        this.executeJs("window.Vaadin.Flow.flashClass(this, $0)", className);
    }

    public ThemeList getThemeList() {
        return new ThemeListImpl(this);
    }

    public Style getStyle() {
        return this.getStateProvider().getStyle(this.getNode());
    }

    public Optional<Component> getComponent() {
        return this.getStateProvider().getComponent(this.getNode());
    }

    private String validateAttribute(String attribute) {
        if (attribute == null) {
            throw new IllegalArgumentException(ATTRIBUTE_NAME_CANNOT_BE_NULL);
        }
        String lowerCaseAttribute = attribute.toLowerCase(Locale.ENGLISH);
        if (!ElementUtil.isValidAttributeName(lowerCaseAttribute)) {
            throw new IllegalArgumentException(String.format("Attribute \"%s\" is not a valid attribute name", lowerCaseAttribute));
        }
        return lowerCaseAttribute;
    }

    static void verifyEventType(String eventType) {
        if (eventType == null) {
            throw new IllegalArgumentException(EVENT_TYPE_MUST_NOT_BE_NULL);
        }
    }

    public Registration addAttachListener(final ElementAttachListener attachListener) {
        if (attachListener == null) {
            throw new IllegalArgumentException("ElementAttachListener cannot be null");
        }
        return this.getNode().addAttachListener(new Command(){

            @Override
            public void execute() {
                attachListener.onAttach(new ElementAttachEvent(Element.this));
            }
        });
    }

    public Registration addDetachListener(final ElementDetachListener detachListener) {
        if (detachListener == null) {
            throw new IllegalArgumentException("ElementDetachListener cannot be null");
        }
        return this.getNode().addDetachListener(new Command(){

            @Override
            public void execute() {
                detachListener.onDetach(new ElementDetachEvent(Element.this));
            }
        });
    }

    public String toString() {
        return this.getOuterHTML();
    }

    public String getOuterHTML() {
        return ElementUtil.toJsoup(new Document(""), this).outerHtml();
    }

    public <T extends Component> T as(Class<T> componentType) {
        return ComponentUtil.componentFromElement(this, componentType, false);
    }

    public PendingJavaScriptResult callJsFunction(String functionName, Object ... arguments) {
        Object[] jsParameters;
        assert (functionName != null);
        assert (!functionName.startsWith(".")) : "Function name should not start with a dot";
        String paramPlaceholderString = IntStream.range(1, arguments.length + 1).mapToObj(i -> "$" + i).collect(Collectors.joining(","));
        if (arguments.length == 0) {
            jsParameters = new Object[]{this};
        } else {
            jsParameters = new Object[arguments.length + 1];
            jsParameters[0] = this;
            System.arraycopy(arguments, 0, jsParameters, 1, arguments.length);
        }
        return this.scheduleJavaScriptInvocation("return $0." + functionName + "(" + paramPlaceholderString + ")", jsParameters);
    }

    @Deprecated
    public PendingJavaScriptResult callJsFunction(String functionName, Serializable[] arguments) {
        return this.callJsFunction(functionName, (Object[])arguments);
    }

    public PendingJavaScriptResult executeJs(String expression, Object ... parameters) {
        Object[] wrappedParameters;
        if (parameters.length == 0) {
            wrappedParameters = new Object[]{this};
        } else {
            wrappedParameters = Arrays.copyOf(parameters, parameters.length + 1);
            wrappedParameters[parameters.length] = this;
        }
        String wrappedExpression = "return (async function() { " + expression + "}).apply($" + parameters.length + ")";
        return this.scheduleJavaScriptInvocation(wrappedExpression, wrappedParameters);
    }

    @Deprecated
    public PendingJavaScriptResult executeJs(String expression, Serializable[] parameters) {
        return this.executeJs(expression, (Object[])parameters);
    }

    private PendingJavaScriptResult scheduleJavaScriptInvocation(String expression, Object[] parameters) {
        StateNode node = this.getNode();
        UIInternals.JavaScriptInvocation invocation = new UIInternals.JavaScriptInvocation(expression, parameters);
        PendingJavaScriptInvocation pending = new PendingJavaScriptInvocation(node, invocation);
        node.runWhenAttached(ui -> ui.getInternals().getStateTree().beforeClientResponse(node, context -> {
            if (!pending.isCanceled()) {
                context.getUI().getInternals().addJavaScriptInvocation(pending);
            }
        }));
        return pending;
    }

    public ShadowRoot attachShadow() {
        if (this.getShadowRoot().isPresent()) {
            throw new IllegalStateException("The element already has shadow root");
        }
        return ShadowRoot.get(this.getStateProvider().attachShadow(this.getNode()));
    }

    public Optional<ShadowRoot> getShadowRoot() {
        StateNode shadowRoot = this.getStateProvider().getShadowRoot(this.getNode());
        if (shadowRoot == null) {
            return Optional.empty();
        }
        return Optional.of(ShadowRoot.get(shadowRoot));
    }

    public SignalBinding<Boolean> bindVisible(Signal<Boolean> visibleSignal) {
        Objects.requireNonNull(visibleSignal, "Signal cannot be null");
        return this.getStateProvider().bindVisibleSignal(this, visibleSignal);
    }

    public Element setVisible(boolean visible) {
        this.getStateProvider().setVisible(this.getNode(), visible);
        return this.getSelf();
    }

    public boolean isVisible() {
        return this.getStateProvider().isVisible(this.getNode());
    }

    public SignalBinding<Boolean> bindEnabled(Signal<Boolean> enabledSignal) {
        Objects.requireNonNull(enabledSignal, "Signal cannot be null");
        SignalBindingFeature feature = this.getNode().getFeature(SignalBindingFeature.class);
        if (feature.hasBinding("enabled")) {
            throw new BindingActiveException();
        }
        SignalBinding<Boolean> binding = ElementEffect.bind(this, enabledSignal, (element, value) -> this.setEnabledInternal((Boolean)value));
        feature.setBinding("enabled", binding.getEffectRegistration(), enabledSignal);
        return binding;
    }

    private void setEnabledInternal(Boolean enabled) {
        boolean booleanEnabled = enabled != null ? enabled : false;
        this.getNode().setEnabled(booleanEnabled);
        this.informEnabledStateChange(booleanEnabled, this);
    }

    public Element setEnabled(boolean enabled) {
        this.getFeatureIfInitialized(SignalBindingFeature.class).ifPresent(feature -> {
            if (feature.hasBinding("enabled")) {
                throw new BindingActiveException("setEnabled is not allowed while a binding for enabled state exists.");
            }
        });
        this.setEnabledInternal(enabled);
        return this.getSelf();
    }

    public boolean isEnabled() {
        return this.getNode().isEnabled();
    }

    @Override
    protected Element getSelf() {
        return this;
    }

    private void informEnabledStateChange(boolean enabled, Element element) {
        Optional<Component> componentOptional = element.getComponent();
        if (componentOptional.isPresent()) {
            Component component = componentOptional.get();
            component.onEnabledStateChanged(enabled ? element.isEnabled() : false);
        }
        this.informChildrenOfStateChange(enabled, element);
    }

    private void informChildrenOfStateChange(boolean enabled, Element element) {
        element.getChildren().forEach(child -> this.informEnabledStateChange(enabled, (Element)child));
        if (element.getNode().hasFeature(VirtualChildrenList.class)) {
            element.getNode().getFeatureIfInitialized(VirtualChildrenList.class).ifPresent(list -> list.forEachChild(node -> this.informEnabledStateChange(enabled, Element.get(node))));
        }
    }

    public Element scrollIntoView(ScrollIntoViewOption ... options) {
        ObjectNode json = ScrollIntoViewOption.buildOptions(options);
        if (json == null) {
            this.executeJs("setTimeout(function(){$0.scrollIntoView()},0)", this);
        } else {
            this.executeJs("setTimeout(function(){$0.scrollIntoView($1)},0)", this, json);
        }
        return this.getSelf();
    }

    @Deprecated(since="25.0", forRemoval=true)
    public Element scrollIntoView(ScrollOptions scrollOptions) {
        String options = scrollOptions == null ? "" : scrollOptions.toJson();
        this.executeJs("var el = this; setTimeout(function() {el.scrollIntoView(" + options + ");}, 0);", new Object[0]);
        return this.getSelf();
    }

    private <T extends NodeFeature> Optional<T> getFeatureIfInitialized(Class<T> featureClass) {
        try {
            return this.getNode().getFeatureIfInitialized(featureClass);
        }
        catch (IllegalStateException e) {
            return Optional.empty();
        }
    }

    static {
        illegalPropertyReplacements.put("textContent", "setTextContent(String)");
        illegalPropertyReplacements.put("classList", "getClassList()");
        illegalPropertyReplacements.put("className", "getClassList()");
        illegalPropertyReplacements.put("outerHTML", "getParent().setProperty('innerHTML',value)");
        NO_OP_DOM_LISTENER = event -> {};
    }
}

