/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.page;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.page.ColorScheme;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.server.VaadinSession;
import java.io.Serializable;
import java.util.Date;
import java.util.function.Function;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.JsonNodeType;
import tools.jackson.databind.node.ObjectNode;

public class ExtendedClientDetails
implements Serializable {
    private final UI ui;
    private int screenWidth = -1;
    private int screenHeight = -1;
    private int bodyClientWidth = -1;
    private int bodyClientHeight = -1;
    private int timezoneOffset = 0;
    private int rawTimezoneOffset = 0;
    private int dstSavings;
    private boolean dstInEffect;
    private String timeZoneId;
    private long clientServerTimeDelta;
    private boolean touchDevice;
    private double devicePixelRatio = -1.0;
    private String windowName;
    private String navigatorPlatform;
    private ColorScheme.Value colorScheme = ColorScheme.Value.NORMAL;
    private String themeName;

    public ExtendedClientDetails(UI ui, String screenWidth, String screenHeight, String windowInnerWidth, String windowInnerHeight, String bodyClientWidth, String bodyClientHeight, String tzOffset, String rawTzOffset, String dstShift, String dstInEffect, String tzId, String curDate, String touchDevice, String devicePixelRatio, String windowName, String navigatorPlatform, String colorScheme, String themeName) {
        this.ui = ui;
        if (screenWidth != null) {
            try {
                this.screenWidth = Integer.parseInt(screenWidth);
                this.screenHeight = Integer.parseInt(screenHeight);
            }
            catch (NumberFormatException e) {
                this.screenWidth = -1;
                this.screenHeight = -1;
            }
        }
        if (bodyClientHeight != null) {
            try {
                this.bodyClientHeight = Integer.parseInt(bodyClientHeight);
                this.bodyClientWidth = Integer.parseInt(bodyClientWidth);
            }
            catch (NumberFormatException e) {
                this.bodyClientWidth = -1;
                this.bodyClientHeight = -1;
            }
        }
        if (windowInnerHeight != null && ui != null) {
            try {
                ui.getPage().setWindowSize(Integer.parseInt(windowInnerWidth), Integer.parseInt(windowInnerHeight));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if (tzOffset != null) {
            try {
                this.timezoneOffset = -Integer.parseInt(tzOffset) * 60 * 1000;
            }
            catch (NumberFormatException e) {
                this.timezoneOffset = 0;
            }
        }
        if (rawTzOffset != null) {
            try {
                this.rawTimezoneOffset = -Integer.parseInt(rawTzOffset) * 60 * 1000;
            }
            catch (NumberFormatException e) {
                this.rawTimezoneOffset = 0;
            }
        }
        if (dstShift != null) {
            try {
                this.dstSavings = Integer.parseInt(dstShift) * 60 * 1000;
            }
            catch (NumberFormatException e) {
                this.dstSavings = 0;
            }
        }
        if (dstInEffect != null) {
            this.dstInEffect = Boolean.parseBoolean(dstInEffect);
        }
        this.timeZoneId = tzId == null || "undefined".equals(tzId) ? null : tzId;
        if (curDate != null) {
            try {
                long curTime = Long.parseLong(curDate);
                this.clientServerTimeDelta = curTime - new Date().getTime();
            }
            catch (NumberFormatException e) {
                this.clientServerTimeDelta = 0L;
            }
        }
        if (touchDevice != null) {
            this.touchDevice = Boolean.parseBoolean(touchDevice);
        }
        if (devicePixelRatio != null) {
            this.devicePixelRatio = Double.parseDouble(devicePixelRatio);
        }
        this.windowName = windowName;
        this.navigatorPlatform = navigatorPlatform;
        this.setColorScheme(ColorScheme.Value.fromString(colorScheme));
        this.themeName = themeName;
    }

    public int getScreenWidth() {
        return this.screenWidth;
    }

    public int getScreenHeight() {
        return this.screenHeight;
    }

    public int getWindowInnerHeight() {
        return this.ui == null ? -1 : this.ui.getPage().windowSizeSignal().peek().height();
    }

    public int getWindowInnerWidth() {
        return this.ui == null ? -1 : this.ui.getPage().windowSizeSignal().peek().width();
    }

    public int getBodyClientHeight() {
        return this.bodyClientHeight;
    }

    public int getBodyClientWidth() {
        return this.bodyClientWidth;
    }

    public int getTimezoneOffset() {
        return this.timezoneOffset;
    }

    public String getTimeZoneId() {
        return this.timeZoneId;
    }

    public int getRawTimezoneOffset() {
        return this.rawTimezoneOffset;
    }

    public int getDSTSavings() {
        return this.dstSavings;
    }

    public boolean isDSTInEffect() {
        return this.dstInEffect;
    }

    public Date getCurrentDate() {
        return new Date(new Date().getTime() + this.clientServerTimeDelta);
    }

    public boolean isTouchDevice() {
        return this.touchDevice;
    }

    public double getDevicePixelRatio() {
        return this.devicePixelRatio;
    }

    public String getWindowName() {
        return this.windowName;
    }

    public boolean isIPad() {
        return this.navigatorPlatform != null && (this.navigatorPlatform.startsWith("iPad") || this.navigatorPlatform.equals("MacIntel") && this.isTouchDevice());
    }

    public boolean isIOS() {
        return this.isIPad() || VaadinSession.getCurrent().getBrowser().isIPhone() || this.navigatorPlatform != null && this.navigatorPlatform.startsWith("iPod");
    }

    public ColorScheme.Value getColorScheme() {
        return this.colorScheme;
    }

    public String getThemeName() {
        return this.themeName;
    }

    void setColorScheme(ColorScheme.Value colorScheme) {
        this.colorScheme = colorScheme == null ? ColorScheme.Value.NORMAL : colorScheme;
    }

    public static ExtendedClientDetails fromJson(UI ui, JsonNode json) {
        if (!(json instanceof ObjectNode)) {
            throw new RuntimeException("Expected a JSON object");
        }
        ObjectNode jsonObj = (ObjectNode)json;
        Function<String, String> getStringElseNull = key -> {
            JsonNode jsValue = jsonObj.get(key);
            if (jsValue != null && JsonNodeType.STRING.equals((Object)jsValue.getNodeType())) {
                return jsValue.asString();
            }
            return null;
        };
        return new ExtendedClientDetails(ui, getStringElseNull.apply("v-sw"), getStringElseNull.apply("v-sh"), getStringElseNull.apply("v-ww"), getStringElseNull.apply("v-wh"), getStringElseNull.apply("v-bw"), getStringElseNull.apply("v-bh"), getStringElseNull.apply("v-tzo"), getStringElseNull.apply("v-rtzo"), getStringElseNull.apply("v-dstd"), getStringElseNull.apply("v-dston"), getStringElseNull.apply("v-tzid"), getStringElseNull.apply("v-curdate"), getStringElseNull.apply("v-td"), getStringElseNull.apply("v-pr"), getStringElseNull.apply("v-wn"), getStringElseNull.apply("v-np"), getStringElseNull.apply("v-cs"), getStringElseNull.apply("v-tn"));
    }

    public void refresh(SerializableConsumer<ExtendedClientDetails> callback) {
        String js = "return Vaadin.Flow.getBrowserDetailsParameters();";
        SerializableConsumer resultHandler = json -> {
            ExtendedClientDetails details = ExtendedClientDetails.fromJson(this.ui, json);
            this.ui.getInternals().setExtendedClientDetails(details);
            if (callback != null) {
                callback.accept(details);
            }
        };
        SerializableConsumer errorHandler = err -> {
            throw new RuntimeException("Unable to retrieve extended client details. JS error is '" + err + "'");
        };
        this.ui.getPage().executeJs("return Vaadin.Flow.getBrowserDetailsParameters();", new Object[0]).then(resultHandler, errorHandler);
    }
}

