/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.PropertyDescriptor;
import com.vaadin.flow.component.PropertyDescriptors;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.ElementEffect;
import com.vaadin.flow.dom.SignalBinding;
import com.vaadin.flow.internal.nodefeature.SignalBindingFeature;
import com.vaadin.flow.signals.BindingActiveException;
import com.vaadin.flow.signals.Signal;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jsoup.Jsoup;
import org.jsoup.helper.DataUtil;
import org.jsoup.nodes.Attribute;
import org.jsoup.nodes.Attributes;
import org.jsoup.nodes.Document;

public class Html
extends Component {
    private static final PropertyDescriptor<String, String> innerHtmlDescriptor = PropertyDescriptors.propertyWithDefault("innerHTML", "");

    public Html(InputStream stream) {
        super(null);
        if (stream == null) {
            throw new IllegalArgumentException("HTML stream cannot be null");
        }
        try {
            this.setOuterHtml(StandardCharsets.UTF_8.decode(DataUtil.readToByteBuffer((InputStream)stream, (int)0)).toString(), false);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Unable to read HTML from stream", e);
        }
    }

    public Html(String outerHtml) {
        super(null);
        if (outerHtml == null || outerHtml.isEmpty()) {
            throw new IllegalArgumentException("HTML cannot be null or empty");
        }
        this.setOuterHtml(outerHtml, false);
    }

    public Html(Signal<String> htmlSignal) {
        super(null);
        if (htmlSignal == null) {
            throw new IllegalArgumentException("HTML signal cannot be null");
        }
        String outerHtml = htmlSignal.peek();
        if (outerHtml == null || outerHtml.isEmpty()) {
            throw new IllegalArgumentException("HTML cannot be null or empty");
        }
        this.setOuterHtml(outerHtml, false);
        this.bindHtmlContent(htmlSignal);
    }

    public void setHtmlContent(String html) {
        this.getElement().getNode().getFeatureIfInitialized(SignalBindingFeature.class).ifPresent(feature -> {
            if (feature.hasBinding("htmlContent")) {
                throw new BindingActiveException("setHtmlContent is not allowed while a binding for HTML content exists.");
            }
        });
        this.setOuterHtml(html, true);
    }

    private void setOuterHtml(String outerHtml, boolean update) {
        Document doc = Jsoup.parseBodyFragment((String)outerHtml);
        int nrChildren = doc.body().children().size();
        if (nrChildren != 1) {
            String message = "HTML must contain exactly one top level element (ignoring text nodes). Found " + nrChildren;
            if (nrChildren > 1) {
                String tagNames = doc.body().children().stream().map(org.jsoup.nodes.Element::tagName).collect(Collectors.joining(", "));
                message = message + " elements with the tag names " + tagNames;
            }
            throw new IllegalArgumentException(message);
        }
        org.jsoup.nodes.Element root = doc.body().child(0);
        Attributes attrs = root.attributes();
        if (!update) {
            Component.setElement(this, new Element(root.tagName()));
        }
        attrs.forEach(this::setAttribute);
        if (update && !root.tagName().equals(this.getElement().getTag())) {
            throw new IllegalStateException("Existing root tag '" + this.getElement().getTag() + "' can't be changed to '" + root.tagName() + "'");
        }
        doc.outputSettings().prettyPrint(false);
        this.setInnerHtml(root.html());
    }

    private void setAttribute(Attribute attribute) {
        String name = attribute.getKey();
        String value = attribute.getValue();
        if (value == null) {
            value = "";
        }
        this.getElement().setAttribute(name, value);
    }

    private void setInnerHtml(String innerHtml) {
        this.set(innerHtmlDescriptor, innerHtml);
    }

    public String getInnerHtml() {
        return this.get(innerHtmlDescriptor);
    }

    public void bindHtmlContent(Signal<String> htmlSignal) {
        Objects.requireNonNull(htmlSignal, "Signal cannot be null");
        SignalBindingFeature feature = this.getElement().getNode().getFeature(SignalBindingFeature.class);
        if (feature.hasBinding("htmlContent")) {
            throw new BindingActiveException();
        }
        SignalBinding<String> binding = ElementEffect.bind(this.getElement(), htmlSignal, (element, value) -> this.setOuterHtml((String)value, true));
        feature.setBinding("htmlContent", binding.getEffectRegistration(), htmlSignal);
    }
}

