/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.signals.shared.impl;

import com.vaadin.flow.signals.Id;
import com.vaadin.flow.signals.SignalCommand;
import com.vaadin.flow.signals.TestUtil;
import com.vaadin.flow.signals.shared.impl.CommandResult;
import com.vaadin.flow.signals.shared.impl.CommandsAndHandlers;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CommandsAndHandlersTest {
    @Test
    void constructor_emptyInstance_isEmpty() {
        CommandsAndHandlers commands = new CommandsAndHandlers();
        Assertions.assertTrue((boolean)commands.isEmpty());
        Assertions.assertEquals(List.of(), (Object)commands.getCommands());
        Assertions.assertEquals(Map.of(), (Object)commands.getResultHandlers());
    }

    @Test
    void contructor_singleCommandNoHandler_hasCommandButNoHandler() {
        SignalCommand command = TestUtil.writeRootValueCommand();
        CommandsAndHandlers commands = new CommandsAndHandlers(command, null);
        Assertions.assertFalse((boolean)commands.isEmpty());
        Assertions.assertEquals(List.of(command), (Object)commands.getCommands());
        Assertions.assertEquals(Map.of(), (Object)commands.getResultHandlers());
    }

    @Test
    void constructor_singleCommandAndHandler_hasCommandAndHandler() {
        SignalCommand command = TestUtil.writeRootValueCommand();
        CommandsAndHandlers.CommandResultHandler handler = CommandsAndHandlersTest.dummyHandler();
        CommandsAndHandlers commands = new CommandsAndHandlers(command, handler);
        Assertions.assertFalse((boolean)commands.isEmpty());
        Assertions.assertEquals(List.of(command), (Object)commands.getCommands());
        Assertions.assertEquals(Map.of(command.commandId(), handler), (Object)commands.getResultHandlers());
    }

    @Test
    void constructor_multipleCommandsAndHandlers_hasCopiesOfEverything() {
        SignalCommand c1 = TestUtil.writeRootValueCommand();
        SignalCommand c2 = TestUtil.writeRootValueCommand();
        CommandsAndHandlers.CommandResultHandler handler = CommandsAndHandlersTest.dummyHandler();
        List<SignalCommand> list = Arrays.asList(c1, c2);
        HashMap<Id, CommandsAndHandlers.CommandResultHandler> map = new HashMap<Id, CommandsAndHandlers.CommandResultHandler>();
        map.put(c1.commandId(), handler);
        CommandsAndHandlers commands = new CommandsAndHandlers(list, map);
        list.set(0, null);
        map.clear();
        Assertions.assertEquals(List.of(c1, c2), (Object)commands.getCommands());
        Assertions.assertEquals(Map.of(c1.commandId(), handler), (Object)commands.getResultHandlers());
    }

    @Test
    void removeHandledCommands_commandsInList_commandsRemovedHandlersRetained() {
        SignalCommand c1 = TestUtil.writeRootValueCommand();
        SignalCommand c2 = TestUtil.writeRootValueCommand();
        SignalCommand c3 = TestUtil.writeRootValueCommand();
        CommandsAndHandlers.CommandResultHandler handler = CommandsAndHandlersTest.dummyHandler();
        CommandsAndHandlers commands = new CommandsAndHandlers(List.of(c1, c2, c3), Map.of(c2.commandId(), handler));
        commands.removeHandledCommands(List.of(c2.commandId()));
        Assertions.assertEquals(List.of(c1, c3), (Object)commands.getCommands());
        Assertions.assertEquals(Map.of(c2.commandId(), handler), (Object)commands.getResultHandlers());
    }

    @Test
    void removeHandledCommands_commandsNotInList_noChange() {
        CommandsAndHandlers commands = new CommandsAndHandlers(TestUtil.writeRootValueCommand(), CommandsAndHandlersTest.dummyHandler());
        commands.removeHandledCommands(List.of(Id.random()));
        Assertions.assertEquals((int)1, (int)commands.getCommands().size());
        Assertions.assertEquals((int)1, (int)commands.getResultHandlers().size());
    }

    @Test
    void notifyResultHandlers_handlerPresent_handlerInvokedAndRemoved() {
        SignalCommand c1 = TestUtil.writeRootValueCommand();
        ResultHandler h1 = new ResultHandler();
        CommandsAndHandlers commands = new CommandsAndHandlers(c1, (CommandsAndHandlers.CommandResultHandler)h1);
        CommandResult.Accept result = CommandResult.ok();
        commands.notifyResultHandlers(Map.of(c1.commandId(), result));
        Assertions.assertEquals((Object)result, (Object)h1.result);
        Assertions.assertEquals(Map.of(), (Object)commands.getResultHandlers());
    }

    @Test
    void notifyResultHandlers_multipleResults_invokedInOrder() {
        SignalCommand c1 = TestUtil.writeRootValueCommand();
        SignalCommand c2 = TestUtil.writeRootValueCommand();
        CommandResult.Accept r1 = CommandResult.ok();
        CommandResult.Accept r2 = CommandResult.ok();
        ArrayList results = new ArrayList();
        CommandsAndHandlers commands = new CommandsAndHandlers(List.of(c2, c1), Map.of(c2.commandId(), (CommandsAndHandlers.CommandResultHandler & Serializable)result -> {
            Assertions.assertSame((Object)r2, (Object)result);
            results.add(result);
        }, c1.commandId(), (CommandsAndHandlers.CommandResultHandler & Serializable)result -> {
            Assertions.assertSame((Object)r1, (Object)result);
            results.add(result);
        }));
        commands.notifyResultHandlers(Map.of(c2.commandId(), r2, c1.commandId(), r1), List.of(c1, c2));
        Assertions.assertEquals(List.of(r1, r2), results);
    }

    @Test
    void notifyResultHandlers_nestedTransactionCommands_childHandlersInvoked() {
        SignalCommand c1 = TestUtil.writeRootValueCommand();
        SignalCommand.TransactionCommand tx1 = new SignalCommand.TransactionCommand(Id.random(), List.of(c1));
        SignalCommand.TransactionCommand tx2 = new SignalCommand.TransactionCommand(Id.random(), List.of(tx1));
        CommandResult.Accept r1 = CommandResult.ok();
        CommandResult.Accept r2 = CommandResult.ok();
        CommandResult.Accept r3 = CommandResult.ok();
        ResultHandler h1 = new ResultHandler();
        ResultHandler h2 = new ResultHandler();
        ResultHandler h3 = new ResultHandler();
        CommandsAndHandlers commands = new CommandsAndHandlers(List.of(tx2), Map.of(c1.commandId(), h1, tx1.commandId(), h2, tx2.commandId(), h3));
        commands.notifyResultHandlers(Map.of(c1.commandId(), r1, tx1.commandId(), r2, tx2.commandId(), r3));
        Assertions.assertEquals((Object)r1, (Object)h1.result);
        Assertions.assertEquals((Object)r2, (Object)h2.result);
        Assertions.assertEquals((Object)r3, (Object)h3.result);
    }

    @Test
    void add_otherCommands_added() {
        SignalCommand c1 = TestUtil.writeRootValueCommand();
        SignalCommand c2 = TestUtil.writeRootValueCommand();
        CommandsAndHandlers.CommandResultHandler h1 = CommandsAndHandlersTest.dummyHandler();
        CommandsAndHandlers.CommandResultHandler h2 = CommandsAndHandlersTest.dummyHandler();
        CommandsAndHandlers commands = new CommandsAndHandlers(c1, h1);
        commands.add(new CommandsAndHandlers(c2, h2));
        Assertions.assertEquals(List.of(c1, c2), (Object)commands.getCommands());
        Assertions.assertEquals(Map.of(c1.commandId(), h1, c2.commandId(), h2), (Object)commands.getResultHandlers());
    }

    private static CommandsAndHandlers.CommandResultHandler dummyHandler() {
        return (CommandsAndHandlers.CommandResultHandler & Serializable)ignore -> {};
    }

    public static class ResultHandler
    implements CommandsAndHandlers.CommandResultHandler {
        public @Nullable CommandResult result;

        public void handle(CommandResult result) {
            Assertions.assertNull((Object)this.result);
            this.result = result;
        }
    }
}

