/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.signals;

import com.vaadin.flow.signals.Id;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import tools.jackson.core.JacksonException;
import tools.jackson.databind.ObjectMapper;

public class IdTest {
    @Test
    void randomId_isRandom() {
        Assertions.assertNotEquals((Object)Id.random(), (Object)Id.random());
    }

    @Test
    void basicJsonSerialization() throws JacksonException {
        ObjectMapper mapper = new ObjectMapper();
        Id id = new Id(4600806552848092835L);
        String jsonString = mapper.writeValueAsString((Object)id);
        Assertions.assertEquals((Object)"\"P9lZLwbMzqM\"", (Object)jsonString);
        Id deserialized = (Id)mapper.readValue(jsonString, Id.class);
        Assertions.assertEquals((Object)id, (Object)deserialized);
    }

    @Test
    void zeroId_compactJson() throws JacksonException {
        ObjectMapper mapper = new ObjectMapper();
        String jsonString = mapper.writeValueAsString((Object)Id.ZERO);
        Assertions.assertEquals((Object)"\"\"", (Object)jsonString);
        Id deserialized = (Id)mapper.readValue(jsonString, Id.class);
        Assertions.assertEquals((Object)Id.ZERO, (Object)deserialized);
    }

    @Test
    void comparable() {
        List<Id> ids = List.of(new Id(0L), new Id(-42365683L), new Id(754L));
        List sorted = ids.stream().sorted().toList();
        Assertions.assertEquals(List.of(new Id(-42365683L), new Id(0L), new Id(754L)), sorted);
    }
}

