/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.startup;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.WebComponentExporter;
import com.vaadin.flow.component.page.Push;
import com.vaadin.flow.component.webcomponent.WebComponent;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.router.RouterLayout;
import com.vaadin.flow.server.InvalidApplicationConfigurationException;
import com.vaadin.flow.server.startup.WebComponentExporterAwareValidator;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class WebComponentExporterAwareValidatorTest {
    private static final String ERROR_HINT = "Move it to a single route/a top router layout/web component of the application";
    private WebComponentExporterAwareValidator annotationValidator;
    private ServletContext servletContext;

    WebComponentExporterAwareValidatorTest() {
    }

    @BeforeEach
    public void init() {
        this.annotationValidator = new WebComponentExporterAwareValidator();
        this.servletContext = (ServletContext)Mockito.mock(ServletContext.class);
    }

    @Test
    public void process_no_exception_is_thrown_for_correctly_setup_classes() throws ServletException {
        this.annotationValidator.process(Stream.of(AbstractMain.class, WCExporter.class).collect(Collectors.toSet()), this.servletContext);
    }

    @Test
    public void process_all_failing_anotations_are_reported() throws ServletException {
        try {
            this.annotationValidator.process(Collections.singleton(ThemeViewportWithParent.class), this.servletContext);
            Assertions.fail((String)"No exception was thrown for faulty setup.");
        }
        catch (InvalidApplicationConfigurationException iace) {
            String errorMessage = iace.getMessage();
            this.assertHint(errorMessage, Push.class);
        }
    }

    @Test
    public void process_non_linked_push_throws() throws ServletException {
        this.assertNon_linked_theme_throws(NonRoutePush.class, Push.class);
    }

    private void assertNon_linked_theme_throws(Class<? extends Component> clazz, Class<? extends Annotation> annotationType) throws ServletException {
        InvalidApplicationConfigurationException thrown = (InvalidApplicationConfigurationException)Assertions.assertThrows(InvalidApplicationConfigurationException.class, () -> this.annotationValidator.process(Stream.of(clazz).collect(Collectors.toSet()), this.servletContext));
        Assertions.assertTrue((boolean)thrown.getMessage().contains(ERROR_HINT));
        Assertions.assertTrue((boolean)thrown.getMessage().contains(String.format("Class '%s' contains '%s', but it is not a router layout/top level route/web component.", clazz.getName(), "@" + annotationType.getSimpleName())));
    }

    private void assertHint(String msg, Class<? extends Annotation> anntationType) {
        MatcherAssert.assertThat((String)"Exception has hint.", (Object)msg, (Matcher)CoreMatchers.allOf((Matcher)CoreMatchers.containsString((String)anntationType.getSimpleName()), (Matcher)CoreMatchers.containsString((String)ERROR_HINT)));
    }

    @Tag(value="div")
    public static abstract class AbstractMain
    extends Component {
    }

    @Tag(value="div")
    @Push
    public static class WCExporter
    extends WebComponentExporter<Component> {
        public WCExporter() {
            super("div");
        }

        public void configureInstance(WebComponent<Component> webComponent, Component component) {
        }
    }

    @Route(value="", layout=Parent.class)
    @Tag(value="div")
    @Push
    public static class ThemeViewportWithParent
    extends Component {
    }

    @Tag(value="div")
    @Push
    public static class NonRoutePush
    extends Component {
    }

    @Tag(value="div")
    public static class Parent
    extends Component
    implements RouterLayout {
    }
}

