/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.startup;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.router.BeforeEnterEvent;
import com.vaadin.flow.router.ErrorParameter;
import com.vaadin.flow.router.HasErrorParameter;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.router.RouteAlias;
import com.vaadin.flow.router.RouteData;
import com.vaadin.flow.router.RouterLayout;
import com.vaadin.flow.server.RouteRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import net.jcip.annotations.NotThreadSafe;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@NotThreadSafe
abstract class RouteRegistryTestBase {
    RouteRegistryTestBase() {
    }

    @Test
    public void initializedRoutes_routesCanBeAdded() {
        this.getInitializationRegistry().clean();
        this.getInitializationRegistry().setRoute("home", MyRoute.class, Collections.emptyList());
        this.getInitializationRegistry().setRoute("info", MyInfo.class, Collections.emptyList());
        Assertions.assertEquals((int)2, (int)this.getTestedRegistry().getRegisteredRoutes().size(), (String)"Initial registration of routes should have succeeded.");
        this.getTestedRegistry().setRoute("palace", MyPalace.class, Collections.emptyList());
        this.getTestedRegistry().setRoute("modular", MyModular.class, Collections.emptyList());
        Assertions.assertEquals((int)4, (int)this.getTestedRegistry().getRegisteredRoutes().size(), (String)"All new routes should have been registered");
        this.getTestedRegistry().setRoute("withAliases", MyRouteWithAliases.class, Collections.emptyList());
        this.getTestedRegistry().setRoute("version", MyRouteWithAliases.class, Collections.emptyList());
        this.getTestedRegistry().setRoute("person", MyRouteWithAliases.class, Collections.emptyList());
        Assertions.assertEquals((int)5, (int)this.getTestedRegistry().getRegisteredRoutes().size(), (String)"The new route should have registered");
    }

    @Test
    public void registeringRouteWithAlias_RouteDataIsPopulatedCorrectly() {
        this.getInitializationRegistry().clean();
        this.getInitializationRegistry().setRoute("home", MyRoute.class, Collections.emptyList());
        this.getInitializationRegistry().setRoute("info", MyInfo.class, Collections.emptyList());
        this.getInitializationRegistry().setRoute("withAliases", MyRouteWithAliases.class, Collections.emptyList());
        this.getInitializationRegistry().setRoute("version", MyRouteWithAliases.class, Collections.emptyList());
        this.getInitializationRegistry().setRoute("person", MyRouteWithAliases.class, Collections.emptyList());
        Optional<RouteData> first = this.getTestedRegistry().getRegisteredRoutes().stream().filter(route -> route.getNavigationTarget().equals(MyRouteWithAliases.class)).findFirst();
        Assertions.assertTrue((boolean)first.isPresent(), (String)"Didn't get RouteData for MyRouteWithAliases.");
        Assertions.assertEquals((int)2, (int)first.get().getRouteAliases().size(), (String)"Expected two route aliases to be registered");
    }

    @Test
    public void registeredRouteWithAlias_removingClassRemovesAliases() {
        this.getInitializationRegistry().clean();
        this.getInitializationRegistry().setRoute("withAliases", MyRouteWithAliases.class, Collections.emptyList());
        this.getInitializationRegistry().setRoute("version", MyRouteWithAliases.class, Collections.emptyList());
        this.getInitializationRegistry().setRoute("person", MyRouteWithAliases.class, Collections.emptyList());
        Assertions.assertTrue((!this.getTestedRegistry().getRegisteredRoutes().isEmpty() ? 1 : 0) != 0, (String)"Registry didn't contain routes even though 3 should have been registered");
        Assertions.assertTrue((boolean)this.getTestedRegistry().getNavigationTarget("withAliases").isPresent(), (String)"Path for main route 'withAliases' returned empty");
        Assertions.assertTrue((boolean)this.getTestedRegistry().getNavigationTarget("version").isPresent(), (String)"RouteAlias 'version' returned empty.");
        Assertions.assertTrue((boolean)this.getTestedRegistry().getNavigationTarget("person").isPresent(), (String)"RouteAlias 'person' returned empty.");
        this.getTestedRegistry().removeRoute(MyRouteWithAliases.class);
        Assertions.assertFalse((!this.getTestedRegistry().getRegisteredRoutes().isEmpty() ? 1 : 0) != 0, (String)"Registry should be empty after removing the only registered Class.");
    }

    @Test
    public void registeredRouteWithAlias_removingPathLeavesAliases() {
        this.getInitializationRegistry().clean();
        this.getInitializationRegistry().setRoute("withAliases", MyRouteWithAliases.class, Collections.emptyList());
        this.getInitializationRegistry().setRoute("version", MyRouteWithAliases.class, Collections.emptyList());
        this.getInitializationRegistry().setRoute("person", MyRouteWithAliases.class, Collections.emptyList());
        Assertions.assertTrue((!this.getTestedRegistry().getRegisteredRoutes().isEmpty() ? 1 : 0) != 0, (String)"Registry didn't contain routes even though 3 should have been registered");
        Assertions.assertTrue((boolean)this.getTestedRegistry().getNavigationTarget("withAliases").isPresent(), (String)"Path for main route 'withAliases' returned empty");
        Assertions.assertTrue((boolean)this.getTestedRegistry().getNavigationTarget("version").isPresent(), (String)"RouteAlias 'version' returned empty.");
        Assertions.assertTrue((boolean)this.getTestedRegistry().getNavigationTarget("person").isPresent(), (String)"RouteAlias 'person' returned empty.");
        this.getTestedRegistry().removeRoute("withAliases");
        Assertions.assertTrue((!this.getTestedRegistry().getRegisteredRoutes().isEmpty() ? 1 : 0) != 0, (String)"Registry should contain alias routes");
        Assertions.assertEquals((int)1, (int)((RouteData)this.getTestedRegistry().getRegisteredRoutes().get(0)).getRouteAliases().size(), (String)"One RouteAlias should be the main url so only 1 route alias should be marked as an alias");
    }

    @Test
    public void routesWithParentLayouts_parentLayoutReturnsAsExpected() {
        this.getInitializationRegistry().clean();
        this.getInitializationRegistry().setRoute("MyRoute", MyRouteWithAliases.class, Collections.singletonList(MainLayout.class));
        this.getInitializationRegistry().setRoute("info", MyRouteWithAliases.class, Collections.emptyList());
        this.getInitializationRegistry().setRoute("version", MyRouteWithAliases.class, Arrays.asList(MiddleLayout.class, MainLayout.class));
        Assertions.assertFalse((boolean)this.getTestedRegistry().getNavigationRouteTarget("MyRoute").getRouteTarget().getParentLayouts().isEmpty(), (String)"'MyRoute' should have a single parent");
        Assertions.assertTrue((boolean)this.getTestedRegistry().getNavigationRouteTarget("info").getRouteTarget().getParentLayouts().isEmpty(), (String)"'info' should have no parents.");
        Assertions.assertEquals((int)2, (int)this.getTestedRegistry().getNavigationRouteTarget("version").getRouteTarget().getParentLayouts().size(), (String)"'version' should return two parents");
    }

    @Test
    public void registeredParentLayouts_changingListDoesntChangeRegistration() {
        this.getInitializationRegistry().clean();
        ArrayList<Class> parentChain = new ArrayList<Class>(Arrays.asList(MiddleLayout.class, MainLayout.class));
        this.getInitializationRegistry().setRoute("version", MyRoute.class, parentChain);
        parentChain.remove(MainLayout.class);
        Assertions.assertEquals((int)2, (int)this.getTestedRegistry().getNavigationRouteTarget("version").getRouteTarget().getParentLayouts().size(), (String)"'version' should return two parents even when original list is changed");
    }

    @Test
    public void registeredParentLayouts_returnedListInSameOrder() {
        this.getInitializationRegistry().clean();
        ArrayList<Class> parentChain = new ArrayList<Class>(Arrays.asList(MiddleLayout.class, MainLayout.class));
        this.getInitializationRegistry().setRoute("version", MyRoute.class, parentChain);
        Assertions.assertArrayEquals((Object[])parentChain.toArray(), (Object[])this.getTestedRegistry().getNavigationRouteTarget("version").getRouteTarget().getParentLayouts().toArray(), (String)"Registry should return parent layouts in the same order as set.");
    }

    protected abstract RouteRegistry getInitializationRegistry();

    protected abstract RouteRegistry getTestedRegistry();

    @Tag(value="div")
    @Route(value="home")
    protected static class MyRoute
    extends Component {
        protected MyRoute() {
        }
    }

    @Tag(value="div")
    @Route(value="info")
    protected static class MyInfo
    extends Component {
        protected MyInfo() {
        }
    }

    @Tag(value="div")
    @Route(value="palace")
    protected static class MyPalace
    extends Component {
        protected MyPalace() {
        }
    }

    @Tag(value="div")
    @Route(value="modular")
    protected static class MyModular
    extends Component {
        protected MyModular() {
        }
    }

    @Tag(value="div")
    @Route(value="withAliases")
    @RouteAlias.Container(value={@RouteAlias(value="version"), @RouteAlias(value="person")})
    protected static class MyRouteWithAliases
    extends Component {
        protected MyRouteWithAliases() {
        }
    }

    @Tag(value="div")
    protected static class MainLayout
    extends Component
    implements RouterLayout {
        protected MainLayout() {
        }
    }

    @Tag(value="div")
    protected static class MiddleLayout
    extends Component
    implements RouterLayout {
        protected MiddleLayout() {
        }
    }

    @Tag(value="div")
    public static class ErrorView
    extends AbstractErrorView<NullPointerException> {
        public int setErrorParameter(BeforeEnterEvent event, ErrorParameter<NullPointerException> parameter) {
            return 0;
        }
    }

    @Tag(value="div")
    public static abstract class AbstractErrorView<EXCEPTION_TYPE extends Exception>
    extends Component
    implements HasErrorParameter<EXCEPTION_TYPE> {
    }

    @Tag(value="div")
    protected static class Secondary
    extends Component {
        protected Secondary() {
        }
    }
}

