/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.dau;

import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.dau.FlowDauIntegration;
import com.vaadin.pro.licensechecker.dau.DauIntegration;
import jakarta.servlet.http.Cookie;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.MockedStatic;
import org.mockito.Mockito;

class FlowDauIntegrationTest {
    FlowDauIntegrationTest() {
    }

    @Test
    public void generateNewCookie_setsUpExpectedParameters() {
        try (MockedStatic key = Mockito.mockStatic(DauIntegration.class);){
            key.when(DauIntegration::newTrackingHash).thenReturn((Object)"hash");
            VaadinRequest request = (VaadinRequest)Mockito.mock(VaadinRequest.class);
            Mockito.when((Object)request.isSecure()).thenReturn((Object)true);
            Cookie cookie = FlowDauIntegration.generateNewCookie((VaadinRequest)request);
            String[] hashAndTime = cookie.getValue().split("\\$");
            Assertions.assertEquals((Object)"hash", (Object)hashAndTime[0]);
            Assertions.assertFalse((boolean)hashAndTime[1].isBlank());
            Assertions.assertEquals((Object)"DailyActiveUser", (Object)cookie.getName());
            Assertions.assertTrue((boolean)cookie.isHttpOnly());
            Assertions.assertTrue((boolean)cookie.getSecure());
            Assertions.assertEquals((int)86400, (int)cookie.getMaxAge());
            Assertions.assertEquals((Object)"/", (Object)cookie.getPath());
        }
    }

    @Test
    public void generateNewCookie_notSecureRequest_cookieNotSecure() {
        try (MockedStatic key = Mockito.mockStatic(DauIntegration.class);){
            key.when(DauIntegration::newTrackingHash).thenReturn((Object)"hash");
            VaadinRequest request = (VaadinRequest)Mockito.mock(VaadinRequest.class);
            Mockito.when((Object)request.isSecure()).thenReturn((Object)false);
            Cookie cookie = FlowDauIntegration.generateNewCookie((VaadinRequest)request);
            Assertions.assertFalse((boolean)cookie.getSecure());
        }
    }
}

