/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.communication.rpc;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.ElementFactory;
import com.vaadin.flow.dom.ElementUtil;
import com.vaadin.flow.internal.JacksonUtils;
import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.server.communication.rpc.AbstractRpcInvocationHandler;
import java.util.Optional;
import java.util.function.Consumer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.ObjectNode;

class AbstractRpcInvocationHandlerTest {
    private TestRpcInvocationHandler handler = new TestRpcInvocationHandler();

    AbstractRpcInvocationHandlerTest() {
    }

    @Test
    public void handleVisibleAndEnabledNode_nodeIsHandled() {
        UI ui = new UI();
        Element element = this.createRpcInvocationData(ui, null);
        Assertions.assertSame((Object)element.getNode(), (Object)this.handler.node);
    }

    @Test
    public void handleInactiveNode_nodeIsNotHandled() {
        UI ui = new UI();
        this.createRpcInvocationData(ui, elem -> {
            elem.setVisible(false);
            elem.getNode().updateActiveState();
        });
        Assertions.assertNull((Object)this.handler.node);
    }

    @Test
    public void handleInertNode_nodeIsNotHandled() {
        UI ui = new UI();
        this.createRpcInvocationData(ui, elem -> {
            ElementUtil.setInert((Element)elem, (boolean)true);
            ui.getInternals().getStateTree().collectDirtyNodes().forEach(stateNode -> stateNode.collectChanges(change -> {}));
        });
        Assertions.assertNull((Object)this.handler.node);
    }

    @Test
    public void inertUI_passingNoPollingPayload_ignoresPollingInvocation() {
        UI ui = this.createInertUIWithPollInterval();
        JsonNode invocationJson = this.createNonPollingRpcInvocationPayload(ui);
        Optional runnable = this.handler.handle(ui, invocationJson);
        Assertions.assertEquals(Optional.empty(), (Object)runnable);
    }

    @Test
    public void inertUIWithPollingInterval_passingLegitimatePollingPayload_doesNotIgnorePolling() {
        UI ui = this.createInertUI();
        JsonNode invocationJson = this.createLegitimatePollingRpcInvocationPayload(ui);
        Optional runnable = this.handler.handle(ui, invocationJson);
        Assertions.assertEquals(Optional.empty(), (Object)runnable);
        ui.setPollInterval(0);
        runnable = this.handler.handle(ui, invocationJson);
        Assertions.assertEquals(Optional.empty(), (Object)runnable);
        ui.setPollInterval(5000);
        runnable = this.handler.handle(ui, invocationJson);
        Assertions.assertNotEquals(Optional.empty(), (Object)runnable);
    }

    @Test
    public void inertUIWithPollingInterval_passingIllegitimateKeysForPollingPayload_ignoresInvocation() {
        UI ui = this.createInertUIWithPollInterval();
        JsonNode invocationJson = this.createIllegitimatePayloadKeysPollingRpcInvocationPayload(ui);
        Optional runnable = this.handler.handle(ui, invocationJson);
        Assertions.assertEquals(Optional.empty(), (Object)runnable);
    }

    @Test
    public void inertUIWithPollingInterval_passingIllegitimateGreaterNumberOfKeysForPollingPayload_ignoresInvocation() {
        UI ui = this.createInertUIWithPollInterval();
        JsonNode invocationJson = this.createIllegitimatePayloadWithGreaterSizePollingRpcInvocationPayload(ui);
        Optional runnable = this.handler.handle(ui, invocationJson);
        Assertions.assertEquals(Optional.empty(), (Object)runnable);
    }

    @Test
    public void inertUIWithPollingInterval_passingIllegitimateSmallerNumberOfKeysForPollingPayload_ignoresInvocation() {
        UI ui = this.createInertUIWithPollInterval();
        JsonNode invocationJson = this.createIllegitimatePayloadWithSmallerSizePollingRpcInvocationPayload(ui);
        Optional runnable = this.handler.handle(ui, invocationJson);
        Assertions.assertEquals(Optional.empty(), (Object)runnable);
    }

    @Test
    public void inertUIWithPollingInterval_passingIllegitimateNoNodeKeyForPollingPayload_throwsAssertionError() {
        UI ui = this.createInertUIWithPollInterval();
        JsonNode invocationJson = this.createIllegitimatePayloadNoNodeKeyForPollingRpcInvocationPayload();
        Assertions.assertThrows(AssertionError.class, () -> this.handler.handle(ui, invocationJson));
    }

    @Test
    public void inertUIWithPollingInterval_passingIllegitimateNonRootNodeIdForPollingPayload_ignoresInvocation() {
        UI ui = this.createInertUIWithPollInterval();
        JsonNode invocationJson = this.createIllegitimatePayloadWithNonRootNodePollingRpcInvocationPayload(ui);
        Optional runnable = this.handler.handle(ui, invocationJson);
        Assertions.assertEquals(Optional.empty(), (Object)runnable);
    }

    @Test
    public void inertUIWithoutPollInterval_passingLegitimatePollingPayload_logsIgnoredPayloadInDebugLevel() {
        Logger logger = (Logger)Mockito.spy(Logger.class);
        try (MockedStatic mockedLoggerFactory = Mockito.mockStatic(LoggerFactory.class);){
            mockedLoggerFactory.when(() -> LoggerFactory.getLogger((String)AbstractRpcInvocationHandler.class.getName())).thenReturn((Object)logger);
            UI ui = this.createInertUI();
            JsonNode invocationJson = this.createLegitimatePollingRpcInvocationPayload(ui);
            this.handler.handle(ui, invocationJson);
            ((Logger)Mockito.verify((Object)logger, (VerificationMode)Mockito.times((int)1))).warn(Mockito.anyString());
            ((Logger)Mockito.verify((Object)logger, (VerificationMode)Mockito.times((int)1))).debug(Mockito.anyString(), Mockito.any());
        }
    }

    @Test
    public void inertUIWithPollingInterval_passingIllegitimatePollingPayload_logsIgnoredPayloadInDebugLevel() {
        Logger logger = (Logger)Mockito.spy(Logger.class);
        try (MockedStatic mockedLoggerFactory = Mockito.mockStatic(LoggerFactory.class);){
            mockedLoggerFactory.when(() -> LoggerFactory.getLogger((String)AbstractRpcInvocationHandler.class.getName())).thenReturn((Object)logger);
            UI ui = this.createInertUIWithPollInterval();
            JsonNode invocationJson = this.createIllegitimatePayloadKeysPollingRpcInvocationPayload(ui);
            this.handler.handle(ui, invocationJson);
            ((Logger)Mockito.verify((Object)logger, (VerificationMode)Mockito.times((int)1))).warn(Mockito.anyString());
            ((Logger)Mockito.verify((Object)logger, (VerificationMode)Mockito.times((int)1))).debug(Mockito.anyString(), Mockito.any());
        }
    }

    private Element createRpcInvocationData(UI ui, Consumer<Element> additionalConfig) {
        Element element = ElementFactory.createAnchor();
        ui.getElement().appendChild(new Element[]{element});
        if (additionalConfig != null) {
            additionalConfig.accept(element);
        }
        ObjectNode object = JacksonUtils.createObjectNode();
        object.put("node", element.getNode().getId());
        this.handler.handle(ui, (JsonNode)object);
        return element;
    }

    private UI createInertUIWithPollInterval() {
        UI ui = this.createInertUI();
        ui.setPollInterval(5000);
        return ui;
    }

    private UI createInertUI() {
        UI ui = new UI();
        ElementUtil.setInert((Element)ui.getElement(), (boolean)true);
        ui.getInternals().getStateTree().collectDirtyNodes().forEach(stateNode -> stateNode.collectChanges(change -> {}));
        return ui;
    }

    private JsonNode createLegitimatePollingRpcInvocationPayload(UI ui) {
        ObjectNode payload = JacksonUtils.createObjectNode();
        payload.put("type", "event");
        payload.put("node", ui.getElement().getNode().getId());
        payload.put("event", "ui-poll");
        return payload;
    }

    private JsonNode createIllegitimatePayloadKeysPollingRpcInvocationPayload(UI ui) {
        ObjectNode payload = JacksonUtils.createObjectNode();
        payload.put("data", "DATA");
        payload.put("node", ui.getElement().getNode().getId());
        payload.put("event", "ui-poll");
        return payload;
    }

    private JsonNode createIllegitimatePayloadWithGreaterSizePollingRpcInvocationPayload(UI ui) {
        ObjectNode payload = JacksonUtils.createObjectNode();
        payload.put("data", "DATA");
        payload.put("type", "event");
        payload.put("node", ui.getElement().getNode().getId());
        payload.put("event", "ui-poll");
        return payload;
    }

    private JsonNode createIllegitimatePayloadWithSmallerSizePollingRpcInvocationPayload(UI ui) {
        ObjectNode payload = JacksonUtils.createObjectNode();
        payload.put("node", ui.getElement().getNode().getId());
        payload.put("event", "ui-poll");
        return payload;
    }

    private JsonNode createIllegitimatePayloadNoNodeKeyForPollingRpcInvocationPayload() {
        ObjectNode payload = JacksonUtils.createObjectNode();
        payload.put("type", "event");
        payload.put("type", "change");
        payload.put("event", "ui-poll");
        return payload;
    }

    private JsonNode createNonPollingRpcInvocationPayload(UI ui) {
        ObjectNode payload = JacksonUtils.createObjectNode();
        payload.put("type", "event");
        payload.put("node", ui.getInternals().getStateTree().getRootNode().getId());
        payload.put("event", "mSync");
        return payload;
    }

    private JsonNode createIllegitimatePayloadWithNonRootNodePollingRpcInvocationPayload(UI ui) {
        Element element = ElementFactory.createAnchor();
        ui.getElement().appendChild(new Element[]{element});
        ObjectNode payload = JacksonUtils.createObjectNode();
        payload.put("type", "event");
        payload.put("node", element.getNode().getId());
        payload.put("event", "ui-poll");
        return payload;
    }

    private static class TestRpcInvocationHandler
    extends AbstractRpcInvocationHandler {
        private StateNode node;

        private TestRpcInvocationHandler() {
        }

        public String getRpcType() {
            return null;
        }

        protected Optional<Runnable> handleNode(StateNode node, JsonNode invocationJson) {
            this.node = node;
            return Optional.of(() -> {});
        }
    }
}

