/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.communication;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.internal.CurrentInstance;
import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.internal.streams.UploadCompleteEvent;
import com.vaadin.flow.internal.streams.UploadStartEvent;
import com.vaadin.flow.server.AbstractStreamResource;
import com.vaadin.flow.server.Command;
import com.vaadin.flow.server.HttpStatusCode;
import com.vaadin.flow.server.MockVaadinServletService;
import com.vaadin.flow.server.MockVaadinSession;
import com.vaadin.flow.server.ServiceException;
import com.vaadin.flow.server.StreamRegistration;
import com.vaadin.flow.server.StreamResourceRegistry;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinResponse;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinServletRequest;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.communication.StreamRequestHandler;
import com.vaadin.flow.server.streams.ElementRequestHandler;
import com.vaadin.flow.server.streams.FileFactory;
import com.vaadin.flow.server.streams.FileUploadCallback;
import com.vaadin.flow.server.streams.FileUploadHandler;
import com.vaadin.flow.server.streams.InMemoryUploadCallback;
import com.vaadin.flow.server.streams.InMemoryUploadHandler;
import com.vaadin.flow.server.streams.TemporaryFileUploadHandler;
import com.vaadin.flow.server.streams.UploadEvent;
import com.vaadin.flow.server.streams.UploadHandler;
import com.vaadin.flow.server.streams.UploadMetadata;
import com.vaadin.flow.server.streams.UploadResult;
import com.vaadin.flow.shared.Registration;
import com.vaadin.tests.util.AlwaysLockedVaadinSession;
import com.vaadin.tests.util.MockUI;
import jakarta.servlet.ReadListener;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.Part;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Optional;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import net.jcip.annotations.NotThreadSafe;
import org.apache.commons.io.IOUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@NotThreadSafe
class UploadHandlerTest {
    public static final String MULTIPART_STREAM_CONTENT = "-------bound\nContent-Disposition: form-data; name=\"file\"; filename=\"sound.txt\"\nContent-Type: text/plain\n\nSound\n-------bound\nContent-Disposition: form-data; name=\"file\"; filename=\"bytes.txt\"\nContent-Type: text/plain\n\nBytes\n-------bound--\n".replaceAll("\n", "\r\n");
    public static final String MULTIPART_CONTENT_TYPE = "multipart/form-data; boundary=-----bound";
    private StreamRequestHandler handler = new StreamRequestHandler();
    private MockVaadinSession session;
    private VaadinServletRequest request;
    private VaadinResponse response;
    private StreamResourceRegistry streamResourceRegistry;
    private UI ui;
    private StateNode stateNode;
    private Element element;
    private TestComponent component;

    UploadHandlerTest() {
    }

    @BeforeEach
    public void setUp() throws ServletException, ServiceException {
        MockVaadinServletService service = new MockVaadinServletService();
        this.ui = new MockUI(){

            public Future<Void> access(Command command) {
                command.execute();
                return null;
            }
        };
        this.session = new AlwaysLockedVaadinSession((VaadinService)service){

            public StreamResourceRegistry getResourceRegistry() {
                return UploadHandlerTest.this.streamResourceRegistry;
            }

            public UI getUIById(int uiId) {
                return UploadHandlerTest.this.ui;
            }
        };
        this.streamResourceRegistry = new StreamResourceRegistry((VaadinSession)this.session);
        this.request = (VaadinServletRequest)Mockito.mock(VaadinServletRequest.class);
        ServletContext servletContext = (ServletContext)Mockito.mock(ServletContext.class);
        Mockito.when((Object)servletContext.getMimeType(Mockito.anyString())).thenReturn(null);
        Mockito.when((Object)this.request.getServletContext()).thenReturn((Object)servletContext);
        this.stateNode = (StateNode)Mockito.mock(StateNode.class);
        Mockito.when((Object)this.stateNode.isAttached()).thenReturn((Object)true);
        this.element = (Element)Mockito.mock(Element.class);
        this.component = new TestComponent();
        Mockito.when((Object)this.element.getNode()).thenReturn((Object)this.stateNode);
        Mockito.when((Object)this.element.getComponent()).thenReturn(Optional.of(this.component));
        this.response = (VaadinResponse)Mockito.mock(VaadinResponse.class);
    }

    @AfterEach
    public void cleanup() {
        CurrentInstance.clearAll();
    }

    @Test
    public void doUploadHandleXhrFilePost_happyPath_setContentTypeAndResponseHandled() throws IOException {
        UploadHandler & Serializable handler = (UploadHandler & Serializable)event -> event.getResponse().setContentType("text/html; charset=utf-8");
        handler.handleRequest((VaadinRequest)this.request, this.response, (VaadinSession)this.session, this.element);
        ((VaadinResponse)Mockito.verify((Object)this.response)).setContentType("text/html; charset=utf-8");
        ((VaadinResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.times((int)1))).setStatus(200);
    }

    @Test
    public void xhrUpload_filenameFromHeader_extractedCorrectly() throws IOException {
        String[] capturedFilename = new String[1];
        UploadHandler & Serializable handler = (UploadHandler & Serializable)event -> {
            capturedFilename[0] = event.getFileName();
        };
        Mockito.when((Object)this.request.getHeader("X-Filename")).thenReturn((Object)"test.txt");
        handler.handleRequest((VaadinRequest)this.request, this.response, (VaadinSession)this.session, this.element);
        Assertions.assertEquals((Object)"test.txt", (Object)capturedFilename[0]);
    }

    @Test
    public void xhrUpload_encodedFilename_decodedCorrectly() throws IOException {
        String[] capturedFilename = new String[1];
        UploadHandler & Serializable handler = (UploadHandler & Serializable)event -> {
            capturedFilename[0] = event.getFileName();
        };
        Mockito.when((Object)this.request.getHeader("X-Filename")).thenReturn((Object)"my%20file%20%C3%A5%C3%A4%C3%B6.txt");
        handler.handleRequest((VaadinRequest)this.request, this.response, (VaadinSession)this.session, this.element);
        Assertions.assertEquals((Object)"my file \u00e5\u00e4\u00f6.txt", (Object)capturedFilename[0]);
    }

    @Test
    public void xhrUpload_contentTypeFromHeader_extractedCorrectly() throws IOException {
        String[] capturedContentType = new String[1];
        UploadHandler & Serializable handler = (UploadHandler & Serializable)event -> {
            capturedContentType[0] = event.getContentType();
        };
        Mockito.when((Object)this.request.getHeader("X-Filename")).thenReturn((Object)"test.txt");
        Mockito.when((Object)this.request.getHeader("Content-Type")).thenReturn((Object)"text/plain");
        handler.handleRequest((VaadinRequest)this.request, this.response, (VaadinSession)this.session, this.element);
        Assertions.assertEquals((Object)"text/plain", (Object)capturedContentType[0]);
    }

    @Test
    public void xhrUpload_missingContentTypeHeader_defaultsToUnknown() throws IOException {
        String[] capturedContentType = new String[1];
        UploadHandler & Serializable handler = (UploadHandler & Serializable)event -> {
            capturedContentType[0] = event.getContentType();
        };
        Mockito.when((Object)this.request.getHeader("X-Filename")).thenReturn((Object)"test.txt");
        Mockito.when((Object)this.request.getHeader("Content-Type")).thenReturn(null);
        handler.handleRequest((VaadinRequest)this.request, this.response, (VaadinSession)this.session, this.element);
        Assertions.assertEquals((Object)"unknown", (Object)capturedContentType[0]);
    }

    @Test
    public void doUploadHandleXhrFilePost_unhappyPath_responseHandled() throws IOException {
        UploadHandler & Serializable handler = (UploadHandler & Serializable)event -> {
            throw new RuntimeException("Exception in xrh upload");
        };
        handler.handleRequest((VaadinRequest)this.request, this.response, (VaadinSession)this.session, this.element);
        ((VaadinResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.times((int)1))).setStatus(500);
    }

    @Test
    public void createUploadHandlerToCopyStream_streamMatchesInput() throws IOException {
        String testString = "Test string for upload";
        byte[] testBytes = testString.getBytes();
        byte[] output = new byte[testBytes.length];
        AtomicInteger amount = new AtomicInteger();
        UploadHandler & Serializable uploadHandler = (UploadHandler & Serializable)event -> {
            try (InputStream inputStream = event.getInputStream();){
                amount.set(inputStream.read(output));
            }
            catch (IOException ioe) {
                this.response.setStatus(HttpStatusCode.INTERNAL_SERVER_ERROR.getCode());
                throw new RuntimeException(ioe);
            }
        };
        StreamRegistration streamRegistration = this.streamResourceRegistry.registerResource((ElementRequestHandler)uploadHandler);
        AbstractStreamResource res = streamRegistration.getResource();
        this.mockRequest(res, testString);
        this.handler.handleRequest((VaadinSession)this.session, (VaadinRequest)this.request, this.response);
        Assertions.assertArrayEquals((byte[])testBytes, (byte[])output, (String)"Output differed from expected");
        Assertions.assertEquals((int)testBytes.length, (int)amount.get(), (String)"");
    }

    @Test
    public void createInMemoryUploadHandler_streamMatchesInput() throws IOException {
        String testString = "Test string for upload";
        byte[] testBytes = testString.getBytes();
        final byte[] output = new byte[testBytes.length];
        InMemoryUploadHandler uploadHandler = UploadHandler.inMemory((InMemoryUploadCallback)new InMemoryUploadCallback(){

            public void complete(UploadMetadata uploadMetadata, byte[] bytes) {
                Assertions.assertEquals((int)output.length, (int)bytes.length);
                System.arraycopy(bytes, 0, output, 0, bytes.length);
            }
        });
        StreamRegistration streamRegistration = this.streamResourceRegistry.registerResource((ElementRequestHandler)uploadHandler);
        AbstractStreamResource res = streamRegistration.getResource();
        this.mockRequest(res, testString);
        this.handler.handleRequest((VaadinSession)this.session, (VaadinRequest)this.request, this.response);
        this.session.getPendingAccessQueue().forEach(futureAccess -> futureAccess.run());
        Assertions.assertArrayEquals((byte[])testBytes, (byte[])output, (String)"Output differed from expected");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void createTempFileUploadHandler_streamMatchesInput() throws IOException {
        String testString = "Test string for upload";
        byte[] testBytes = testString.getBytes();
        ArrayList outputFiles = new ArrayList(1);
        TemporaryFileUploadHandler uploadHandler = UploadHandler.toTempFile((FileUploadCallback & Serializable)(uploadMetadata, file) -> outputFiles.add(file));
        StreamRegistration streamRegistration = this.streamResourceRegistry.registerResource((ElementRequestHandler)uploadHandler);
        AbstractStreamResource res = streamRegistration.getResource();
        this.mockRequest(res, testString);
        try {
            this.handler.handleRequest((VaadinSession)this.session, (VaadinRequest)this.request, this.response);
            Assertions.assertEquals((int)1, (int)outputFiles.size(), (String)"Only one uploaded file expected.");
            System.out.println(((File)outputFiles.get(0)).getPath());
            Assertions.assertArrayEquals((byte[])testBytes, (byte[])Files.readAllBytes(((File)outputFiles.get(0)).toPath()), (String)"Output differed from expected");
        }
        finally {
            for (File file2 : outputFiles) {
                file2.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void createFileUploadHandler_streamMatchesInput() throws IOException {
        String testString = "Test string for upload";
        byte[] testBytes = testString.getBytes();
        ArrayList outputFiles = new ArrayList(1);
        FileUploadHandler uploadHandler = UploadHandler.toFile((FileUploadCallback & Serializable)(uploadMetadata, file) -> outputFiles.add(file), (FileFactory & Serializable)uploadMetadata -> new File(System.getProperty("java.io.tmpdir"), uploadMetadata.fileName()));
        StreamRegistration streamRegistration = this.streamResourceRegistry.registerResource((ElementRequestHandler)uploadHandler);
        AbstractStreamResource res = streamRegistration.getResource();
        this.mockRequest(res, testString);
        try {
            this.handler.handleRequest((VaadinSession)this.session, (VaadinRequest)this.request, this.response);
            Assertions.assertEquals((int)1, (int)outputFiles.size(), (String)"Only one uploaded file expected.");
            System.out.println(((File)outputFiles.get(0)).getPath());
            Assertions.assertArrayEquals((byte[])testBytes, (byte[])Files.readAllBytes(((File)outputFiles.get(0)).toPath()), (String)"Output differed from expected");
        }
        finally {
            for (File file2 : outputFiles) {
                file2.delete();
            }
        }
    }

    @Test
    public void mulitpartData_forInputIterator_dataIsGottenCorrectly() throws IOException, ServletException {
        ArrayList outList = new ArrayList(2);
        ArrayList fileNames = new ArrayList(2);
        UploadHandler & Serializable uploadHandler = (UploadHandler & Serializable)event -> {
            fileNames.add(event.getFileName());
            try (InputStream inputStream = event.getInputStream();){
                outList.add(IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8));
            }
            catch (IOException ioe) {
                this.response.setStatus(HttpStatusCode.INTERNAL_SERVER_ERROR.getCode());
                throw new RuntimeException(ioe);
            }
        };
        StreamRegistration streamRegistration = this.streamResourceRegistry.registerResource((ElementRequestHandler)uploadHandler);
        AbstractStreamResource res = streamRegistration.getResource();
        this.mockRequest(res, MULTIPART_STREAM_CONTENT);
        Mockito.when((Object)this.request.getContentType()).thenReturn((Object)MULTIPART_CONTENT_TYPE);
        this.handler.handleRequest((VaadinSession)this.session, (VaadinRequest)this.request, this.response);
        Assertions.assertEquals((int)2, (int)outList.size());
        Assertions.assertEquals((int)2, (int)fileNames.size());
        Assertions.assertEquals((Object)"Sound", outList.get(0));
        Assertions.assertEquals((Object)"sound.txt", fileNames.get(0));
        Assertions.assertEquals((Object)"Bytes", outList.get(1));
        Assertions.assertEquals((Object)"bytes.txt", fileNames.get(1));
    }

    @Test
    public void mulitpartData_asParts_dataIsGottenCorrectly() throws IOException, ServletException {
        String testContent = "testBytes";
        ArrayList<Part> parts = new ArrayList<Part>();
        parts.add(this.createPart((InputStream)this.createInputStream("one"), MULTIPART_CONTENT_TYPE, "one.txt", 3L));
        parts.add(this.createPart((InputStream)this.createInputStream("two"), MULTIPART_CONTENT_TYPE, "two.txt", 3L));
        Mockito.when((Object)this.request.getParts()).thenReturn(parts);
        ArrayList outList = new ArrayList(2);
        ArrayList fileNames = new ArrayList(2);
        UploadHandler & Serializable uploadHandler = (UploadHandler & Serializable)event -> {
            fileNames.add(event.getFileName());
            try (InputStream inputStream = event.getInputStream();){
                outList.add(IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8));
            }
            catch (IOException ioe) {
                this.response.setStatus(HttpStatusCode.INTERNAL_SERVER_ERROR.getCode());
                throw new RuntimeException(ioe);
            }
        };
        StreamRegistration streamRegistration = this.streamResourceRegistry.registerResource((ElementRequestHandler)uploadHandler);
        AbstractStreamResource res = streamRegistration.getResource();
        this.mockRequest(res, testContent);
        Mockito.when((Object)this.request.getContentType()).thenReturn((Object)MULTIPART_CONTENT_TYPE);
        this.handler.handleRequest((VaadinSession)this.session, (VaadinRequest)this.request, this.response);
        Assertions.assertEquals((int)2, (int)outList.size());
        Assertions.assertEquals((int)2, (int)fileNames.size());
        Assertions.assertEquals((Object)"one", outList.get(0));
        Assertions.assertEquals((Object)"one.txt", fileNames.get(0));
        Assertions.assertEquals((Object)"two", outList.get(1));
        Assertions.assertEquals((Object)"two.txt", fileNames.get(1));
    }

    @Test
    public void responseHandled_calledAfterAllPartsHaveBeenHandled() throws IOException, ServletException {
        String testContent = "testBytes";
        ArrayList<Part> parts = new ArrayList<Part>();
        parts.add(this.createPart((InputStream)this.createInputStream("one"), MULTIPART_CONTENT_TYPE, "one.txt", 3L));
        parts.add(this.createPart((InputStream)this.createInputStream("two"), MULTIPART_CONTENT_TYPE, "two.txt", 3L));
        Mockito.when((Object)this.request.getParts()).thenReturn(parts);
        final AtomicBoolean handled = new AtomicBoolean(false);
        UploadHandler uploadHandler = new UploadHandler(){

            public void handleUploadRequest(UploadEvent event) {
                Assertions.assertFalse((boolean)handled.get(), (String)"Handled should not be called before a upload request");
            }

            public void responseHandled(UploadResult result) {
                handled.set(true);
            }
        };
        StreamRegistration streamRegistration = this.streamResourceRegistry.registerResource((ElementRequestHandler)uploadHandler);
        AbstractStreamResource res = streamRegistration.getResource();
        this.mockRequest(res, testContent);
        Mockito.when((Object)this.request.getContentType()).thenReturn((Object)MULTIPART_CONTENT_TYPE);
        this.handler.handleRequest((VaadinSession)this.session, (VaadinRequest)this.request, this.response);
        Assertions.assertTrue((boolean)handled.get(), (String)"Handled was not called at the end");
    }

    @Test
    public void responseHandled_calledAfterWholeStreamHasBeenHandled() throws IOException, ServletException {
        final AtomicBoolean handled = new AtomicBoolean(false);
        UploadHandler uploadHandler = new UploadHandler(){

            public void handleUploadRequest(UploadEvent event) {
                Assertions.assertFalse((boolean)handled.get(), (String)"Handled should not be called before a upload request");
            }

            public void responseHandled(UploadResult result) {
                handled.set(true);
            }
        };
        StreamRegistration streamRegistration = this.streamResourceRegistry.registerResource((ElementRequestHandler)uploadHandler);
        AbstractStreamResource res = streamRegistration.getResource();
        this.mockRequest(res, MULTIPART_STREAM_CONTENT);
        Mockito.when((Object)this.request.getContentType()).thenReturn((Object)MULTIPART_CONTENT_TYPE);
        this.handler.handleRequest((VaadinSession)this.session, (VaadinRequest)this.request, this.response);
        Assertions.assertTrue((boolean)handled.get(), (String)"Handled was not called at the end");
    }

    @Test
    public void multipartRequest_responseHandled_calledWhenExceptionIsThrown() throws IOException, ServletException {
        String testContent = "testBytes";
        ArrayList<Part> parts = new ArrayList<Part>();
        parts.add(this.createPart((InputStream)this.createInputStream("one"), MULTIPART_CONTENT_TYPE, "one.txt", 3L));
        parts.add(this.createPart((InputStream)this.createInputStream("two"), MULTIPART_CONTENT_TYPE, "two.txt", 3L));
        Mockito.when((Object)this.request.getParts()).thenReturn(parts);
        final AtomicBoolean handled = new AtomicBoolean(false);
        UploadHandler uploadHandler = new UploadHandler(){

            public void handleUploadRequest(UploadEvent event) {
                throw new RuntimeException("Exception in multipart upload");
            }

            public void responseHandled(UploadResult result) {
                handled.set(true);
            }
        };
        StreamRegistration streamRegistration = this.streamResourceRegistry.registerResource((ElementRequestHandler)uploadHandler);
        AbstractStreamResource res = streamRegistration.getResource();
        this.mockRequest(res, testContent);
        Mockito.when((Object)this.request.getContentType()).thenReturn((Object)MULTIPART_CONTENT_TYPE);
        this.handler.handleRequest((VaadinSession)this.session, (VaadinRequest)this.request, this.response);
        Assertions.assertTrue((boolean)handled.get(), (String)"Handled was not called at the end");
    }

    @Test
    public void multipartStreamRequest_responseHandled_calledWhenExceptionIsThrown() throws IOException, ServletException {
        final AtomicBoolean handled = new AtomicBoolean(false);
        UploadHandler uploadHandler = new UploadHandler(){

            public void handleUploadRequest(UploadEvent event) {
                throw new RuntimeException("Exception in multipart stream upload");
            }

            public void responseHandled(UploadResult result) {
                handled.set(true);
            }
        };
        StreamRegistration streamRegistration = this.streamResourceRegistry.registerResource((ElementRequestHandler)uploadHandler);
        AbstractStreamResource res = streamRegistration.getResource();
        this.mockRequest(res, MULTIPART_STREAM_CONTENT);
        Mockito.when((Object)this.request.getContentType()).thenReturn((Object)MULTIPART_CONTENT_TYPE);
        this.handler.handleRequest((VaadinSession)this.session, (VaadinRequest)this.request, this.response);
        Assertions.assertTrue((boolean)handled.get(), (String)"Handled was not called at the end");
    }

    @Test
    public void doesNotRequireToCatchIOException() {
        UploadHandler & Serializable handler = (UploadHandler & Serializable)event -> new FileInputStream(new File("foo"));
    }

    @Test
    public void singleUpload_startAndComplete_firesInternalEvents() throws IOException, ServletException {
        AtomicBoolean startFired = new AtomicBoolean(false);
        AtomicBoolean completeFired = new AtomicBoolean(false);
        this.component.addListener(UploadStartEvent.class, (ComponentEventListener & Serializable)event -> startFired.set(true));
        this.component.addListener(UploadCompleteEvent.class, (ComponentEventListener & Serializable)event -> completeFired.set(true));
        UploadHandler & Serializable handler = (UploadHandler & Serializable)event -> {};
        handler.handleRequest((VaadinRequest)this.request, this.response, (VaadinSession)this.session, this.element);
        Assertions.assertTrue((boolean)startFired.get(), (String)"Start event was not fired");
        Assertions.assertTrue((boolean)completeFired.get(), (String)"Complete event was not fired");
        startFired.set(false);
        completeFired.set(false);
        handler = (UploadHandler & Serializable)event -> {
            throw new RuntimeException("Test exception");
        };
        try {
            handler.handleRequest((VaadinRequest)this.request, this.response, (VaadinSession)this.session, this.element);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        Assertions.assertTrue((boolean)startFired.get(), (String)"Start event was not fired before exception");
        Assertions.assertTrue((boolean)completeFired.get(), (String)"Complete event was not fired after exception");
    }

    @Test
    public void multipartStreamRequest_startAndComplete_firesInternalEvents() throws IOException, ServletException {
        AtomicInteger startFired = new AtomicInteger(0);
        AtomicInteger completeFired = new AtomicInteger(0);
        this.component.addListener(UploadStartEvent.class, (ComponentEventListener & Serializable)event -> startFired.incrementAndGet());
        this.component.addListener(UploadCompleteEvent.class, (ComponentEventListener & Serializable)event -> completeFired.incrementAndGet());
        UploadHandler & Serializable handler = (UploadHandler & Serializable)event -> {};
        StreamRegistration streamRegistration = this.streamResourceRegistry.registerResource((ElementRequestHandler)handler);
        AbstractStreamResource res = streamRegistration.getResource();
        this.mockRequest(res, MULTIPART_STREAM_CONTENT);
        Mockito.when((Object)this.request.getContentType()).thenReturn((Object)MULTIPART_CONTENT_TYPE);
        handler.handleRequest((VaadinRequest)this.request, this.response, (VaadinSession)this.session, this.element);
        Assertions.assertEquals((int)2, (int)startFired.get(), (String)"Start event was not fired");
        Assertions.assertEquals((int)2, (int)completeFired.get(), (String)"Complete event was not fired");
    }

    @Test
    public void multipartRequest_startAndComplete_firesInternalEvents() throws IOException, ServletException {
        ArrayList<Part> parts = new ArrayList<Part>();
        parts.add(this.createPart((InputStream)this.createInputStream("one"), MULTIPART_CONTENT_TYPE, "one.txt", 3L));
        parts.add(this.createPart((InputStream)this.createInputStream("two"), MULTIPART_CONTENT_TYPE, "two.txt", 3L));
        Mockito.when((Object)this.request.getParts()).thenReturn(parts);
        AtomicInteger startFired = new AtomicInteger(0);
        AtomicInteger completeFired = new AtomicInteger(0);
        this.component.addListener(UploadStartEvent.class, (ComponentEventListener & Serializable)event -> startFired.incrementAndGet());
        this.component.addListener(UploadCompleteEvent.class, (ComponentEventListener & Serializable)event -> completeFired.incrementAndGet());
        UploadHandler & Serializable handler = (UploadHandler & Serializable)event -> {};
        StreamRegistration streamRegistration = this.streamResourceRegistry.registerResource((ElementRequestHandler)handler);
        AbstractStreamResource res = streamRegistration.getResource();
        this.mockRequest(res, MULTIPART_STREAM_CONTENT);
        Mockito.when((Object)this.request.getContentType()).thenReturn((Object)MULTIPART_CONTENT_TYPE);
        handler.handleRequest((VaadinRequest)this.request, this.response, (VaadinSession)this.session, this.element);
        Assertions.assertEquals((int)2, (int)startFired.get(), (String)"Start event was not fired");
        Assertions.assertEquals((int)2, (int)completeFired.get(), (String)"Complete event was not fired");
    }

    @Test
    public void fileUploadCallback_doesNotRequireCatch() {
        new FileUploadHandler((FileUploadCallback & Serializable)(meta, file) -> new FileInputStream(file), (FileFactory & Serializable)uploadMetadata -> new File("foo"));
    }

    @Test
    public void tmpUploadCallback_doesNotRequireCatch() {
        new TemporaryFileUploadHandler((FileUploadCallback & Serializable)(meta, file) -> new FileInputStream(file));
    }

    @Test
    public void inmemoryUploadCallback_doesNotRequireCatch() {
        new InMemoryUploadHandler((InMemoryUploadCallback & Serializable)(meta, data) -> {
            ByteArrayInputStream stream = new ByteArrayInputStream(data);
            stream.close();
        });
    }

    @Test
    public void xhrUpload_earlyRejection_returns422WithJson() throws IOException {
        UploadHandler & Serializable handler = (UploadHandler & Serializable)event -> {
            if (!event.getFileName().endsWith(".png")) {
                event.reject("Only PNG files are accepted");
            }
        };
        Mockito.when((Object)this.request.getHeader("X-Filename")).thenReturn((Object)"test.zip");
        Mockito.when((Object)this.response.getWriter()).thenReturn((Object)((PrintWriter)Mockito.mock(PrintWriter.class)));
        handler.handleRequest((VaadinRequest)this.request, this.response, (VaadinSession)this.session, this.element);
        ((VaadinResponse)Mockito.verify((Object)this.response)).setStatus(422);
        ((VaadinResponse)Mockito.verify((Object)this.response)).setContentType("application/json");
    }

    @Test
    public void xhrUpload_noRejection_returns200() throws IOException {
        UploadHandler & Serializable handler = (UploadHandler & Serializable)event -> {};
        Mockito.when((Object)this.request.getHeader("X-Filename")).thenReturn((Object)"test.png");
        handler.handleRequest((VaadinRequest)this.request, this.response, (VaadinSession)this.session, this.element);
        ((VaadinResponse)Mockito.verify((Object)this.response)).setStatus(200);
    }

    @Test
    public void xhrUpload_rejectionWithDefaultMessage_usesDefaultMessage() throws IOException {
        AtomicBoolean rejected = new AtomicBoolean(false);
        UploadHandler & Serializable handler = (UploadHandler & Serializable)event -> {
            if (event.getFileName().endsWith(".zip")) {
                event.reject();
                rejected.set(true);
            }
        };
        Mockito.when((Object)this.request.getHeader("X-Filename")).thenReturn((Object)"test.zip");
        Mockito.when((Object)this.response.getWriter()).thenReturn((Object)((PrintWriter)Mockito.mock(PrintWriter.class)));
        handler.handleRequest((VaadinRequest)this.request, this.response, (VaadinSession)this.session, this.element);
        Assertions.assertTrue((boolean)rejected.get(), (String)"File should have been rejected");
        ((VaadinResponse)Mockito.verify((Object)this.response)).setStatus(422);
    }

    @Test
    public void multipartUpload_mixedAcceptReject_returns207WithJson() throws IOException, ServletException {
        ArrayList<Part> parts = new ArrayList<Part>();
        parts.add(this.createPart((InputStream)this.createInputStream("one"), MULTIPART_CONTENT_TYPE, "file1.png", 3L));
        parts.add(this.createPart((InputStream)this.createInputStream("two"), MULTIPART_CONTENT_TYPE, "file2.zip", 3L));
        parts.add(this.createPart((InputStream)this.createInputStream("three"), MULTIPART_CONTENT_TYPE, "file3.png", 5L));
        Mockito.when((Object)this.request.getParts()).thenReturn(parts);
        ArrayList processedFiles = new ArrayList();
        UploadHandler & Serializable uploadHandler = (UploadHandler & Serializable)event -> {
            if (event.getFileName().endsWith(".zip")) {
                event.reject("ZIP files are not allowed");
            } else {
                processedFiles.add(event.getFileName());
            }
        };
        StreamRegistration streamRegistration = this.streamResourceRegistry.registerResource((ElementRequestHandler)uploadHandler);
        AbstractStreamResource res = streamRegistration.getResource();
        this.mockRequest(res, "testContent");
        Mockito.when((Object)this.request.getContentType()).thenReturn((Object)MULTIPART_CONTENT_TYPE);
        Mockito.when((Object)this.response.getWriter()).thenReturn((Object)((PrintWriter)Mockito.mock(PrintWriter.class)));
        this.handler.handleRequest((VaadinSession)this.session, (VaadinRequest)this.request, this.response);
        Assertions.assertEquals((int)2, (int)processedFiles.size(), (String)"Two files should have been accepted");
        Assertions.assertTrue((boolean)processedFiles.contains("file1.png"), (String)"file1.png should be in processed files");
        Assertions.assertTrue((boolean)processedFiles.contains("file3.png"), (String)"file3.png should be in processed files");
        ((VaadinResponse)Mockito.verify((Object)this.response)).setStatus(207);
        ((VaadinResponse)Mockito.verify((Object)this.response)).setContentType("application/json");
    }

    @Test
    public void multipartUpload_allRejected_returns422() throws IOException, ServletException {
        ArrayList<Part> parts = new ArrayList<Part>();
        parts.add(this.createPart((InputStream)this.createInputStream("one"), MULTIPART_CONTENT_TYPE, "file1.zip", 3L));
        parts.add(this.createPart((InputStream)this.createInputStream("two"), MULTIPART_CONTENT_TYPE, "file2.exe", 3L));
        Mockito.when((Object)this.request.getParts()).thenReturn(parts);
        UploadHandler & Serializable uploadHandler = (UploadHandler & Serializable)event -> event.reject("File type not allowed");
        StreamRegistration streamRegistration = this.streamResourceRegistry.registerResource((ElementRequestHandler)uploadHandler);
        AbstractStreamResource res = streamRegistration.getResource();
        this.mockRequest(res, "testContent");
        Mockito.when((Object)this.request.getContentType()).thenReturn((Object)MULTIPART_CONTENT_TYPE);
        Mockito.when((Object)this.response.getWriter()).thenReturn((Object)((PrintWriter)Mockito.mock(PrintWriter.class)));
        this.handler.handleRequest((VaadinSession)this.session, (VaadinRequest)this.request, this.response);
        ((VaadinResponse)Mockito.verify((Object)this.response)).setStatus(422);
        ((VaadinResponse)Mockito.verify((Object)this.response)).setContentType("application/json");
    }

    @Test
    public void multipartUpload_allAccepted_returns200() throws IOException, ServletException {
        ArrayList<Part> parts = new ArrayList<Part>();
        parts.add(this.createPart((InputStream)this.createInputStream("one"), MULTIPART_CONTENT_TYPE, "file1.png", 3L));
        parts.add(this.createPart((InputStream)this.createInputStream("two"), MULTIPART_CONTENT_TYPE, "file2.png", 3L));
        Mockito.when((Object)this.request.getParts()).thenReturn(parts);
        UploadHandler & Serializable uploadHandler = (UploadHandler & Serializable)event -> {};
        StreamRegistration streamRegistration = this.streamResourceRegistry.registerResource((ElementRequestHandler)uploadHandler);
        AbstractStreamResource res = streamRegistration.getResource();
        this.mockRequest(res, "testContent");
        Mockito.when((Object)this.request.getContentType()).thenReturn((Object)MULTIPART_CONTENT_TYPE);
        this.handler.handleRequest((VaadinSession)this.session, (VaadinRequest)this.request, this.response);
        ((VaadinResponse)Mockito.verify((Object)this.response)).setStatus(200);
    }

    @Test
    public void multipartUpload_earlyRejection_fileNotProcessed() throws IOException, ServletException {
        ArrayList<Part> parts = new ArrayList<Part>();
        Part rejectedPart = this.createPart((InputStream)this.createInputStream("content"), MULTIPART_CONTENT_TYPE, "file.zip", 7L);
        parts.add(rejectedPart);
        Mockito.when((Object)this.request.getParts()).thenReturn(parts);
        AtomicBoolean inputStreamAccessed = new AtomicBoolean(false);
        UploadHandler & Serializable uploadHandler = (UploadHandler & Serializable)event -> {
            if (event.getFileName().endsWith(".zip")) {
                event.reject("ZIP files not allowed");
            } else {
                try {
                    event.getInputStream().read();
                    inputStreamAccessed.set(true);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        StreamRegistration streamRegistration = this.streamResourceRegistry.registerResource((ElementRequestHandler)uploadHandler);
        AbstractStreamResource res = streamRegistration.getResource();
        this.mockRequest(res, "testContent");
        Mockito.when((Object)this.request.getContentType()).thenReturn((Object)MULTIPART_CONTENT_TYPE);
        Mockito.when((Object)this.response.getWriter()).thenReturn((Object)((PrintWriter)Mockito.mock(PrintWriter.class)));
        this.handler.handleRequest((VaadinSession)this.session, (VaadinRequest)this.request, this.response);
        Assertions.assertFalse((boolean)inputStreamAccessed.get(), (String)"Input stream should not be accessed for rejected file");
        ((VaadinResponse)Mockito.verify((Object)this.response)).setStatus(422);
    }

    private Part createPart(InputStream inputStream, String contentType, String name, long size) throws IOException {
        Part part = (Part)Mockito.mock(Part.class);
        Mockito.when((Object)part.getInputStream()).thenReturn((Object)inputStream);
        Mockito.when((Object)part.getContentType()).thenReturn((Object)contentType);
        Mockito.when((Object)part.getSubmittedFileName()).thenReturn((Object)name);
        Mockito.when((Object)part.getSize()).thenReturn((Object)size);
        return part;
    }

    private void mockRequest(AbstractStreamResource res, String content) throws IOException {
        ServletOutputStream outputStream = (ServletOutputStream)Mockito.mock(ServletOutputStream.class);
        Mockito.when((Object)this.response.getOutputStream()).thenReturn((Object)outputStream);
        Mockito.when((Object)this.request.getPathInfo()).thenReturn((Object)String.format("/%s%s/%s/%s", "VAADIN/dynamic/resource/", this.ui.getId().orElse("-1"), res.getId(), res.getName()));
        Mockito.when((Object)this.request.getContentLengthLong()).thenReturn((Object)content.length());
        Mockito.when((Object)this.request.getContentLength()).thenReturn((Object)content.length());
        Mockito.when((Object)this.request.getHeader("Content-length")).thenReturn((Object)String.valueOf(content.length()));
        Mockito.when((Object)this.request.getInputStream()).thenReturn((Object)this.createInputStream(content));
        Mockito.when((Object)this.request.getMethod()).thenReturn((Object)"POST");
        if (content.equals(MULTIPART_STREAM_CONTENT)) {
            try {
                ArrayList<Part> parts = new ArrayList<Part>();
                parts.add(this.createPart((InputStream)this.createInputStream("Sound"), "text/plain", "sound.txt", 5L));
                parts.add(this.createPart((InputStream)this.createInputStream("Bytes"), "text/plain", "bytes.txt", 5L));
                Mockito.when((Object)this.request.getParts()).thenReturn(parts);
            }
            catch (ServletException e) {
                throw new IOException(e);
            }
        }
    }

    private ServletInputStream createInputStream(String content) {
        final StringReader stringReader = new StringReader(content);
        return new ServletInputStream(this){
            boolean finished = false;

            public boolean isFinished() {
                return this.finished;
            }

            public boolean isReady() {
                try {
                    return stringReader.ready();
                }
                catch (IOException e) {
                    return true;
                }
            }

            public void setReadListener(ReadListener readListener) {
            }

            public void reset() throws IOException {
                stringReader.reset();
                this.finished = false;
            }

            public int read() throws IOException {
                int read = stringReader.read();
                if (read == -1) {
                    this.finished = true;
                }
                return read;
            }
        };
    }

    @Tag(value="div")
    private static class TestComponent
    extends Component {
        private TestComponent() {
        }

        public <T extends ComponentEvent<?>> Registration addListener(Class<T> eventType, ComponentEventListener<T> listener) {
            return super.addListener(eventType, listener);
        }
    }
}

