/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.communication;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.server.Command;
import com.vaadin.flow.server.MockVaadinSession;
import com.vaadin.flow.server.communication.AtmospherePushConnection;
import com.vaadin.tests.util.MockUI;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.Broadcaster;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class AtmospherePushConnectionTest {
    private static ExecutorService executor;
    private MockVaadinSession vaadinSession;
    private Broadcaster broadcaster;
    private AtmosphereResource resource;
    private AtmospherePushConnection connection;

    AtmospherePushConnectionTest() {
    }

    @BeforeAll
    public static void initExecutor() {
        executor = Executors.newSingleThreadExecutor();
    }

    @AfterAll
    public static void stopExecutor() {
        executor.shutdown();
    }

    @BeforeEach
    public void setup() throws Exception {
        this.vaadinSession = new MockVaadinSession();
        this.vaadinSession.lock();
        MockUI ui = new MockUI(this.vaadinSession);
        this.vaadinSession.unlock();
        this.broadcaster = (Broadcaster)Mockito.mock(Broadcaster.class);
        this.resource = (AtmosphereResource)Mockito.mock(AtmosphereResource.class);
        Mockito.when((Object)this.resource.getBroadcaster()).thenReturn((Object)this.broadcaster);
        ((AtmosphereResource)Mockito.doAnswer(i -> {
            Thread.sleep(30L);
            return null;
        }).when((Object)this.resource)).close();
        ((Broadcaster)Mockito.doAnswer(i -> {
            Thread.sleep(30L);
            return CompletableFuture.completedFuture(null);
        }).when((Object)this.broadcaster)).broadcast(ArgumentMatchers.any(), (AtmosphereResource)ArgumentMatchers.any(AtmosphereResource.class));
        this.connection = new AtmospherePushConnection((UI)ui);
        this.connection.connect(this.resource);
    }

    @Test
    public void testSerialization() throws Exception {
        UI ui = (UI)Mockito.mock(UI.class);
        AtmosphereResource resource = (AtmosphereResource)Mockito.mock(AtmosphereResource.class);
        AtmospherePushConnection connection = new AtmospherePushConnection(ui);
        connection.connect(resource);
        Assertions.assertEquals((Object)AtmospherePushConnection.State.CONNECTED, (Object)connection.getState());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        new ObjectOutputStream(baos).writeObject(connection);
        connection = (AtmospherePushConnection)new ObjectInputStream(new ByteArrayInputStream(baos.toByteArray())).readObject();
        Assertions.assertEquals((Object)AtmospherePushConnection.State.DISCONNECTED, (Object)connection.getState());
    }

    @Test
    public void pushWhileDisconnect_disconnectedWithoutSendingMessage() throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        CompletableFuture.runAsync(() -> {
            try {
                this.vaadinSession.runWithLock(() -> {
                    this.connection.push();
                    return null;
                });
                latch.countDown();
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }, CompletableFuture.delayedExecutor(5L, TimeUnit.MILLISECONDS, executor)).exceptionally(error -> {
            error.printStackTrace();
            return null;
        });
        this.connection.disconnect();
        Assertions.assertTrue((boolean)latch.await(2L, TimeUnit.SECONDS), (String)"AtmospherePushConnection not disconnected");
        Assertions.assertEquals((Object)AtmospherePushConnection.State.PUSH_PENDING, (Object)this.connection.getState());
        Mockito.verifyNoInteractions((Object[])new Object[]{this.broadcaster});
    }

    @Test
    public void disconnectWhilePush_messageSentAndThenDisconnected() throws Exception {
        CountDownLatch latch = new CountDownLatch(2);
        CompletableFuture.runAsync(() -> {
            try {
                this.vaadinSession.runWithLock(() -> {
                    CompletableFuture.runAsync(() -> {
                        this.connection.disconnect();
                        latch.countDown();
                    }, CompletableFuture.delayedExecutor(5L, TimeUnit.MILLISECONDS, executor)).exceptionally(error -> {
                        error.printStackTrace();
                        return null;
                    });
                    this.connection.push();
                    return null;
                });
                latch.countDown();
            }
            catch (Throwable ex) {
                throw new RuntimeException(ex);
            }
        }, executor).exceptionally(error -> {
            error.printStackTrace();
            return null;
        });
        Assertions.assertTrue((boolean)latch.await(3L, TimeUnit.SECONDS), (String)"Push not completed");
        ((Broadcaster)Mockito.verify((Object)this.broadcaster)).broadcast(ArgumentMatchers.any(), (AtmosphereResource)ArgumentMatchers.eq((Object)this.resource));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void disconnect_concurrentRequests_preventDeadlocks() throws Exception {
        CompletionStage threadErrorFuture;
        ReentrantLock sessionLock = new ReentrantLock();
        ((AtmosphereResource)Mockito.doAnswer(i -> {
            if (!sessionLock.tryLock(2L, TimeUnit.SECONDS)) {
                throw new AssertionError((Object)"Deadlock on AtmosphereResource.close");
            }
            sessionLock.unlock();
            return null;
        }).when((Object)this.resource)).close();
        CountDownLatch latch = new CountDownLatch(2);
        sessionLock.lock();
        try {
            threadErrorFuture = CompletableFuture.supplyAsync(() -> {
                this.connection.disconnect();
                latch.countDown();
                return null;
            }, executor).exceptionally(t -> {
                if (t instanceof CompletionException) {
                    return t.getCause();
                }
                return t;
            });
            Thread.sleep(1L);
            this.connection.disconnect();
            latch.countDown();
        }
        finally {
            sessionLock.unlock();
        }
        Throwable threadError = (Throwable)((CompletableFuture)threadErrorFuture).get(2L, TimeUnit.SECONDS);
        if (threadError != null) {
            StringWriter sw = new StringWriter();
            threadError.printStackTrace(new PrintWriter(sw));
            Assertions.fail((String)("Disconnection on spawned thread failed: " + String.valueOf(sw)));
        }
        Assertions.assertTrue((boolean)latch.await(3L, TimeUnit.SECONDS), (String)("Disconnect calls not completed, missing " + latch.getCount() + " call"));
        ((AtmosphereResource)Mockito.verify((Object)this.resource, (VerificationMode)Mockito.times((int)1))).close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void pushWhileDisconnect_preventDeadlocks() throws Exception {
        CompletionStage threadErrorFuture;
        ReentrantLock httpSessionLock = new ReentrantLock();
        ((AtmosphereResource)Mockito.doAnswer(i -> {
            if (!httpSessionLock.tryLock(2L, TimeUnit.SECONDS)) {
                throw new AssertionError((Object)"Deadlock on AtmosphereResource.close");
            }
            httpSessionLock.unlock();
            return null;
        }).when((Object)this.resource)).close();
        CountDownLatch latch = new CountDownLatch(2);
        httpSessionLock.lock();
        try {
            threadErrorFuture = CompletableFuture.supplyAsync(() -> {
                this.connection.disconnect();
                latch.countDown();
                return null;
            }, executor).exceptionally(t -> {
                if (t instanceof CompletionException) {
                    return t.getCause();
                }
                return t;
            });
            Thread.sleep(1L);
            this.vaadinSession.access((Command & Serializable)() -> this.connection.push());
            latch.countDown();
        }
        finally {
            httpSessionLock.unlock();
        }
        Throwable threadError = (Throwable)((CompletableFuture)threadErrorFuture).get(2L, TimeUnit.SECONDS);
        if (threadError != null) {
            Assertions.fail((String)("Disconnection on spawned thread failed: " + threadError.getMessage()));
        }
        Assertions.assertTrue((boolean)latch.await(3L, TimeUnit.SECONDS), (String)("Disconnect calls not completed, missing " + latch.getCount() + " call"));
        ((AtmosphereResource)Mockito.verify((Object)this.resource, (VerificationMode)Mockito.times((int)1))).close();
    }
}

