/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.DetachEvent;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.di.Instantiator;
import com.vaadin.flow.di.InstantiatorFactory;
import com.vaadin.flow.di.Lookup;
import com.vaadin.flow.function.DeploymentConfiguration;
import com.vaadin.flow.i18n.DefaultI18NProvider;
import com.vaadin.flow.i18n.I18NProvider;
import com.vaadin.flow.internal.CurrentInstance;
import com.vaadin.flow.internal.UsageStatistics;
import com.vaadin.flow.internal.menu.MenuRegistry;
import com.vaadin.flow.router.Layout;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.router.RouteConfiguration;
import com.vaadin.flow.router.RouteData;
import com.vaadin.flow.router.Router;
import com.vaadin.flow.router.RouterLayout;
import com.vaadin.flow.server.AbstractConfiguration;
import com.vaadin.flow.server.Command;
import com.vaadin.flow.server.DependencyFilter;
import com.vaadin.flow.server.ErrorHandler;
import com.vaadin.flow.server.MockInstantiator;
import com.vaadin.flow.server.MockServletConfig;
import com.vaadin.flow.server.MockVaadinServletService;
import com.vaadin.flow.server.MockVaadinSession;
import com.vaadin.flow.server.RequestHandler;
import com.vaadin.flow.server.ServiceDestroyEvent;
import com.vaadin.flow.server.ServiceDestroyListener;
import com.vaadin.flow.server.ServiceException;
import com.vaadin.flow.server.SessionDestroyEvent;
import com.vaadin.flow.server.SessionDestroyListener;
import com.vaadin.flow.server.StaticFileHandlerFactory;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinRequestInterceptor;
import com.vaadin.flow.server.VaadinResponse;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinServiceInitListener;
import com.vaadin.flow.server.VaadinServlet;
import com.vaadin.flow.server.VaadinServletService;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.VaadinSessionState;
import com.vaadin.flow.server.Version;
import com.vaadin.flow.server.WrappedSession;
import com.vaadin.flow.server.communication.PwaHandler;
import com.vaadin.flow.server.communication.StreamRequestHandler;
import com.vaadin.flow.server.communication.WebComponentBootstrapHandler;
import com.vaadin.flow.server.communication.WebComponentProvider;
import com.vaadin.flow.server.menu.AvailableViewInfo;
import com.vaadin.flow.server.startup.ApplicationRouteRegistry;
import com.vaadin.tests.util.MockDeploymentConfiguration;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpSessionBindingEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import net.jcip.annotations.NotThreadSafe;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@NotThreadSafe
class VaadinServiceTest {
    VaadinServiceTest() {
    }

    private String createCriticalNotification(String caption, String message, String details, String url) {
        return VaadinService.createCriticalNotificationJSON((String)caption, (String)message, (String)details, (String)url);
    }

    @BeforeEach
    @AfterEach
    public void clearCurrentInstances() {
        CurrentInstance.clearAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void requestEnd_serviceFailure_threadLocalsCleared() {
        MockVaadinServletService service = new MockVaadinServletService(){

            void cleanupSession(VaadinSession session) {
                throw new RuntimeException("BOOM");
            }
        };
        service.init();
        VaadinRequest request = (VaadinRequest)Mockito.mock(VaadinRequest.class);
        VaadinResponse response = (VaadinResponse)Mockito.mock(VaadinResponse.class);
        service.requestStart(request, response);
        Assertions.assertSame((Object)((Object)service), (Object)VaadinService.getCurrent());
        Assertions.assertSame((Object)request, (Object)VaadinRequest.getCurrent());
        Assertions.assertSame((Object)response, (Object)VaadinResponse.getCurrent());
        VaadinSession session = (VaadinSession)Mockito.mock(VaadinSession.class);
        VaadinSession.setCurrent((VaadinSession)session);
        try {
            service.requestEnd(request, response, session);
            Assertions.fail((String)"Should have thrown an exception");
        }
        catch (Exception e) {
            Assertions.assertNull((Object)VaadinService.getCurrent(), (String)"VaadinService.current");
            Assertions.assertNull((Object)VaadinSession.getCurrent(), (String)"VaadinSession.current");
            Assertions.assertNull((Object)VaadinRequest.getCurrent(), (String)"VaadinRequest.current");
            Assertions.assertNull((Object)VaadinResponse.getCurrent(), (String)"VaadinResponse.current");
        }
        finally {
            CurrentInstance.clearAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void requestEnd_interceptorFailure_allInterceptorsInvoked_doNotThrowAndThreadLocalsCleared() {
        VaadinRequestInterceptor interceptor1 = (VaadinRequestInterceptor)Mockito.mock(VaadinRequestInterceptor.class);
        VaadinRequestInterceptor interceptor2 = (VaadinRequestInterceptor)Mockito.mock(VaadinRequestInterceptor.class);
        ((VaadinRequestInterceptor)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException("BOOM")}).when((Object)interceptor2)).requestEnd((VaadinRequest)ArgumentMatchers.any(), (VaadinResponse)ArgumentMatchers.any(), (VaadinSession)ArgumentMatchers.any());
        VaadinRequestInterceptor interceptor3 = (VaadinRequestInterceptor)Mockito.mock(VaadinRequestInterceptor.class);
        VaadinServiceInitListener & Serializable initListener = (VaadinServiceInitListener & Serializable)event -> {
            event.addVaadinRequestInterceptor(interceptor1);
            event.addVaadinRequestInterceptor(interceptor2);
            event.addVaadinRequestInterceptor(interceptor3);
        };
        MockInstantiator instantiator = new MockInstantiator(initListener);
        MockVaadinServletService service = new MockVaadinServletService();
        service.init(instantiator);
        HashMap attributes = new HashMap();
        VaadinRequest request = (VaadinRequest)Mockito.mock(VaadinRequest.class);
        Mockito.when((Object)request.getAttribute(ArgumentMatchers.anyString())).then(i -> attributes.get(i.getArgument(0, String.class)));
        ((VaadinRequest)Mockito.doAnswer(i -> attributes.put((String)i.getArgument(0, String.class), i.getArgument(1))).when((Object)request)).setAttribute(ArgumentMatchers.anyString(), ArgumentMatchers.any());
        VaadinResponse response = (VaadinResponse)Mockito.mock(VaadinResponse.class);
        service.requestStart(request, response);
        Assertions.assertSame((Object)((Object)service), (Object)VaadinService.getCurrent());
        Assertions.assertSame((Object)request, (Object)VaadinRequest.getCurrent());
        Assertions.assertSame((Object)response, (Object)VaadinResponse.getCurrent());
        VaadinSession session = (VaadinSession)Mockito.mock(VaadinSession.class);
        VaadinSession.setCurrent((VaadinSession)session);
        try {
            service.requestEnd(request, response, session);
            Assertions.assertNull((Object)VaadinService.getCurrent(), (String)"VaadinService.current");
            Assertions.assertNull((Object)VaadinSession.getCurrent(), (String)"VaadinSession.current");
            Assertions.assertNull((Object)VaadinRequest.getCurrent(), (String)"VaadinRequest.current");
            Assertions.assertNull((Object)VaadinResponse.getCurrent(), (String)"VaadinResponse.current");
        }
        finally {
            CurrentInstance.clearAll();
        }
    }

    @Test
    public void should_reported_routing_server() {
        UsageStatistics.resetEntries();
        VaadinServiceInitListener & Serializable initListener = (VaadinServiceInitListener & Serializable)event -> RouteConfiguration.forApplicationScope().setRoute("test", TestView.class);
        MockInstantiator instantiator = new MockInstantiator(initListener);
        MockVaadinServletService service = new MockVaadinServletService();
        service.init(instantiator);
        Assertions.assertTrue((boolean)UsageStatistics.getEntries().anyMatch(e -> "routing/server".equals(e.getName())));
        Assertions.assertFalse((boolean)UsageStatistics.getEntries().anyMatch(e -> "has-auto-layout".equals(e.getName())));
    }

    @Test
    public void should_reported_routing_hybrid() {
        UsageStatistics.resetEntries();
        VaadinServiceInitListener & Serializable initListener = (VaadinServiceInitListener & Serializable)event -> RouteConfiguration.forApplicationScope().setRoute("test", TestView.class);
        UsageStatistics.markAsUsed((String)"routing/client", (String)Version.getFullVersion());
        MockInstantiator instantiator = new MockInstantiator(initListener);
        MockVaadinServletService service = new MockVaadinServletService();
        service.init(instantiator);
        Assertions.assertTrue((boolean)UsageStatistics.getEntries().anyMatch(e -> "routing/hybrid".equals(e.getName())));
        Assertions.assertFalse((boolean)UsageStatistics.getEntries().anyMatch(e -> "routing/client".equals(e.getName())));
        Assertions.assertFalse((boolean)UsageStatistics.getEntries().anyMatch(e -> "routing/server".equals(e.getName())));
        Assertions.assertTrue((boolean)UsageStatistics.getEntries().anyMatch(e -> "has-flow-route".equals(e.getName())));
        Assertions.assertFalse((boolean)UsageStatistics.getEntries().anyMatch(e -> "has-auto-layout".equals(e.getName())));
    }

    @Test
    public void should_reported_auto_layout_server() {
        UsageStatistics.resetEntries();
        VaadinServiceInitListener & Serializable initListener = (VaadinServiceInitListener & Serializable)event -> {
            @Layout
            class AutoLayout
            extends Component
            implements RouterLayout {
                AutoLayout() {
                }
            }
            ApplicationRouteRegistry.getInstance((VaadinContext)event.getSource().getContext()).setLayout(AutoLayout.class);
            RouteConfiguration.forApplicationScope().setAnnotatedRoute(AnnotatedTestView.class);
        };
        MockVaadinServletService service = new MockVaadinServletService();
        this.runWithClientRoute("client-test", false, service, () -> {
            service.init(new MockInstantiator(initListener));
            Assertions.assertTrue((boolean)UsageStatistics.getEntries().anyMatch(e -> "has-auto-layout".equals(e.getName())));
            Assertions.assertTrue((boolean)UsageStatistics.getEntries().anyMatch(e -> "has-auto-layout/server".equals(e.getName())));
            Assertions.assertFalse((boolean)UsageStatistics.getEntries().anyMatch(e -> "has-auto-layout/client".equals(e.getName())));
        });
    }

    @Test
    public void should_reported_auto_layout_client() {
        UsageStatistics.resetEntries();
        VaadinServiceInitListener & Serializable initListener = (VaadinServiceInitListener & Serializable)event -> {
            @Layout
            class AutoLayout
            extends Component
            implements RouterLayout {
                AutoLayout() {
                }
            }
            ApplicationRouteRegistry.getInstance((VaadinContext)event.getSource().getContext()).setLayout(AutoLayout.class);
        };
        MockVaadinServletService service = new MockVaadinServletService();
        this.runWithClientRoute("test", true, service, () -> {
            service.init(new MockInstantiator(initListener));
            Assertions.assertTrue((boolean)UsageStatistics.getEntries().anyMatch(e -> "has-auto-layout".equals(e.getName())));
            Assertions.assertFalse((boolean)UsageStatistics.getEntries().anyMatch(e -> "has-auto-layout/server".equals(e.getName())));
            Assertions.assertTrue((boolean)UsageStatistics.getEntries().anyMatch(e -> "has-auto-layout/client".equals(e.getName())));
        });
    }

    @Test
    public void should_reported_auto_layout_routes_not_used() {
        UsageStatistics.resetEntries();
        VaadinServiceInitListener & Serializable initListener = (VaadinServiceInitListener & Serializable)event -> {
            @Layout(value="layout")
            class AutoLayout
            extends Component
            implements RouterLayout {
                AutoLayout() {
                }
            }
            ApplicationRouteRegistry.getInstance((VaadinContext)event.getSource().getContext()).setLayout(AutoLayout.class);
            RouteConfiguration.forApplicationScope().setAnnotatedRoute(OptOutAutoLayoutTestView.class);
            @Route(value="not-in-auto-layout")
            @Tag(value="div")
            class LayoutTestView
            extends Component {
                LayoutTestView() {
                }
            }
            RouteConfiguration.forApplicationScope().setAnnotatedRoute(LayoutTestView.class);
        };
        MockVaadinServletService service = new MockVaadinServletService();
        this.runWithClientRoute("test", false, service, () -> {
            service.init(new MockInstantiator(initListener));
            Assertions.assertTrue((boolean)UsageStatistics.getEntries().anyMatch(e -> "has-auto-layout".equals(e.getName())));
            Assertions.assertFalse((boolean)UsageStatistics.getEntries().anyMatch(e -> "has-auto-layout/server".equals(e.getName())));
            Assertions.assertFalse((boolean)UsageStatistics.getEntries().anyMatch(e -> "has-auto-layout/client".equals(e.getName())));
        });
    }

    private void runWithClientRoute(String route, boolean flowLayout, MockVaadinServletService service, Runnable runnable) {
        try (MockedStatic menuRegistry = Mockito.mockStatic(MenuRegistry.class);){
            menuRegistry.when(() -> MenuRegistry.collectClientMenuItems((boolean)false, (AbstractConfiguration)service.getDeploymentConfiguration())).thenReturn(VaadinServiceTest.createClientRoutesMap(route, flowLayout));
            runnable.run();
        }
    }

    private static Map<String, AvailableViewInfo> createClientRoutesMap(String route, boolean flowLayout) {
        HashMap<String, AvailableViewInfo> clientViews = new HashMap<String, AvailableViewInfo>();
        clientViews.put(route, new AvailableViewInfo(route, null, false, route, false, false, null, null, null, flowLayout, null));
        return clientViews;
    }

    @Test
    public void testFireSessionDestroy() {
        MockVaadinServletService service = VaadinServiceTest.createService();
        TestSessionDestroyListener listener = new TestSessionDestroyListener();
        service.addSessionDestroyListener(listener);
        MockVaadinSession vaadinSession = new MockVaadinSession((VaadinService)service);
        service.fireSessionDestroy(vaadinSession);
        Assertions.assertEquals((int)1, (int)vaadinSession.getCloseCount(), (String)"'fireSessionDestroy' method doesn't call 'close' for the session");
        vaadinSession.valueUnbound((HttpSessionBindingEvent)Mockito.mock(HttpSessionBindingEvent.class));
        Assertions.assertEquals((int)1, (int)vaadinSession.getCloseCount(), (String)"'fireSessionDestroy' method may not call 'close' method for closing session");
        Assertions.assertEquals((int)1, (int)listener.callCount, (String)"SessionDestroyListeners not called exactly once");
    }

    @Test
    public void testSessionDestroyListenerCalled_whenAnotherListenerThrows() {
        MockVaadinServletService service = VaadinServiceTest.createService();
        ThrowingSessionDestroyListener throwingListener = new ThrowingSessionDestroyListener();
        TestSessionDestroyListener listener = new TestSessionDestroyListener();
        service.addSessionDestroyListener(throwingListener);
        service.addSessionDestroyListener(listener);
        AtomicInteger errorCount = new AtomicInteger();
        MockVaadinSession vaadinSession = new MockVaadinSession((VaadinService)service);
        vaadinSession.lock();
        vaadinSession.setErrorHandler((ErrorHandler & Serializable)e -> errorCount.getAndIncrement());
        vaadinSession.unlock();
        service.fireSessionDestroy(vaadinSession);
        Assertions.assertEquals((int)1, (int)errorCount.get(), (String)"ErrorHandler not called exactly once");
        Assertions.assertEquals((int)1, (int)listener.callCount, (String)"SessionDestroyListener not called exactly once");
    }

    @Test
    public void testSessionDestroyListenerCalled_andOtherUiDetachCalled_whenUiClosingThrows() {
        MockVaadinServletService service = VaadinServiceTest.createService();
        TestSessionDestroyListener listener = new TestSessionDestroyListener();
        service.addSessionDestroyListener(listener);
        final AtomicBoolean secondUiDetached = new AtomicBoolean();
        final ArrayList<UI> uis = new ArrayList<UI>();
        final MockVaadinSession vaadinSession = new MockVaadinSession((VaadinService)service){

            public Collection<UI> getUIs() {
                return uis;
            }
        };
        vaadinSession.lock();
        UI throwingUI = new UI(){

            protected void onDetach(DetachEvent detachEvent) {
                throw new RuntimeException();
            }

            public VaadinSession getSession() {
                return vaadinSession;
            }
        };
        throwingUI.getInternals().setSession((VaadinSession)vaadinSession);
        uis.add(throwingUI);
        UI detachingUI = new UI(){

            protected void onDetach(DetachEvent detachEvent) {
                secondUiDetached.set(true);
            }

            public VaadinSession getSession() {
                return vaadinSession;
            }
        };
        detachingUI.getInternals().setSession((VaadinSession)vaadinSession);
        uis.add(detachingUI);
        vaadinSession.unlock();
        service.fireSessionDestroy(vaadinSession);
        Assertions.assertTrue((boolean)secondUiDetached.get(), (String)"Second UI detach not called properly");
        Assertions.assertEquals((int)1, (int)listener.callCount, (String)"SessionDestroyListener not called exactly once");
    }

    @Test
    public void testServiceDestroyListenerCalled_whenAnotherListenerThrows() {
        MockVaadinServletService service = VaadinServiceTest.createService();
        ThrowingServiceDestroyListener throwingListener = new ThrowingServiceDestroyListener();
        TestServiceDestroyListener listener = new TestServiceDestroyListener();
        service.addServiceDestroyListener(throwingListener);
        service.addServiceDestroyListener(listener);
        Assertions.assertThrows(RuntimeException.class, () -> ((VaadinService)service).destroy());
        Assertions.assertEquals((int)1, (int)listener.callCount, (String)"ServiceDestroyListener not called exactly once");
    }

    @Test
    public void captionIsSetToACriticalNotification() {
        String notification = this.createCriticalNotification("foobar", "message", "details", "url");
        MatcherAssert.assertThat((Object)notification, (Matcher)CoreMatchers.containsString((String)"\"caption\":\"foobar\""));
    }

    @Test
    public void nullCaptionIsSetToACriticalNotification() {
        String notification = this.createCriticalNotification(null, "message", "details", "url");
        MatcherAssert.assertThat((Object)notification, (Matcher)CoreMatchers.containsString((String)"\"caption\":null"));
    }

    @Test
    public void messageWithDetailsIsSetToACriticalNotification() {
        String notification = this.createCriticalNotification("caption", "foo", "bar", "url");
        MatcherAssert.assertThat((Object)notification, (Matcher)CoreMatchers.containsString((String)"\"details\":\"bar\""));
    }

    @Test
    public void nullMessageSentAsNullInACriticalNotification() {
        String notification = this.createCriticalNotification("caption", null, "foobar", "url");
        MatcherAssert.assertThat((Object)notification, (Matcher)CoreMatchers.containsString((String)"\"message\":null"));
    }

    @Test
    public void nullMessageIsSetToACriticalNotification() {
        String notification = this.createCriticalNotification("caption", null, null, "url");
        MatcherAssert.assertThat((Object)notification, (Matcher)CoreMatchers.containsString((String)"\"message\":null"));
    }

    @Test
    public void messageSetToACriticalNotification() {
        String notification = this.createCriticalNotification("caption", "foobar", null, "url");
        MatcherAssert.assertThat((Object)notification, (Matcher)CoreMatchers.containsString((String)"\"message\":\"foobar\""));
    }

    @Test
    public void urlIsSetToACriticalNotification() {
        String notification = this.createCriticalNotification("caption", "message", "details", "foobar");
        MatcherAssert.assertThat((Object)notification, (Matcher)CoreMatchers.containsString((String)"\"url\":\"foobar\""));
    }

    @Test
    public void nullUrlIsSetToACriticalNotification() {
        String notification = this.createCriticalNotification("caption", "message", "details", null);
        MatcherAssert.assertThat((Object)notification, (Matcher)CoreMatchers.containsString((String)"\"url\":null"));
    }

    @Test
    public void serviceContainsStreamRequestHandler() throws ServiceException, ServletException {
        MockServletConfig servletConfig = new MockServletConfig();
        Lookup lookup = (Lookup)Mockito.mock(Lookup.class);
        servletConfig.getServletContext().setAttribute(Lookup.class.getName(), (Object)lookup);
        StaticFileHandlerFactory factory = (StaticFileHandlerFactory)Mockito.mock(StaticFileHandlerFactory.class);
        Mockito.when((Object)((StaticFileHandlerFactory)lookup.lookup(StaticFileHandlerFactory.class))).thenReturn((Object)factory);
        VaadinServlet servlet = new VaadinServlet(){

            protected DeploymentConfiguration createDeploymentConfiguration() {
                return new MockDeploymentConfiguration();
            }
        };
        servlet.init((ServletConfig)servletConfig);
        VaadinServletService service = servlet.getService();
        Assertions.assertTrue((boolean)service.createRequestHandlers().stream().filter(StreamRequestHandler.class::isInstance).findAny().isPresent());
    }

    @Test
    public void currentInstancesAfterPendingAccessTasks() {
        MockVaadinServletService service = VaadinServiceTest.createService();
        MockVaadinSession session = new MockVaadinSession((VaadinService)service);
        session.lock();
        service.accessSession(session, (Command & Serializable)() -> CurrentInstance.set(String.class, (Object)"Set in task"));
        CurrentInstance.set(String.class, (Object)"Original value");
        service.runPendingAccessTasks(session);
        Assertions.assertEquals((Object)"Original value", (Object)CurrentInstance.get(String.class), (String)"Original CurrentInstance should be set after the task has been run");
    }

    @Test
    public void testServiceInitListener_accessApplicationRouteRegistry_registryAvailable() {
        VaadinServiceInitListener & Serializable initListener = (VaadinServiceInitListener & Serializable)event -> {
            Assertions.assertNotNull((Object)VaadinService.getCurrent(), (String)"service init should have set thread local");
            Router router = event.getSource().getRouter();
            Assertions.assertNotNull((Object)router, (String)"Router should be initialized");
            Assertions.assertNotNull((Object)router.getRegistry(), (String)"registry should be initialized");
            RouteConfiguration.forApplicationScope().setRoute("test", TestView.class);
        };
        MockInstantiator instantiator = new MockInstantiator(initListener);
        MockVaadinServletService service = new MockVaadinServletService();
        service.init(instantiator);
        VaadinService.setCurrent((VaadinService)service);
        List availableRoutes = RouteConfiguration.forApplicationScope().getAvailableRoutes();
        VaadinService.setCurrent(null);
        Assertions.assertEquals((int)1, (int)availableRoutes.size());
        Assertions.assertEquals((Object)"test", (Object)((RouteData)availableRoutes.get(0)).getTemplate());
    }

    @Test
    public void dependencyFilterOrder_bundeFiltersAfterApplicationFilters() {
        DependencyFilter & Serializable applicationFilter = (DependencyFilter & Serializable)(dependencies, service) -> dependencies;
        MockDeploymentConfiguration configuration = new MockDeploymentConfiguration();
        MockVaadinServletService service2 = new MockVaadinServletService((DeploymentConfiguration)configuration);
        service2.init(new MockInstantiator((VaadinServiceInitListener & Serializable)evt -> evt.addDependencyFilter(applicationFilter)));
        ArrayList filters = new ArrayList();
        service2.getDependencyFilters().forEach(filters::add);
        Assertions.assertEquals((int)1, (int)filters.size());
        Assertions.assertSame((Object)applicationFilter, filters.get(0));
    }

    @Test
    public void loadInstantiators_instantiatorIsLoadedUsingFactoryFromLookup() throws ServiceException {
        MockVaadinServletService service = VaadinServiceTest.createService();
        Lookup lookup = service.getLookup();
        InstantiatorFactory factory = this.createInstantiatorFactory();
        Mockito.when((Object)lookup.lookupAll(InstantiatorFactory.class)).thenReturn(Collections.singletonList(factory));
        Optional loadedInstantiator = service.loadInstantiators();
        Instantiator instantiator = factory.createInstantitor(null);
        Assertions.assertSame((Object)instantiator, loadedInstantiator.get());
    }

    @Test
    public void loadInstantiators_twoFactoriesInLookup_throws() throws ServiceException {
        MockVaadinServletService service = VaadinServiceTest.createService();
        Lookup lookup = service.getLookup();
        InstantiatorFactory factory1 = this.createInstantiatorFactory();
        InstantiatorFactory factory2 = this.createInstantiatorFactory();
        Mockito.when((Object)lookup.lookupAll(InstantiatorFactory.class)).thenReturn(Arrays.asList(factory1, factory2));
        Assertions.assertThrows(ServiceException.class, () -> service.loadInstantiators());
    }

    @Test
    public void createRequestHandlers_pwaHandlerIsInList_webComponentHandlersAreInList() throws ServiceException {
        TestVaadinService service = (TestVaadinService)((Object)Mockito.mock(TestVaadinService.class));
        I18NProvider i18NProvider = (I18NProvider)Mockito.mock(DefaultI18NProvider.class);
        Instantiator instantiator = (Instantiator)Mockito.mock(Instantiator.class);
        Mockito.when((Object)instantiator.getI18NProvider()).thenReturn((Object)i18NProvider);
        Mockito.when((Object)service.getInstantiator()).thenReturn((Object)instantiator);
        ((TestVaadinService)((Object)Mockito.doCallRealMethod().when((Object)service))).createRequestHandlers();
        List<RequestHandler> handlers = service.createRequestHandlers();
        Set set = handlers.stream().map(Object::getClass).collect(Collectors.toSet());
        Assertions.assertTrue((boolean)set.contains(PwaHandler.class));
        Assertions.assertTrue((boolean)set.contains(WebComponentProvider.class));
        Assertions.assertTrue((boolean)set.contains(WebComponentBootstrapHandler.class));
    }

    @Test
    public void fireSessionDestroy_sessionStateIsSetToClosed() {
        MockVaadinServletService service = VaadinServiceTest.createService();
        final AtomicReference stateRef = new AtomicReference();
        MockVaadinSession vaadinSession = new MockVaadinSession((VaadinService)service){

            protected void setState(VaadinSessionState state) {
                stateRef.set(state);
            }
        };
        service.fireSessionDestroy(vaadinSession);
        Assertions.assertEquals((Object)VaadinSessionState.CLOSED, stateRef.get());
    }

    @Test
    public void removeFromHttpSession_setExplicitSessionCloseAttribute() throws ServiceException {
        WrappedSession httpSession = (WrappedSession)Mockito.mock(WrappedSession.class);
        final VaadinSession session = (VaadinSession)Mockito.mock(VaadinSession.class);
        MockVaadinServletService service = new MockVaadinServletService(){

            protected VaadinSession readFromHttpSession(WrappedSession wrappedSession) {
                return session;
            }
        };
        service.init();
        service.removeFromHttpSession(httpSession);
        Assertions.assertTrue((boolean)session.sessionClosedExplicitly);
    }

    @Test
    public void reinitializeSession_setVaadinSessionAttriuteWithLock() {
        VaadinRequest request = (VaadinRequest)Mockito.mock(VaadinRequest.class);
        VaadinSession vaadinSession = (VaadinSession)Mockito.mock(VaadinSession.class);
        VaadinSession newVaadinSession = (VaadinSession)Mockito.mock(VaadinSession.class);
        WrappedSession session = this.mockSession(request, vaadinSession, "foo");
        ((WrappedSession)Mockito.doAnswer(invocation -> {
            this.mockSession(request, newVaadinSession, "bar");
            return null;
        }).when((Object)session)).invalidate();
        VaadinService.reinitializeSession((VaadinRequest)request);
        ((VaadinSession)Mockito.verify((Object)vaadinSession, (VerificationMode)Mockito.times((int)2))).lock();
        ((VaadinSession)Mockito.verify((Object)vaadinSession)).setAttribute(VaadinService.PRESERVE_UNBOUND_SESSION_ATTRIBUTE, (Object)Boolean.TRUE);
        ((VaadinSession)Mockito.verify((Object)vaadinSession)).setAttribute(VaadinService.PRESERVE_UNBOUND_SESSION_ATTRIBUTE, null);
        ((VaadinSession)Mockito.verify((Object)vaadinSession, (VerificationMode)Mockito.times((int)2))).unlock();
    }

    @Test
    public void getExecutor_getsDefaultVaadinExecutor() throws InterruptedException {
        MockVaadinServletService service = VaadinServiceTest.createService();
        Executor executor = service.getExecutor();
        AtomicReference threadName = new AtomicReference();
        Assertions.assertNotNull((Object)executor);
        CountDownLatch latch = new CountDownLatch(1);
        executor.execute(() -> {
            threadName.set(Thread.currentThread().getName());
            latch.countDown();
        });
        latch.await();
        Assertions.assertNotNull(threadName.get(), (String)"Task has not been not executed");
        Assertions.assertTrue((boolean)((String)threadName.get()).startsWith("VaadinTaskExecutor-"), (String)"Task was not executed by Vaadin default executor");
    }

    @Test
    public void serviceDestroy_defaultExecutor_executorStopped() {
        MockVaadinServletService service = VaadinServiceTest.createService();
        Executor executor = service.getExecutor();
        Assertions.assertTrue((boolean)(executor instanceof ExecutorService), (String)"Expected the default executor to be an ExecutorService instance");
        Assertions.assertFalse((boolean)((ExecutorService)executor).isShutdown(), (String)"Expected executor service to be started");
        service.destroy();
        Assertions.assertTrue((boolean)((ExecutorService)executor).isShutdown(), (String)"Expected executor service to be stopped");
    }

    @Test
    public void getExecutor_customExecutorProvided_getsCustomExecutor() throws InterruptedException {
        AtomicBoolean taskSubmitted = new AtomicBoolean(false);
        Executor executor = command -> {
            taskSubmitted.set(true);
            command.run();
        };
        VaadinServiceInitListener & Serializable initListener = (VaadinServiceInitListener & Serializable)event -> event.setExecutor(executor);
        CountDownLatch latch = new CountDownLatch(1);
        MockInstantiator instantiator = new MockInstantiator(initListener);
        MockVaadinServletService service = new MockVaadinServletService(false);
        service.init(instantiator);
        Assertions.assertSame((Object)executor, (Object)service.getExecutor(), (String)"Expected VaadinService to return the custom executor");
        service.getExecutor().execute(latch::countDown);
        latch.await();
        Assertions.assertTrue((boolean)taskSubmitted.get(), (String)"Task should have been submitted to the custom executor");
    }

    @Test
    public void serviceDestroy_customExecutorProvided_executorNotStopped() {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        VaadinServiceInitListener & Serializable initListener = (VaadinServiceInitListener & Serializable)event -> event.setExecutor((Executor)executor);
        MockInstantiator instantiator = new MockInstantiator(initListener);
        MockVaadinServletService service = new MockVaadinServletService(false);
        service.init(instantiator);
        Assertions.assertSame((Object)executor, (Object)service.getExecutor(), (String)"Expected VaadinService to return the custom executor");
        service.destroy();
        Assertions.assertFalse((boolean)executor.isShutdown(), (String)"Expected custom executor not to be stopped");
    }

    @Test
    public void getExecutor_nullExecutorProvided_resetsToDefaultVaadinExecutor() {
        Executor executor = command -> {};
        VaadinServiceInitListener & Serializable setExecutorInitListener = (VaadinServiceInitListener & Serializable)event -> event.setExecutor(executor);
        VaadinServiceInitListener & Serializable resetExecutorInitListener = (VaadinServiceInitListener & Serializable)event -> event.setExecutor(null);
        MockInstantiator instantiator = new MockInstantiator(setExecutorInitListener, resetExecutorInitListener);
        MockVaadinServletService service = new MockVaadinServletService(false);
        service.init(instantiator);
        Assertions.assertNotSame((Object)executor, (Object)service.getExecutor(), (String)"Custom executor should not be used");
    }

    @Test
    public void init_nullExecutor_throws() {
        RuntimeException error = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> new MockVaadinServletService(){

            protected Executor createDefaultExecutor() {
                return null;
            }
        });
        Throwable throwable = error.getCause();
        if (throwable instanceof ServiceException) {
            ServiceException serviceException = (ServiceException)throwable;
            Assertions.assertTrue((boolean)serviceException.getMessage().contains("Unable to create the default Executor"), (String)"Expected VaadinService initialization to fail with null executor");
        } else {
            Assertions.fail((String)"Expected ServiceException to be thrown");
        }
    }

    private WrappedSession mockSession(VaadinRequest request, VaadinSession vaadinSession, String attributeName) {
        WrappedSession session = (WrappedSession)Mockito.mock(WrappedSession.class);
        Mockito.when((Object)request.getWrappedSession()).thenReturn((Object)session);
        Mockito.when((Object)session.getAttributeNames()).thenReturn(Collections.singleton(attributeName));
        Mockito.when((Object)session.getAttribute(attributeName)).thenReturn((Object)vaadinSession);
        VaadinService service = (VaadinService)Mockito.mock(VaadinService.class);
        Mockito.when((Object)vaadinSession.getService()).thenReturn((Object)service);
        return session;
    }

    private InstantiatorFactory createInstantiatorFactory() {
        InstantiatorFactory factory = (InstantiatorFactory)Mockito.mock(InstantiatorFactory.class);
        Instantiator instantiator = (Instantiator)Mockito.mock(Instantiator.class);
        Mockito.when((Object)factory.createInstantitor((VaadinService)ArgumentMatchers.any())).thenReturn((Object)instantiator);
        return factory;
    }

    private static MockVaadinServletService createService() {
        return new MockVaadinServletService();
    }

    private class TestSessionDestroyListener
    implements SessionDestroyListener {
        int callCount = 0;

        private TestSessionDestroyListener() {
        }

        public void sessionDestroy(SessionDestroyEvent event) {
            ++this.callCount;
        }
    }

    private class ThrowingSessionDestroyListener
    implements SessionDestroyListener {
        private ThrowingSessionDestroyListener() {
        }

        public void sessionDestroy(SessionDestroyEvent event) {
            throw new RuntimeException();
        }
    }

    private class ThrowingServiceDestroyListener
    implements ServiceDestroyListener {
        private ThrowingServiceDestroyListener() {
        }

        public void serviceDestroy(ServiceDestroyEvent event) {
            throw new RuntimeException();
        }
    }

    private class TestServiceDestroyListener
    implements ServiceDestroyListener {
        int callCount = 0;

        private TestServiceDestroyListener() {
        }

        public void serviceDestroy(ServiceDestroyEvent event) {
            ++this.callCount;
        }
    }

    private static abstract class TestVaadinService
    extends VaadinService {
        private TestVaadinService() {
        }

        protected List<RequestHandler> createRequestHandlers() throws ServiceException {
            return super.createRequestHandlers();
        }
    }

    @Tag(value="div")
    public static class TestView
    extends Component {
    }

    @Route(value="flow", autoLayout=false)
    @Tag(value="div")
    public static class OptOutAutoLayoutTestView
    extends Component {
    }

    @Route(value="test")
    @Tag(value="div")
    public static class AnnotatedTestView
    extends Component {
    }
}

