/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server;

import com.vaadin.flow.server.CustomizedSystemMessages;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class SystemMessagesTest {
    SystemMessagesTest() {
    }

    @Test
    public void syncError_defaultValues() {
        CustomizedSystemMessages messages = new CustomizedSystemMessages();
        Assertions.assertNull((Object)messages.getSyncErrorURL(), (String)"Default URL should be null");
        Assertions.assertTrue((boolean)messages.isSyncErrorNotificationEnabled(), (String)"Default notification should be enabled");
        Assertions.assertEquals((Object)"Synchronization Error", (Object)messages.getSyncErrorCaption(), (String)"Default caption should match");
        Assertions.assertEquals((Object)"Your session needs to be refreshed. Click here or press ESC to reload and restore your last saved state.", (Object)messages.getSyncErrorMessage(), (String)"Default message should match");
    }

    @Test
    public void syncError_notificationEnabled_returnsCaptionAndMessage() {
        CustomizedSystemMessages messages = new CustomizedSystemMessages();
        Assertions.assertTrue((boolean)messages.isSyncErrorNotificationEnabled());
        Assertions.assertNotNull((Object)messages.getSyncErrorCaption());
        Assertions.assertNotNull((Object)messages.getSyncErrorMessage());
    }

    @Test
    public void customizedSyncError_notificationDisabled_returnsNullCaptionAndMessage() {
        CustomizedSystemMessages messages = new CustomizedSystemMessages();
        messages.setSyncErrorNotificationEnabled(false);
        messages.setSyncErrorCaption("Custom Caption");
        messages.setSyncErrorMessage("Custom message text");
        Assertions.assertFalse((boolean)messages.isSyncErrorNotificationEnabled(), (String)"Notification should be disabled");
        Assertions.assertNull((Object)messages.getSyncErrorCaption(), (String)"Caption should be null when notification is disabled");
        Assertions.assertNull((Object)messages.getSyncErrorMessage(), (String)"Message should be null when notification is disabled");
    }

    @Test
    public void customizedSyncError_urlNotAffectedByNotificationEnabled() {
        CustomizedSystemMessages messages = new CustomizedSystemMessages();
        messages.setSyncErrorURL("/redirect-url");
        messages.setSyncErrorNotificationEnabled(false);
        Assertions.assertEquals((Object)"/redirect-url", (Object)messages.getSyncErrorURL());
    }
}

