/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server;

import com.vaadin.flow.server.Platform;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.LinkedList;
import java.util.Optional;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

class PlatformTest {
    private ClassLoader oldContextClassLoader;
    @TempDir
    Path temporary;

    PlatformTest() {
    }

    @BeforeEach
    public void rememberContextClassLoader() {
        this.oldContextClassLoader = Thread.currentThread().getContextClassLoader();
    }

    @AfterEach
    public void restoreContextClassLoader() {
        Thread.currentThread().setContextClassLoader(this.oldContextClassLoader);
    }

    @BeforeEach
    @AfterEach
    public void cleanMemoizedValues() {
        Platform.hillaVersion = null;
        Platform.vaadinVersion = null;
    }

    private void fakeVaadinHilla(String vaadinVersion, String hillaVersion) throws IOException {
        Path pomProperties;
        Platform.hillaVersion = null;
        Platform.vaadinVersion = null;
        LinkedList<URL> classPath = new LinkedList<URL>();
        if (hillaVersion != null) {
            Path hillaJar = Files.createTempDirectory(this.temporary, "temp", new FileAttribute[0]).toFile().toPath();
            pomProperties = hillaJar.resolve("META-INF/maven/com.vaadin/hilla/pom.properties");
            Files.createDirectories(pomProperties.getParent(), new FileAttribute[0]);
            Files.writeString(pomProperties, (CharSequence)("version=" + hillaVersion), new OpenOption[0]);
            classPath.add(hillaJar.toUri().toURL());
        }
        if (vaadinVersion != null) {
            Path vaadinJar = Files.createTempDirectory(this.temporary, "temp", new FileAttribute[0]).toFile().toPath();
            pomProperties = vaadinJar.resolve("META-INF/maven/com.vaadin/vaadin-core/pom.properties");
            Files.createDirectories(pomProperties.getParent(), new FileAttribute[0]);
            Files.writeString(pomProperties, (CharSequence)("version=" + vaadinVersion), new OpenOption[0]);
            classPath.add(vaadinJar.toUri().toURL());
        }
        if (classPath.isEmpty()) {
            Thread.currentThread().setContextClassLoader(this.oldContextClassLoader);
        } else {
            URLClassLoader classLoader = new URLClassLoader(classPath.toArray(new URL[0]), null);
            Thread.currentThread().setContextClassLoader(classLoader);
        }
    }

    @Test
    public void testGetVaadinVersionReturnsEmptyOptionalWhenVaadinNotOnClasspath() {
        Assertions.assertEquals(Optional.empty(), (Object)Platform.getVaadinVersion());
    }

    @Test
    public void testGetVaadinVersionReturnsProperVersionWhenVaadinOnClasspath() throws Exception {
        this.fakeVaadinHilla("24.1.0", null);
        Assertions.assertEquals(Optional.of("24.1.0"), (Object)Platform.getVaadinVersion());
        Assertions.assertEquals(Optional.empty(), (Object)Platform.getHillaVersion());
        this.fakeVaadinHilla("24.1.1", null);
        Assertions.assertEquals(Optional.of("24.1.1"), (Object)Platform.getVaadinVersion());
        Assertions.assertEquals(Optional.empty(), (Object)Platform.getHillaVersion());
    }

    @Test
    public void testGetHillaVersionReturnsEmptyOptionalWhenHillaNotOnClasspath() {
        Assertions.assertEquals(Optional.empty(), (Object)Platform.getHillaVersion());
    }

    @Test
    public void testGetHillaVersionReturnsProperVersionWhenHillaOnClasspath() throws Exception {
        this.fakeVaadinHilla(null, "2.1.0");
        Assertions.assertEquals(Optional.of("2.1.0"), (Object)Platform.getHillaVersion());
        Assertions.assertEquals(Optional.empty(), (Object)Platform.getVaadinVersion());
        this.fakeVaadinHilla(null, "2.0.6");
        Assertions.assertEquals(Optional.of("2.0.6"), (Object)Platform.getHillaVersion());
        Assertions.assertEquals(Optional.empty(), (Object)Platform.getVaadinVersion());
    }

    @Test
    public void testGetVaadinHillaVersionReturnsProperVersionWhenBothVaadinAndHillaOnClasspath() throws Exception {
        this.fakeVaadinHilla("24.0.0", "2.1.0");
        Assertions.assertEquals(Optional.of("2.1.0"), (Object)Platform.getHillaVersion());
        Assertions.assertEquals(Optional.of("24.0.0"), (Object)Platform.getVaadinVersion());
        this.fakeVaadinHilla("24.1.1", "2.0.6");
        Assertions.assertEquals(Optional.of("2.0.6"), (Object)Platform.getHillaVersion());
        Assertions.assertEquals(Optional.of("24.1.1"), (Object)Platform.getVaadinVersion());
    }
}

