/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server;

import com.vaadin.flow.server.HttpStatusCode;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class HttpStatusCodeTest {
    HttpStatusCodeTest() {
    }

    @Test
    public void isValidStatusCode_invalidCode_returnsFalse() {
        Set validCodes = Stream.of(HttpStatusCode.values()).map(HttpStatusCode::getCode).collect(Collectors.toSet());
        IntStream.rangeClosed(-1000, 1000).filter(sc -> !validCodes.contains(sc)).forEach(sc -> Assertions.assertFalse((boolean)HttpStatusCode.isValidStatusCode((int)sc), (String)(sc + " should be invalid, but was not")));
    }

    @Test
    public void isValidStatusCode_validCode_returnsTrue() {
        Stream.of(HttpStatusCode.values()).mapToInt(HttpStatusCode::getCode).forEach(sc -> Assertions.assertTrue((boolean)HttpStatusCode.isValidStatusCode((int)sc), (String)(sc + " should be valid, but was not")));
    }
}

