/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.router.internal;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.router.RouteParam;
import com.vaadin.flow.router.RouteParameterFormatOption;
import com.vaadin.flow.router.RouteParameters;
import com.vaadin.flow.router.RouterLayout;
import com.vaadin.flow.router.internal.ConfigureRoutes;
import com.vaadin.flow.router.internal.ConfiguredRoutes;
import com.vaadin.flow.router.internal.RouteFormat;
import java.util.Arrays;
import java.util.EnumSet;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ConfiguredRoutesTest {
    ConfiguredRoutesTest() {
    }

    @Test
    public void emptyConfiguration_allGetMethodsWork() {
        ConfiguredRoutes configuration = new ConfiguredRoutes();
        Assertions.assertFalse((boolean)configuration.hasTemplate(""), (String)"No routes should be configured");
        Assertions.assertFalse((boolean)configuration.getTarget("").isPresent(), (String)"No routes should be configured");
        Assertions.assertTrue((boolean)configuration.getRoutes().isEmpty(), (String)"Configuration should be empty");
        Assertions.assertTrue((boolean)configuration.getTargetRoutes().isEmpty(), (String)"Configuration should be empty");
        Assertions.assertNull((Object)configuration.getExceptionHandlerByClass(RuntimeException.class), (String)"No exception handler should be found.");
        Assertions.assertNull((Object)configuration.getTemplate(BaseTarget.class), (String)"No target route should be found");
        Assertions.assertTrue((boolean)configuration.getExceptionHandlers().isEmpty(), (String)"Configuration should be empty");
        Assertions.assertFalse((boolean)configuration.hasRouteTarget(BaseTarget.class), (String)"No route should be found");
    }

    @Test
    public void mutableConfiguration_makingImmutableHasCorrectData() {
        ConfigureRoutes mutable = new ConfigureRoutes();
        mutable.setRoute("", BaseTarget.class, Arrays.asList(SecondParentTarget.class, ParentTarget.class));
        ConfiguredRoutes immutable = new ConfiguredRoutes(mutable);
        Assertions.assertTrue((boolean)immutable.hasTemplate(""), (String)"Configuration should have \"\" route registered");
        Assertions.assertEquals(BaseTarget.class, immutable.getTarget("").get(), (String)"Configuration should have registered base target.");
        Assertions.assertTrue((boolean)immutable.hasRouteTarget(BaseTarget.class), (String)"BaseTarget registration should have been copied over");
        Assertions.assertEquals((Object)"", (Object)immutable.getTemplate(BaseTarget.class), (String)"Configuration should have registered base target.");
        Assertions.assertEquals(Arrays.asList(SecondParentTarget.class, ParentTarget.class), (Object)immutable.getNavigationRouteTarget("").getRouteTarget().getParentLayouts(), (String)"Given parentLayouts should have been copied correctly");
    }

    @Test
    public void configuration_provides_target_url() {
        ConfigureRoutes edit = new ConfigureRoutes();
        edit.setRoute("foo/:foo", FooTarget.class);
        edit.setRoute("foo/:foo(qwe)", FooTarget.class);
        edit.setRoute("foo/:foo/bar?(asd)", FooTarget.class);
        edit.setRoute(":foo/:bar?(asd)", FooTarget.class);
        edit.setRoute("foo/:foo/:bar*(asd)", FooTarget.class);
        edit.setRoute("foo/:foo(qwe)/:bar*(asd)", FooTarget.class);
        edit.setRoute("foo/foobar?/:foo(qwe)/:bar*(asd)", FooTarget.class);
        edit.setRoute("foo/foobar?/:foo(qwe)", FooTarget.class);
        edit.setRoute("foo/foobar?/:foo", FooTarget.class);
        edit.setRoute("bar/:bar?", BarTarget.class);
        edit.setRoute("bar/:bar?/foobar", BarTarget.class);
        edit.setRoute("bar/:bar?(qwe)", BarTarget.class);
        edit.setRoute("bar/:bar?(qwe)/:foo*(asd)", BarTarget.class);
        edit.setRoute("bar/:bar?/:foo*", BarTarget.class);
        edit.setRoute(":bar?/:foo*", BarTarget.class);
        edit.setRoute(":bar?/foobar/:foo*", BarTarget.class);
        ConfiguredRoutes config = new ConfiguredRoutes(edit);
        Assertions.assertNull((Object)config.getTargetUrl(FooTarget.class));
        Assertions.assertEquals((Object)"bar", (Object)config.getTargetUrl(BarTarget.class));
        config.getRouteModel().getRoutes().entrySet().forEach(stringRouteTargetEntry -> {
            boolean requiredParameter = RouteFormat.hasRequiredParameter((String)((String)stringRouteTargetEntry.getKey()));
            Assertions.assertEquals((Object)((com.vaadin.flow.router.internal.RouteTarget)stringRouteTargetEntry.getValue()).getTarget().equals(FooTarget.class), (Object)requiredParameter);
        });
    }

    @Test
    public void configuration_provides_formatted_url_template() {
        ConfigureRoutes config = new ConfigureRoutes();
        String template = "/path/to/:intType(^[-+]?\\d+$)/:longType?(^[+-]?[0-9]{1,19}$)/:stringType?/:varargs*(thinking|of|U|and|I)";
        config.setRoute("/path/to/:intType(^[-+]?\\d+$)/:longType?(^[+-]?[0-9]{1,19}$)/:stringType?/:varargs*(thinking|of|U|and|I)", BaseTarget.class);
        Assertions.assertFalse((boolean)"/path/to/:intType(^[-+]?\\d+$)/:longType?(^[+-]?[0-9]{1,19}$)/:stringType?/:varargs*(thinking|of|U|and|I)".equals(config.getTemplate(BaseTarget.class)), (String)"Template should not contain prefixed forward slash '/'");
        Assertions.assertEquals((Object)"/path/to/:intType(^[-+]?\\d+$)/:longType?(^[+-]?[0-9]{1,19}$)/:stringType?/:varargs*(thinking|of|U|and|I)".substring(1), (Object)config.getTemplate(BaseTarget.class), (String)"Invalid template");
        Assertions.assertEquals((Object)"path/to/:intType(integer)/:longType?(long)/:stringType?(string)/:varargs*(string)", (Object)config.getTemplate(BaseTarget.class, EnumSet.of(RouteParameterFormatOption.NAME, RouteParameterFormatOption.MODIFIER, RouteParameterFormatOption.REGEX_NAME)), (String)"Invalid formatted template");
        Assertions.assertEquals((Object)"path/to/:intType/:longType?/:stringType?/:varargs*", (Object)config.getTemplate(BaseTarget.class, EnumSet.of(RouteParameterFormatOption.NAME, RouteParameterFormatOption.MODIFIER)), (String)"Invalid formatted template");
        Assertions.assertEquals((Object)"path/to/:intType/:longType/:stringType/:varargs", (Object)config.getTemplate(BaseTarget.class, EnumSet.of(RouteParameterFormatOption.NAME)), (String)"Invalid formatted template");
        Assertions.assertEquals((Object)"path/to/:(integer)/:?(long)/:?(string)/:*(string)", (Object)config.getTemplate(BaseTarget.class, EnumSet.of(RouteParameterFormatOption.MODIFIER, RouteParameterFormatOption.REGEX_NAME)), (String)"Invalid formatted template");
        Assertions.assertEquals((Object)"path/to/:(^[-+]?\\d+$)/:?(^[+-]?[0-9]{1,19}$)/:?/:*(thinking|of|U|and|I)", (Object)config.getTemplate(BaseTarget.class, EnumSet.of(RouteParameterFormatOption.MODIFIER, RouteParameterFormatOption.REGEX)), (String)"Invalid formatted template");
        Assertions.assertEquals((Object)"path/to/:integer/:long/:string/:string", (Object)config.getTemplate(BaseTarget.class, EnumSet.of(RouteParameterFormatOption.REGEX_NAME)), (String)"Invalid formatted template");
        Assertions.assertEquals((Object)"path/to/:/:?/:?/:*", (Object)config.getTemplate(BaseTarget.class, EnumSet.of(RouteParameterFormatOption.MODIFIER)), (String)"Invalid formatted template");
        Assertions.assertEquals((Object)"path/to/:^[-+]?\\d+$/:^[+-]?[0-9]{1,19}$/:/:thinking|of|U|and|I", (Object)config.getTemplate(BaseTarget.class, EnumSet.of(RouteParameterFormatOption.REGEX)), (String)"Invalid formatted template");
    }

    @Test
    public void configuration_provides_formatted_url_for_route_not_routeAlias() {
        ConfigureRoutes config = new ConfigureRoutes();
        config.setRoute(RouteTarget.class.getAnnotation(Route.class).value(), RouteTarget.class);
        config.setRoute("", RouteTarget.class);
        String targetUrl = config.getTargetUrl(RouteTarget.class, new RouteParameters(new RouteParam[]{new RouteParam("message", "hello")}));
        Assertions.assertEquals((Object)"home/hello", (Object)targetUrl, (String)"Route should be matched and not RouteAlias");
    }

    @Tag(value="div")
    public static class BaseTarget
    extends Component {
    }

    @Tag(value="div")
    public static class SecondParentTarget
    extends Component
    implements RouterLayout {
    }

    @Tag(value="div")
    public static class ParentTarget
    extends Component
    implements RouterLayout {
    }

    @Tag(value="div")
    public static class FooTarget
    extends Component {
    }

    @Tag(value="div")
    public static class BarTarget
    extends Component {
    }

    @Tag(value="div")
    @Route(value="/home/:message?")
    public static class RouteTarget
    extends Component {
    }
}

