/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.router;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.function.DeploymentConfiguration;
import com.vaadin.flow.internal.HasCurrentService;
import com.vaadin.flow.router.AfterNavigationEvent;
import com.vaadin.flow.router.BeforeEvent;
import com.vaadin.flow.router.HasUrlParameter;
import com.vaadin.flow.router.HighlightActions;
import com.vaadin.flow.router.HighlightConditions;
import com.vaadin.flow.router.Location;
import com.vaadin.flow.router.LocationChangeEvent;
import com.vaadin.flow.router.NavigationTrigger;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.QueryParameters;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.router.RouteAlias;
import com.vaadin.flow.router.RouteConfiguration;
import com.vaadin.flow.router.RouteParameters;
import com.vaadin.flow.router.Router;
import com.vaadin.flow.router.RouterLink;
import com.vaadin.flow.router.RoutingTestBase;
import com.vaadin.flow.router.TestRouteRegistry;
import com.vaadin.flow.router.internal.HasUrlParameterFormat;
import com.vaadin.flow.server.Command;
import com.vaadin.flow.server.InvalidRouteConfigurationException;
import com.vaadin.flow.server.RouteRegistry;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.startup.ApplicationRouteRegistry;
import java.io.File;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import net.jcip.annotations.NotThreadSafe;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

@NotThreadSafe
class RouterLinkTest
extends HasCurrentService {
    private ApplicationRouteRegistry registry;
    private Router router;
    private UI ui;

    RouterLinkTest() {
    }

    @BeforeEach
    public void setUp() throws NoSuchFieldException, IllegalAccessException, InvalidRouteConfigurationException {
        VaadinService service = VaadinService.getCurrent();
        DeploymentConfiguration config = (DeploymentConfiguration)Mockito.mock(DeploymentConfiguration.class);
        Mockito.when((Object)config.getFrontendFolder()).thenReturn((Object)new File("/frontend"));
        Mockito.when((Object)service.getDeploymentConfiguration()).thenReturn((Object)config);
        this.registry = new TestRouteRegistry();
        RouteConfiguration routeConfiguration = RouteConfiguration.forRegistry((RouteRegistry)this.registry);
        routeConfiguration.update((Command & Serializable)() -> {
            routeConfiguration.getHandledRegistry().clean();
            Arrays.asList(TestView.class, FooNavigationTarget.class, ParameterNavigationTarget.class, GreetingNavigationTarget.class).forEach(arg_0 -> ((RouteConfiguration)routeConfiguration).setAnnotatedRoute(arg_0));
        });
        this.router = new Router((RouteRegistry)this.registry);
        this.ui = new RoutingTestBase.RouterTestUI(this.router);
        Mockito.when((Object)service.getRouter()).thenReturn((Object)this.router);
    }

    @Test
    public void createRouterLink_implicitCurrentVaadinServiceRouter() {
        RouterLink link = new RouterLink("Show something", TestView.class, (Object)"something");
        Assertions.assertEquals((Object)"Show something", (Object)link.getText());
        Assertions.assertTrue((boolean)link.getElement().hasAttribute("router-link"));
        Assertions.assertTrue((boolean)link.getElement().hasAttribute("href"));
        Assertions.assertEquals((Object)"bar/something", (Object)link.getElement().getAttribute("href"));
    }

    @Test
    public void setRoute_attachedLink() {
        UI ui = new UI();
        RouterLink link = new RouterLink();
        ui.add(new Component[]{link});
        link.setRoute(this.router, TestView.class, (Object)"foo");
        Assertions.assertTrue((boolean)link.getElement().hasAttribute("href"));
        Assertions.assertEquals((Object)"bar/foo", (Object)link.getElement().getAttribute("href"));
    }

    @Test
    public void setRoute_withoutRouter() {
        RouterLink link = new RouterLink();
        this.ui.add(new Component[]{link});
        link.setRoute(FooNavigationTarget.class);
        Assertions.assertTrue((boolean)link.getElement().hasAttribute("href"));
        Assertions.assertEquals((Object)"foo", (Object)link.getElement().getAttribute("href"));
    }

    @Test
    public void setRoute_withoutRouterWithParameter() {
        RouterLink link = new RouterLink();
        this.ui.add(new Component[]{link});
        link.setRoute(GreetingNavigationTarget.class, (Object)"foo");
        Assertions.assertTrue((boolean)link.getElement().hasAttribute("href"));
        Assertions.assertEquals((Object)"greeting/foo", (Object)link.getElement().getAttribute("href"));
    }

    @Test
    public void createRouterLink_explicitRouter() {
        RouterLink link = new RouterLink(this.router, "Show something", TestView.class, (Object)"something");
        Assertions.assertEquals((Object)"Show something", (Object)link.getText());
        Assertions.assertTrue((boolean)link.getElement().hasAttribute("router-link"));
        Assertions.assertTrue((boolean)link.getElement().hasAttribute("href"));
        Assertions.assertEquals((Object)"bar/something", (Object)link.getElement().getAttribute("href"));
    }

    @Test
    public void createRouterLink_withTargetViewNoText() {
        RouterLink link = new RouterLink(FooNavigationTarget.class);
        Assertions.assertEquals((Object)"", (Object)link.getText());
        Assertions.assertTrue((boolean)link.getElement().hasAttribute("router-link"));
        Assertions.assertTrue((boolean)link.getElement().hasAttribute("href"));
        Assertions.assertEquals((Object)"foo", (Object)link.getElement().getAttribute("href"));
    }

    @Test
    public void createRouterLink_withTargetViewWithParameterNoText() {
        RouterLink link = new RouterLink(TestView.class, (Object)"something");
        Assertions.assertEquals((Object)"", (Object)link.getText());
        Assertions.assertTrue((boolean)link.getElement().hasAttribute("router-link"));
        Assertions.assertTrue((boolean)link.getElement().hasAttribute("href"));
        Assertions.assertEquals((Object)"bar/something", (Object)link.getElement().getAttribute("href"));
    }

    @Test
    public void createRouterLink_withTargetViewWithRouteParametersNoText() {
        RouteParameters routeParameters = HasUrlParameterFormat.getParameters((Object)"something");
        RouterLink link = new RouterLink(TestView.class, routeParameters);
        Assertions.assertEquals((Object)"", (Object)link.getText());
        Assertions.assertTrue((boolean)link.getElement().hasAttribute("router-link"));
        Assertions.assertTrue((boolean)link.getElement().hasAttribute("href"));
        Assertions.assertEquals((Object)"bar/something", (Object)link.getElement().getAttribute("href"));
    }

    @Test
    public void createRouterLink_explicitRouterWithTargetViewNoText() {
        RouterLink link = new RouterLink(this.router, FooNavigationTarget.class);
        Assertions.assertEquals((Object)"", (Object)link.getText());
        Assertions.assertTrue((boolean)link.getElement().hasAttribute("router-link"));
        Assertions.assertTrue((boolean)link.getElement().hasAttribute("href"));
        Assertions.assertEquals((Object)"foo", (Object)link.getElement().getAttribute("href"));
    }

    @Test
    public void createRouterLink_explicitRouterWithTargetViewWithParameterNoText() {
        RouterLink link = new RouterLink(this.router, TestView.class, (Object)"something");
        Assertions.assertEquals((Object)"", (Object)link.getText());
        Assertions.assertTrue((boolean)link.getElement().hasAttribute("router-link"));
        Assertions.assertTrue((boolean)link.getElement().hasAttribute("href"));
        Assertions.assertEquals((Object)"bar/something", (Object)link.getElement().getAttribute("href"));
    }

    @Test
    public void createRouterLink_explicitRouterWithTargetViewWithRouteParametersNoText() {
        RouteParameters routeParameters = HasUrlParameterFormat.getParameters((Object)"something");
        RouterLink link = new RouterLink(this.router, TestView.class, routeParameters);
        Assertions.assertEquals((Object)"", (Object)link.getText());
        Assertions.assertTrue((boolean)link.getElement().hasAttribute("router-link"));
        Assertions.assertTrue((boolean)link.getElement().hasAttribute("href"));
        Assertions.assertEquals((Object)"bar/something", (Object)link.getElement().getAttribute("href"));
    }

    @Test
    public void createReconfigureRouterLink_implicitCurrentVaadinServiceRouter() {
        RouterLink link = new RouterLink("Show something", TestView.class, (Object)"something");
        link.setRoute(this.router, TestView.class, (Object)"other");
        Assertions.assertEquals((Object)"bar/other", (Object)link.getElement().getAttribute("href"));
        link.setRoute(this.router, TestView.class, (Object)"changed");
        Assertions.assertEquals((Object)"bar/changed", (Object)link.getElement().getAttribute("href"));
    }

    @Test
    public void createReconfigureRouterLink_explicitRouter() {
        RouterLink link = new RouterLink(this.router, "Show something", TestView.class, (Object)"something");
        link.setRoute(this.router, TestView.class, (Object)"other");
        Assertions.assertEquals((Object)"bar/other", (Object)link.getElement().getAttribute("href"));
        link.setRoute(this.router, TestView.class, (Object)"changed");
        Assertions.assertEquals((Object)"bar/changed", (Object)link.getElement().getAttribute("href"));
    }

    @Test
    public void reconfigureRouterLink_attachedLink() {
        RouterLink link = new RouterLink();
        this.ui.add(new Component[]{link});
        link.setRoute(this.router, TestView.class, (Object)"other");
        Assertions.assertEquals((Object)"bar/other", (Object)link.getElement().getAttribute("href"));
        link.setRoute(this.router, TestView.class, (Object)"changed");
        Assertions.assertEquals((Object)"bar/changed", (Object)link.getElement().getAttribute("href"));
    }

    @Test
    public void noImplicitRouter() {
        VaadinService service = VaadinService.getCurrent();
        Mockito.when((Object)service.getRouter()).thenReturn(null);
        Assertions.assertThrows(IllegalStateException.class, () -> new RouterLink("Show something", TestView.class));
    }

    @Test
    public void routerLink_withoutRouter_WithRouteParameters() {
        this.assertRouterLinkRouteParameters(false);
    }

    @Test
    public void routerLink_WithRouteParameters() {
        this.assertRouterLinkRouteParameters(true);
    }

    private void assertRouterLinkRouteParameters(boolean useUI) {
        RouterLink link = new RouterLink("Foo", ParameterNavigationTarget.class, new RouteParameters("barId", "barValue"));
        if (useUI) {
            this.ui.add(new Component[]{link});
        }
        Assertions.assertEquals((Object)"foo/barValue/bar", (Object)link.getElement().getAttribute("href"));
        this.assertRouterLinkSetRoute(link, ParameterNavigationTarget.class, new RouteParameters("fooId", "123"), "foo/123/foo");
        this.assertRouterLinkSetRoute(link, ParameterNavigationTarget.class, new RouteParameters("foos", "123/qwe"), "foo/123/qwe");
        try {
            link.setRoute(ParameterNavigationTarget.class, new RouteParameters("fooId", "qwe"));
            Assertions.fail((String)"Route is not registered.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void assertRouterLinkSetRoute(RouterLink link, Class<? extends Component> target, RouteParameters parameters, String url) {
        link.setRoute(target, parameters);
        Assertions.assertEquals((Object)url, (Object)link.getElement().getAttribute("href"));
    }

    private void triggerNavigationEvent(Router router, RouterLink link, String location) {
        AfterNavigationEvent event = new AfterNavigationEvent(new LocationChangeEvent(router, new UI(), NavigationTrigger.ROUTER_LINK, new Location(location), Collections.emptyList()));
        link.afterNavigation(event);
    }

    @Override
    protected VaadinService createService() {
        return (VaadinService)Mockito.mock(VaadinService.class);
    }

    @Test
    public void routerLinkCreationForNormalRouteTarget() throws InvalidRouteConfigurationException {
        RouterLink link = new RouterLink(this.router, "Foo", FooNavigationTarget.class);
        Assertions.assertEquals((Object)"foo", (Object)link.getHref());
    }

    @Test
    public void routerLinkCreationForUrlParameterRouteTarget() throws InvalidRouteConfigurationException {
        RouterLink link = new RouterLink(this.router, "Greeting", GreetingNavigationTarget.class, (Object)"hello");
        Assertions.assertEquals((Object)"greeting/hello", (Object)link.getHref());
    }

    @Test
    public void routerLinkDefaultHighlightCondition() throws InvalidRouteConfigurationException {
        RouterLink link = new RouterLink(this.router, "Foo", FooNavigationTarget.class);
        this.triggerNavigationEvent(this.router, link, "foo/bar");
        Assertions.assertTrue((boolean)link.getElement().hasAttribute("highlight"));
        this.triggerNavigationEvent(this.router, link, "baz");
        Assertions.assertFalse((boolean)link.getElement().hasAttribute("highlight"));
    }

    @Test
    public void routerLinkSameLocationHighlightCondition() throws InvalidRouteConfigurationException {
        RouterLink link = new RouterLink(this.router, "Foo", FooNavigationTarget.class);
        link.setHighlightCondition(HighlightConditions.sameLocation());
        this.triggerNavigationEvent(this.router, link, "foo/bar");
        Assertions.assertFalse((boolean)link.getElement().hasAttribute("highlight"));
        this.triggerNavigationEvent(this.router, link, "foo");
        Assertions.assertTrue((boolean)link.getElement().hasAttribute("highlight"));
    }

    @Test
    public void routerLinkLocationPrefixHighlightCondition() throws InvalidRouteConfigurationException {
        RouterLink link = new RouterLink(this.router, "Foo", FooNavigationTarget.class);
        link.setHighlightCondition(HighlightConditions.locationPrefix((String)"foo/ba"));
        this.triggerNavigationEvent(this.router, link, "foo/bar");
        Assertions.assertTrue((boolean)link.getElement().hasAttribute("highlight"));
        this.triggerNavigationEvent(this.router, link, "foo/baz");
        Assertions.assertTrue((boolean)link.getElement().hasAttribute("highlight"));
        this.triggerNavigationEvent(this.router, link, "foo/qux");
        Assertions.assertFalse((boolean)link.getElement().hasAttribute("highlight"));
    }

    @Test
    public void routerLinkClearOldHighlightAction() throws InvalidRouteConfigurationException {
        RouterLink link = new RouterLink(this.router, "Foo", FooNavigationTarget.class);
        this.triggerNavigationEvent(this.router, link, "foo/bar");
        link.setHighlightAction(HighlightActions.toggleClassName((String)"highlight"));
        this.triggerNavigationEvent(this.router, link, "foo/bar/baz");
        Assertions.assertFalse((boolean)link.getElement().hasAttribute("highlight"));
    }

    @Test
    public void routerLinkClassNameHightlightAction() throws InvalidRouteConfigurationException {
        RouterLink link = new RouterLink(this.router, "Foo", FooNavigationTarget.class);
        link.setHighlightAction(HighlightActions.toggleClassName((String)"highlight"));
        this.triggerNavigationEvent(this.router, link, "foo/bar");
        Assertions.assertTrue((boolean)link.hasClassName("highlight"));
        this.triggerNavigationEvent(this.router, link, "bar");
        Assertions.assertFalse((boolean)link.hasClassName("highlight"));
    }

    @Test
    public void routerLinkThemeHightlightAction() throws InvalidRouteConfigurationException {
        RouterLink link = new RouterLink(this.router, "Foo", FooNavigationTarget.class);
        link.setHighlightAction(HighlightActions.toggleTheme((String)"highlight"));
        this.triggerNavigationEvent(this.router, link, "foo/bar");
        Assertions.assertTrue((boolean)link.getElement().getThemeList().contains((Object)"highlight"));
        this.triggerNavigationEvent(this.router, link, "bar");
        Assertions.assertFalse((boolean)link.getElement().getThemeList().contains((Object)"highlight"));
    }

    @Test
    public void routerLinkQueryParameters() throws InvalidRouteConfigurationException {
        RouterLink link = new RouterLink(this.router, "Foo", FooNavigationTarget.class);
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("foo", "bar");
        QueryParameters params = QueryParameters.simple(paramMap);
        link.setQueryParameters(params);
        String href = link.getHref();
        Assertions.assertEquals((Object)"foo?foo=bar", (Object)href);
        link.setQueryParameters(null);
        href = link.getHref();
        Assertions.assertEquals((Object)"foo", (Object)href);
        link.setQueryParameters(QueryParameters.empty());
        href = link.getHref();
        Assertions.assertEquals((Object)"foo", (Object)href);
    }

    @Test
    public void routerLinkToNotRouterTarget_throwsIAE() {
        IllegalArgumentException ex = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> new RouterLink("", Foo.class));
    }

    @Tag(value="div")
    @Route(value="bar")
    public static class TestView
    extends Component
    implements HasUrlParameter<String> {
        public void setParameter(BeforeEvent event, String parameter) {
        }
    }

    @Route(value="foo")
    @Tag(value="div")
    public static class FooNavigationTarget
    extends Component {
    }

    @Route(value="greeting")
    @PageTitle(value="Custom Title")
    @Tag(value="div")
    public static class GreetingNavigationTarget
    extends Component
    implements HasUrlParameter<String> {
        public void setParameter(BeforeEvent event, String parameter) {
        }
    }

    @Route(value="foo/:barId?/bar")
    @RouteAlias.Container(value={@RouteAlias(value="foo/:fooId(^[-+]?\\d+$)/foo"), @RouteAlias(value="foo/:foos*")})
    @Tag(value="div")
    public static class ParameterNavigationTarget
    extends Component {
    }

    @Tag(value="div")
    public static class Foo
    extends Component {
    }
}

