/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal.nodefeature;

import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.internal.nodefeature.ElementData;
import java.io.Serializable;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class VisibilityDataTest {
    VisibilityDataTest() {
    }

    @Test
    void setVisible() {
        StateNode node = new StateNode(new Class[]{ElementData.class});
        ElementData data = (ElementData)node.getFeature(ElementData.class);
        Assertions.assertNull((Object)data.get("visible"));
        Assertions.assertTrue((boolean)data.isVisible());
        data.put("visible", (Serializable)Boolean.valueOf(true));
        Assertions.assertTrue((boolean)data.isVisible());
        data.put("visible", (Serializable)Boolean.valueOf(false));
        Assertions.assertFalse((boolean)data.isVisible());
    }

    @Test
    void allowsChanges_delegateToIsVisible() {
        ElementData data = (ElementData)Mockito.mock(ElementData.class);
        ((ElementData)Mockito.doCallRealMethod().when((Object)data)).allowsChanges();
        Mockito.when((Object)data.isVisible()).thenReturn((Object)true);
        Assertions.assertTrue((boolean)data.allowsChanges());
        Mockito.when((Object)data.isVisible()).thenReturn((Object)false);
        Assertions.assertFalse((boolean)data.allowsChanges());
    }
}

