/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal.nodefeature;

import com.vaadin.flow.dom.ChildElementConsumer;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.Node;
import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.internal.nodefeature.AttachExistingElementFeature;
import java.util.ArrayList;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class AttachExistingElementFeatureTest {
    AttachExistingElementFeatureTest() {
    }

    @Test
    void register_dataIsAvailaleByNode() {
        StateNode node = new StateNode(new Class[0]);
        AttachExistingElementFeature feature = new AttachExistingElementFeature(node);
        Element element = (Element)Mockito.mock(Element.class);
        StateNode child = (StateNode)Mockito.mock(StateNode.class);
        ChildElementConsumer callback = (ChildElementConsumer)Mockito.mock(ChildElementConsumer.class);
        Node parent = (Node)Mockito.mock(Node.class);
        feature.register(parent, element, child, callback);
        ((StateNode)Mockito.verify((Object)child)).setParent(node);
        Assertions.assertEquals((Object)callback, (Object)feature.getCallback(child));
        Assertions.assertEquals((Object)parent, (Object)feature.getParent(child));
        Assertions.assertEquals((Object)element, (Object)feature.getPreviousSibling(child));
    }

    @Test
    void forEachChild_register_registeredStatNodeIsAChild() {
        StateNode node = new StateNode(new Class[0]);
        AttachExistingElementFeature feature = new AttachExistingElementFeature(node);
        Element element = (Element)Mockito.mock(Element.class);
        StateNode child = (StateNode)Mockito.mock(StateNode.class);
        ChildElementConsumer callback = (ChildElementConsumer)Mockito.mock(ChildElementConsumer.class);
        Node parent = (Node)Mockito.mock(Node.class);
        feature.register(parent, element, child, callback);
        ArrayList children = new ArrayList(1);
        feature.forEachChild(children::add);
        Assertions.assertEquals((int)1, (int)children.size());
        Assertions.assertEquals((Object)child, children.get(0));
    }

    @Test
    void unregister_dataIsNotAvailaleByNode() {
        StateNode node = new StateNode(new Class[0]);
        AttachExistingElementFeature feature = new AttachExistingElementFeature(node);
        Element element = (Element)Mockito.mock(Element.class);
        StateNode child = (StateNode)Mockito.mock(StateNode.class);
        ChildElementConsumer callback = (ChildElementConsumer)Mockito.mock(ChildElementConsumer.class);
        Node parent = (Node)Mockito.mock(Node.class);
        feature.register(parent, element, child, callback);
        feature.unregister(child);
        Assertions.assertNull((Object)feature.getCallback(child));
        Assertions.assertNull((Object)feature.getParent(child));
        Assertions.assertNull((Object)feature.getPreviousSibling(child));
    }
}

