/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal;

import com.vaadin.flow.internal.JacksonUtils;
import java.sql.Date;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.DoubleStream;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import tools.jackson.core.JacksonException;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.ObjectMapper;
import tools.jackson.databind.node.ArrayNode;
import tools.jackson.databind.node.BaseJsonNode;
import tools.jackson.databind.node.DoubleNode;
import tools.jackson.databind.node.ObjectNode;

public class JacksonUtilsTest {
    ObjectMapper mapper = JacksonUtils.getMapper();

    @Test
    public void testEquals() {
        Assertions.assertTrue((boolean)JacksonUtils.jsonEquals((JsonNode)this.mapper.valueToTree((Object)true), (JsonNode)this.mapper.valueToTree((Object)true)));
        Assertions.assertTrue((boolean)JacksonUtils.jsonEquals((JsonNode)this.mapper.valueToTree((Object)"foo"), (JsonNode)this.mapper.valueToTree((Object)"foo")));
        Assertions.assertTrue((boolean)JacksonUtils.jsonEquals((JsonNode)this.mapper.valueToTree((Object)3.14), (JsonNode)this.mapper.valueToTree((Object)3.14)));
        Assertions.assertTrue((boolean)JacksonUtils.jsonEquals((JsonNode)this.mapper.nullNode(), (JsonNode)this.mapper.nullNode()));
        Assertions.assertTrue((boolean)JacksonUtils.jsonEquals((JsonNode)this.createTestObject1(), (JsonNode)this.createTestObject1()));
        Assertions.assertTrue((boolean)JacksonUtils.jsonEquals((JsonNode)this.createTestArray1(), (JsonNode)this.createTestArray1()));
        Assertions.assertFalse((boolean)JacksonUtils.jsonEquals((JsonNode)this.mapper.valueToTree((Object)true), (JsonNode)this.mapper.valueToTree((Object)false)));
        Assertions.assertFalse((boolean)JacksonUtils.jsonEquals((JsonNode)this.mapper.valueToTree((Object)"foo"), (JsonNode)this.mapper.valueToTree((Object)"oof")));
        Assertions.assertFalse((boolean)JacksonUtils.jsonEquals((JsonNode)this.mapper.valueToTree((Object)3.14), (JsonNode)this.mapper.valueToTree((Object)3.142)));
        Assertions.assertFalse((boolean)JacksonUtils.jsonEquals((JsonNode)this.createTestObject1(), (JsonNode)this.createTestObject2()));
        Assertions.assertFalse((boolean)JacksonUtils.jsonEquals((JsonNode)this.createTestArray1(), (JsonNode)this.createTestArray2()));
        Assertions.assertFalse((boolean)JacksonUtils.jsonEquals((JsonNode)this.mapper.valueToTree((Object)true), (JsonNode)this.mapper.valueToTree((Object)"true")));
        Assertions.assertFalse((boolean)JacksonUtils.jsonEquals((JsonNode)this.mapper.valueToTree((Object)3.14), (JsonNode)this.mapper.valueToTree((Object)"3.14")));
        Assertions.assertFalse((boolean)JacksonUtils.jsonEquals((JsonNode)this.mapper.nullNode(), (JsonNode)this.mapper.valueToTree((Object)"null")));
        Assertions.assertFalse((boolean)JacksonUtils.jsonEquals((JsonNode)this.mapper.createObjectNode(), (JsonNode)this.mapper.valueToTree((Object)"{}")));
        Assertions.assertFalse((boolean)JacksonUtils.jsonEquals((JsonNode)this.mapper.createArrayNode(), (JsonNode)this.mapper.valueToTree((Object)0)));
        Assertions.assertFalse((boolean)JacksonUtils.jsonEquals((JsonNode)this.createTestArray1(), (JsonNode)this.createTestObject1()));
    }

    @Test
    public void testEquals_firstNull_throws() {
        Assertions.assertThrows(AssertionError.class, () -> JacksonUtils.jsonEquals(null, (JsonNode)this.mapper.nullNode()));
    }

    @Test
    public void testEquals_secondNull_throws() {
        Assertions.assertThrows(AssertionError.class, () -> JacksonUtils.jsonEquals((JsonNode)this.mapper.nullNode(), null));
    }

    private ObjectNode createTestObject1() {
        ObjectNode object = this.mapper.createObjectNode();
        object.put("foo", "foo");
        object.set("bar", (JsonNode)this.createTestArray1());
        object.set("baz", (JsonNode)this.mapper.createObjectNode());
        return object;
    }

    private ObjectNode createTestObject2() {
        ObjectNode object = this.mapper.createObjectNode();
        object.put("foo", "oof");
        object.set("bar", (JsonNode)this.createTestArray2());
        object.set("baz", (JsonNode)this.mapper.createArrayNode());
        return object;
    }

    private ArrayNode createTestArray1() {
        return (ArrayNode)Stream.of(this.mapper.valueToTree((Object)"foo"), this.mapper.createObjectNode()).collect(JacksonUtils.asArray());
    }

    private ArrayNode createTestArray2() {
        return (ArrayNode)Stream.of(this.mapper.valueToTree((Object)"bar"), this.mapper.createArrayNode()).collect(JacksonUtils.asArray());
    }

    @Test
    public void collectEmptyStream() {
        Stream jsonValueStream = Stream.empty();
        ArrayNode a = (ArrayNode)jsonValueStream.collect(JacksonUtils.asArray());
        Assertions.assertEquals((int)0, (int)a.size());
    }

    @Test
    public void testStream() {
        ArrayNode array = this.createTestArray1();
        List list = JacksonUtils.stream((ArrayNode)array).toList();
        Assertions.assertEquals((int)2, (int)list.size());
        Assertions.assertEquals((Object)"foo", (Object)((JsonNode)list.get(0)).textValue());
        Assertions.assertTrue((boolean)JacksonUtils.jsonEquals((JsonNode)((JsonNode)list.get(1)), (JsonNode)this.mapper.createObjectNode()));
    }

    @Test
    public void testObjectStream() {
        ArrayNode array = (ArrayNode)Stream.of(this.mapper.createObjectNode(), this.createTestObject1(), this.createTestObject2()).collect(JacksonUtils.asArray());
        List objects = JacksonUtils.objectStream((ArrayNode)array).toList();
        Assertions.assertEquals((int)3, (int)objects.size());
        Assertions.assertTrue((boolean)JacksonUtils.jsonEquals((JsonNode)this.mapper.createObjectNode(), (JsonNode)((JsonNode)objects.get(0))));
        Assertions.assertTrue((boolean)JacksonUtils.jsonEquals((JsonNode)this.createTestObject1(), (JsonNode)((JsonNode)objects.get(1))));
        Assertions.assertTrue((boolean)JacksonUtils.jsonEquals((JsonNode)this.createTestObject2(), (JsonNode)((JsonNode)objects.get(2))));
    }

    @Test
    public void testNumberStream() {
        double[] values = new double[]{3.14, 42.0, Double.MAX_VALUE};
        ArrayNode array = (ArrayNode)DoubleStream.of(values).mapToObj(obj -> this.mapper.valueToTree((Object)obj)).map(obj -> (DoubleNode)obj).collect(JacksonUtils.asArray());
        DoubleStream numberStream = JacksonUtils.numberStream((ArrayNode)array);
        Assertions.assertArrayEquals((double[])values, (double[])numberStream.toArray(), (double)0.0);
    }

    @Test
    public void testAsArray() {
        Stream stream = JacksonUtils.stream((ArrayNode)this.createTestArray1());
        ArrayNode array = (ArrayNode)stream.collect(JacksonUtils.asArray());
        Assertions.assertTrue((boolean)JacksonUtils.jsonEquals((JsonNode)this.createTestArray1(), (JsonNode)array));
    }

    @Test
    public void testCreateArray() {
        ArrayNode array = JacksonUtils.createArray((JsonNode[])new JsonNode[]{this.mapper.valueToTree((Object)"string"), this.mapper.nullNode()});
        Assertions.assertEquals((int)2, (int)array.size());
        Assertions.assertEquals((Object)"string", (Object)array.get(0).asString());
        Assertions.assertTrue((boolean)array.get(1).isNull());
    }

    @Test
    public void testCreateEmptyArray() {
        ArrayNode array = JacksonUtils.createArray((JsonNode[])new JsonNode[0]);
        Assertions.assertEquals((int)0, (int)array.size());
    }

    @Test
    public void createObject() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("integer", 3);
        map.put("string", "foo");
        ObjectNode object = JacksonUtils.createObject(map, item -> {
            if (item instanceof Integer) {
                return this.mapper.valueToTree((Object)((Integer)item).doubleValue());
            }
            return this.mapper.valueToTree((Object)String.valueOf(item));
        });
        Assertions.assertEquals((int)2, (int)JacksonUtils.getKeys((JsonNode)object).size());
        Assertions.assertEquals((float)3.0f, (float)object.get("integer").asInt(), (float)0.0f);
        Assertions.assertEquals((Object)"foo", (Object)object.get("string").asString());
    }

    @Test
    public void testCreateEmptyObject() {
        ObjectNode object = JacksonUtils.createObject(Collections.emptyMap(), item -> {
            throw new AssertionError((Object)"Callback should not be called");
        });
        Assertions.assertEquals((int)0, (int)JacksonUtils.getKeys((JsonNode)object).size());
    }

    @Test
    public void simpleBeanToJson() {
        ObjectNode json = JacksonUtils.beanToJson((Object)new SimpleBean());
        Assertions.assertEquals((Object)"value", (Object)json.get("string").asString());
        Assertions.assertEquals((double)1.0, (double)json.get("number").asDouble(), (double)0.0);
        Assertions.assertEquals((double)2.3f, (double)json.get("flt").floatValue(), (double)0.0);
        Assertions.assertEquals((double)4.56, (double)json.get("dbl").asDouble(), (double)0.0);
    }

    @Test
    public void nestedBeanToJson() {
        ObjectNode json = JacksonUtils.beanToJson((Object)new ParentBean());
        Assertions.assertEquals((Object)"parent", (Object)json.get("parentValue").asString());
        JsonNode child = json.get("child");
        Assertions.assertEquals((Object)"child", (Object)child.get("childValue").asString());
    }

    @Test
    public void beanWithTimeFields() {
        BeanWithTemporalFields bean = new BeanWithTemporalFields();
        ObjectNode json = JacksonUtils.beanToJson((Object)bean);
        Assertions.assertTrue((boolean)JacksonUtils.jsonEquals((JsonNode)JacksonUtils.createNode((Object)"10:23:55"), (JsonNode)json.get("localTime")), (String)"LocalTime not serialized as expected");
        Assertions.assertTrue((boolean)JacksonUtils.jsonEquals((JsonNode)JacksonUtils.createNode((Object)"2024-06-26"), (JsonNode)json.get("localDate")), (String)"LocalDate not serialized as expected");
        Assertions.assertTrue((boolean)JacksonUtils.jsonEquals((JsonNode)JacksonUtils.createNode((Object)"2024-06-26T10:23:55"), (JsonNode)json.get("localDateTime")), (String)"LocalDateTime not serialized as expected");
        Assertions.assertEquals((long)bean.zonedDateTime.toEpochSecond(), (long)ZonedDateTime.parse(json.get("zonedDateTime").asString()).toEpochSecond(), (String)"ZonedDateTime not serialized as expected");
        Assertions.assertEquals((long)bean.sqlDate.getTime(), (long)ZonedDateTime.parse(json.get("sqlDate").asString()).toInstant().toEpochMilli(), (String)"ZonedDateTime not serialized as expected");
        Assertions.assertEquals((long)bean.date.getTime(), (long)ZonedDateTime.parse(json.get("date").asString()).toInstant().toEpochMilli(), (String)"ZonedDateTime not serialized as expected");
        Assertions.assertEquals((double)10.0, (double)Duration.parse(json.get("duration").asString()).toSeconds(), (double)0.0);
    }

    @Test
    public void nullChildBean() {
        ParentBean bean = new ParentBean();
        bean.child = null;
        ObjectNode json = JacksonUtils.beanToJson((Object)bean);
        Assertions.assertEquals((Object)this.mapper.nullNode(), (Object)json.get("child"));
    }

    @Test
    public void beanWithListAndMap() {
        ListAndMapBean bean = new ListAndMapBean();
        ObjectNode json = JacksonUtils.beanToJson((Object)bean);
        JsonNode integerMap = json.get("integerMap");
        Assertions.assertEquals((float)1.0f, (float)integerMap.get("one").asInt(), (float)0.0f);
        Assertions.assertEquals((float)2.0f, (float)integerMap.get("two").asInt(), (float)0.0f);
        JsonNode childBeanMap = json.get("childBeanMap");
        JsonNode firstChild = childBeanMap.get("First");
        Assertions.assertEquals((Object)"firstChildValue", (Object)firstChild.get("childValue").asString());
        JsonNode secondChild = childBeanMap.get("Second");
        Assertions.assertEquals((Object)"secondChildValue", (Object)secondChild.get("childValue").asString());
        JsonNode integerList = json.get("integerList");
        Assertions.assertEquals((float)3.0f, (float)integerList.get(0).asInt(), (float)0.0f);
        Assertions.assertEquals((float)2.0f, (float)integerList.get(1).asInt(), (float)0.0f);
        Assertions.assertEquals((float)1.0f, (float)integerList.get(2).asInt(), (float)0.0f);
        JsonNode childBeanList = json.get("childBeanList");
        Assertions.assertEquals((Object)"firstChildValue", (Object)childBeanList.get(0).get("childValue").asString());
        Assertions.assertEquals((Object)"secondChildValue", (Object)childBeanList.get(1).get("childValue").asString());
    }

    @Test
    public void simpleBeanListToJson() {
        ArrayList<SimpleBean> list = new ArrayList<SimpleBean>();
        SimpleBean bean1 = new SimpleBean();
        bean1.string = "bean1";
        SimpleBean bean2 = new SimpleBean();
        bean2.string = "bean2";
        list.add(bean1);
        list.add(bean2);
        ArrayNode json = JacksonUtils.listToJson(list);
        Assertions.assertEquals((Object)"bean1", (Object)json.get(0).get("string").asString());
        Assertions.assertEquals((Object)"bean2", (Object)json.get(1).get("string").asString());
    }

    @Test
    public void simpleMapToJson() {
        HashMap<String, SimpleBean> map = new HashMap<String, SimpleBean>();
        SimpleBean bean1 = new SimpleBean();
        bean1.string = "bean1";
        SimpleBean bean2 = new SimpleBean();
        bean2.string = "bean2";
        map.put("one", bean1);
        map.put("two", bean2);
        ObjectNode json = JacksonUtils.mapToJson(map);
        Assertions.assertEquals((Object)"bean1", (Object)json.get("one").get("string").asString());
        Assertions.assertEquals((Object)"bean2", (Object)json.get("two").get("string").asString());
    }

    @Test
    public void testReadObject() {
        ObjectNode jsonObject = this.mapper.createObjectNode();
        jsonObject.put("name", "Foo");
        jsonObject.put("age", 30.5);
        jsonObject.put("canSwim", true);
        Person person = (Person)JacksonUtils.readToObject((JsonNode)jsonObject, Person.class);
        Assertions.assertEquals((Object)"Foo", (Object)person.name);
        Assertions.assertEquals((double)30.5, (double)person.age, (double)0.0);
        Assertions.assertTrue((boolean)person.canSwim);
    }

    @Test
    public void toFileJson() throws JacksonException {
        ObjectNode json = JacksonUtils.beanToJson((Object)new ParentBean());
        Assertions.assertEquals((Object)"{\n  \"child\": {\n    \"childValue\": \"child\"\n  },\n  \"parentValue\": \"parent\"\n}", (Object)JacksonUtils.toFileJson((JsonNode)json).replace("\r\n", "\n"));
    }

    @Test
    public void writeValue_nullReturnsNullNode() {
        BaseJsonNode result = JacksonUtils.writeValue(null);
        Assertions.assertTrue((boolean)result.isNull(), (String)"Expected NullNode");
        Assertions.assertEquals((Object)this.mapper.nullNode(), (Object)result);
    }

    public static class SimpleBean {
        private String string = "value";
        private int number = 1;
        private float flt = 2.3f;
        private double dbl = 4.56;

        public String getString() {
            return this.string;
        }

        public int getNumber() {
            return this.number;
        }

        public float getFlt() {
            return this.flt;
        }

        public double getDbl() {
            return this.dbl;
        }
    }

    public static class ParentBean {
        private String parentValue = "parent";
        private ChildBean child = new ChildBean();

        public String getParentValue() {
            return this.parentValue;
        }

        public ChildBean getChild() {
            return this.child;
        }
    }

    public static class BeanWithTemporalFields {
        public LocalTime localTime = LocalTime.of(10, 23, 55);
        public LocalDate localDate = LocalDate.of(2024, 6, 26);
        public LocalDateTime localDateTime = this.localDate.atTime(this.localTime);
        public Date sqlDate = Date.valueOf(this.localDate);
        public java.util.Date date = new java.util.Date(this.sqlDate.getTime());
        public ZonedDateTime zonedDateTime = ZonedDateTime.of(this.localDateTime, ZoneId.of("Europe/Rome"));
        public Duration duration = Duration.ofSeconds(10L);
    }

    public static class ChildBean {
        private String childValue = "child";

        public String getChildValue() {
            return this.childValue;
        }
    }

    public static class ListAndMapBean {
        private Map<String, Integer> integerMap = new HashMap<String, Integer>();
        private Map<String, ChildBean> childBeanMap = new HashMap<String, ChildBean>();
        private List<Integer> integerList = new ArrayList<Integer>();
        private List<ChildBean> childBeanList = new ArrayList<ChildBean>();

        public ListAndMapBean() {
            this.integerMap.put("one", 1);
            this.integerMap.put("two", 2);
            this.integerList.add(3);
            this.integerList.add(2);
            this.integerList.add(1);
            ChildBean firstChild = new ChildBean();
            firstChild.childValue = "firstChildValue";
            this.childBeanMap.put("First", firstChild);
            ChildBean secondChild = new ChildBean();
            secondChild.childValue = "secondChildValue";
            this.childBeanMap.put("Second", secondChild);
            this.childBeanList.add(firstChild);
            this.childBeanList.add(secondChild);
        }

        public Map<String, Integer> getIntegerMap() {
            return this.integerMap;
        }

        public List<ChildBean> getChildBeanList() {
            return this.childBeanList;
        }

        public List<Integer> getIntegerList() {
            return this.integerList;
        }

        public Map<String, ChildBean> getChildBeanMap() {
            return this.childBeanMap;
        }
    }

    public record Person(String name, double age, boolean canSwim) {
    }
}

